/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.stateful;

import com.sas.svcs.cluster.balance.StickyRandomPolicy;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Service;

@Service
public class DropBox
implements DisposableBean {
    private static final Logger LOGGER = LogManager.getLogger(DropBox.class);
    private static final long DEFAULT_TIMEOUT = 300000L;
    private final Timer _timer;
    private final Map<String, RemovalEvent> _itemMap;

    public DropBox() {
        String timerName = this.getClass().getName() + " timer";
        this._timer = new Timer(timerName, true);
        this._itemMap = new HashMap<String, RemovalEvent>();
    }

    public Object retrieve(String dropBoxKey) {
        LOGGER.debug("retrieving item with key " + dropBoxKey);
        Properties p = StickyRandomPolicy.parseDropBoxKey(dropBoxKey);
        String dropBoxID = p.getProperty("dropboxid");
        RemovalEvent event = this.removeItem(dropBoxID, 0);
        if (event == null) {
            LOGGER.debug("no item for id " + dropBoxID);
            throw new IllegalStateException();
        }
        Object item = event != null ? event.getItem() : null;
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String store(Object item, RemovalNotificationInterface callback, long timeoutMillis) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (this.hasItem(item)) {
            throw new IllegalStateException("item already in drop box: " + item);
        }
        String dropBoxID = UUID.randomUUID().toString();
        RemovalEvent event = new RemovalEvent(item, callback);
        Map<String, RemovalEvent> map = this._itemMap;
        synchronized (map) {
            this._itemMap.put(dropBoxID, event);
        }
        ServiceObjectExpirationTask expirationTask = new ServiceObjectExpirationTask(dropBoxID);
        long to = timeoutMillis > 0L ? timeoutMillis : 300000L;
        this._timer.schedule((TimerTask)expirationTask, to);
        URI statefulServiceURI = StickyRandomPolicy.getSelectedURI();
        String dropBoxKey = StickyRandomPolicy.createDropBoxKey(dropBoxID, statefulServiceURI);
        LOGGER.debug("storing item with key " + dropBoxKey);
        return dropBoxKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        LOGGER.debug("destroy() called");
        HashSet<Map.Entry<String, RemovalEvent>> entrySet = new HashSet<Map.Entry<String, RemovalEvent>>();
        Map<String, RemovalEvent> map = this._itemMap;
        synchronized (map) {
            this._timer.cancel();
            Set<Map.Entry<String, RemovalEvent>> set = this._itemMap.entrySet();
            entrySet.addAll(set);
            this._itemMap.clear();
        }
        for (Map.Entry entry : entrySet) {
            RemovalEvent event = (RemovalEvent)entry.getValue();
            this.fireEvent(event, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemovalEvent removeItem(String dropBoxID, int type) {
        RemovalEvent event = null;
        Map<String, RemovalEvent> map = this._itemMap;
        synchronized (map) {
            event = this._itemMap.remove(dropBoxID);
        }
        this.fireEvent(event, type);
        return event;
    }

    private void fireEvent(RemovalEvent event, int type) {
        if (event != null) {
            Object item = event.getItem();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("stored item removal type=" + type + " item=" + item);
            }
            event.fire(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasItem(Object item) {
        Map<String, RemovalEvent> map = this._itemMap;
        synchronized (map) {
            if (this._itemMap.isEmpty()) {
                return false;
            }
            Collection<RemovalEvent> eventBag = this._itemMap.values();
            for (RemovalEvent event : eventBag) {
                Object i = event.getItem();
                if (i != item) continue;
                return true;
            }
            return false;
        }
    }

    protected static boolean isKey(String str) {
        return StickyRandomPolicy.isDropBoxKey(str);
    }

    protected static URI getStatefulServiceURI(String dropBoxKey) {
        return StickyRandomPolicy.getStatefulServiceURI(dropBoxKey);
    }

    private class ServiceObjectExpirationTask
    extends TimerTask {
        private final String _dropBoxID;

        private ServiceObjectExpirationTask(String dropBoxID) {
            this._dropBoxID = dropBoxID;
        }

        @Override
        public void run() {
            DropBox.this.removeItem(this._dropBoxID, 1);
        }
    }

    public static class RemovalEvent {
        public static final int TYPE_RETRIEVAL = 0;
        public static final int TYPE_EXPIRATION = 1;
        private int _type;
        private final Object _item;
        private final RemovalNotificationInterface _callback;

        private RemovalEvent(Object item, RemovalNotificationInterface callback) {
            this._item = item;
            this._callback = callback;
        }

        public int getType() {
            return this._type;
        }

        public Object getItem() {
            return this._item;
        }

        private void fire(int type) {
            this._type = type;
            try {
                if (this._callback != null) {
                    this._callback.handleRemoval(this);
                }
            }
            catch (Throwable t) {
                LOGGER.error("removal notification callback threw exception", t);
            }
        }
    }

    public static interface RemovalNotificationInterface {
        public void handleRemoval(RemovalEvent var1);
    }
}

