/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.content;

import com.sas.framework.annotation.services.Content;
import com.sas.framework.services.config.dao.ServiceAlias;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.httpinvoker.content.ContentAliasExporter;
import com.sas.svcs.cluster.httpinvoker.content.DiscoveredServicesInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public class DiscoveredServicesMap<T>
implements DiscoveredServicesInterface<T>,
BeanPostProcessor {
    private static final String SAS_AUTO_CONTENT_ALIASES = "/sas/auto/content/aliases/";
    private final Map<String, T> services = new HashMap<String, T>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private Class<T> serviceInterface;
    private ServiceURLDAO serviceURLDAO;

    public DiscoveredServicesMap(Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServices(Map<String, T> services) {
        this.services.clear();
        this.services.putAll(services);
    }

    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        this.serviceURLDAO = serviceURLDAO;
    }

    public void addService(String objectType, T service) {
        this.services.put(objectType, service);
    }

    @Override
    public T getService(String objectType) {
        String realType = this.aliases.get(objectType);
        if (null == realType && null == (realType = this.getRealType(objectType))) {
            realType = objectType;
        }
        return this.services.get(realType);
    }

    public Collection<String> getSupportedObjectTypes() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.services.keySet());
        ret.addAll(this.aliases.keySet());
        return ret;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.serviceInterface.isInstance(bean)) {
            Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
            Content content = (Content)AnnotationUtils.findAnnotation((Class)clazz, Content.class);
            if (content != null) {
                String[] objectTypes = content.objectTypes();
                if (objectTypes == null || objectTypes.length == 0) {
                    throw new IllegalStateException("Services annotated with 'Content' must include an objectType.");
                }
                for (String objectType : objectTypes) {
                    this.services.put(objectType, bean);
                }
            }
        } else if (this.isAliased(bean)) {
            ContentAliasExporter cae = (ContentAliasExporter)bean;
            if (this.serviceInterface.getName().equals(cae.getServiceInterface())) {
                this.aliases.put(cae.getObjectType(), cae.getAliasType());
            }
        }
        return bean;
    }

    private boolean isAliased(Object bean) {
        return ClassUtils.isAssignable(ContentAliasExporter.class, bean.getClass());
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private String getRealType(String objectType) {
        ServiceAlias serviceAlias;
        String realType = null;
        if (null != objectType && null != this.serviceURLDAO && null != (serviceAlias = this.serviceURLDAO.getAlias(this.newServiceAlias(objectType)))) {
            realType = serviceAlias.getAliasType();
        }
        return realType;
    }

    private ServiceAlias newServiceAlias(String objectType) {
        ServiceAlias serviceAlias = new ServiceAlias();
        serviceAlias.setContext(SAS_AUTO_CONTENT_ALIASES);
        serviceAlias.setObjectType(objectType);
        serviceAlias.setServiceInterface(this.serviceInterface.getName());
        return serviceAlias;
    }
}

