/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.content;

import com.sas.framework.services.config.dao.ServiceURL;
import com.sas.svcs.cluster.httpinvoker.ServicePublisher;
import com.sas.svcs.cluster.httpinvoker.content.AutoDiscoveredContentServiceExporter;
import java.util.Date;
import org.springframework.util.ClassUtils;

public class ContentServicePublisher
extends ServicePublisher {
    private static final String CONTENT_SERVICE_PREFIX = "/sas/auto/content/services/";

    public ContentServicePublisher() {
        super(CONTENT_SERVICE_PREFIX);
    }

    @Override
    public ServiceURL newServiceURL(Object bean, String beanName, Date date) {
        return ContentServicePublisher.newContentServiceURL(this.getServiceInterface(bean, beanName), this.getServletContext(), this.getServletName(bean, beanName), date, this.getPublishContext(), this.getObjectType(bean));
    }

    @Override
    protected String makeKey(Object bean, String beanName) {
        AutoDiscoveredContentServiceExporter exporter = (AutoDiscoveredContentServiceExporter)((Object)bean);
        return ContentServicePublisher.getKey(exporter.getServiceInterfaceName(), exporter.getObjectType());
    }

    @Override
    protected String getServiceInterface(Object bean, String beanName) {
        AutoDiscoveredContentServiceExporter exporter = (AutoDiscoveredContentServiceExporter)((Object)bean);
        return exporter.getServiceInterfaceName();
    }

    protected String getObjectType(Object bean) {
        AutoDiscoveredContentServiceExporter exporter = (AutoDiscoveredContentServiceExporter)((Object)bean);
        return exporter.getObjectType();
    }

    @Override
    protected boolean isPublishable(Object bean, String beanName) {
        return ClassUtils.isAssignable(AutoDiscoveredContentServiceExporter.class, bean.getClass());
    }

    @Override
    protected String makeUrl(Object bean, String beanName) {
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getProtocol());
        buf.append("://");
        buf.append(this.getHost()).append(':').append(this.getPort());
        buf.append(this.getContext()).append(beanName);
        return buf.toString();
    }

    protected static String getKey(String serviceInterface, String objectType) {
        return CONTENT_SERVICE_PREFIX + serviceInterface + '-' + objectType;
    }

    public static ServiceURL newContentServiceURL(String service, String servletContext, String servlet, Date updatedDTTM, String context, String objectType) {
        ServiceURL serviceURL = new ServiceURL(service, servletContext, servlet, updatedDTTM, context);
        serviceURL.setObjectType(objectType);
        return serviceURL;
    }
}

