/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.annotation;

import com.sas.framework.annotation.services.DeletesStateful;
import com.sas.framework.annotation.services.ReturnsStateful;
import com.sas.framework.annotation.services.Stateful;
import com.sas.framework.annotation.services.StatefulObjectFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class StatefulMetadata {
    Class<?> type;
    boolean isStatefulObjectFactory = false;
    boolean isStatefulObject = false;
    HashMap<String, Class<?>> returnMethods = new HashMap();
    HashSet<String> deleteMethods = new HashSet();

    public StatefulMetadata(Class<?> type) {
        this.type = type;
        this.isStatefulObjectFactory = AnnotationUtils.findAnnotation(type, StatefulObjectFactory.class) != null;
        this.isStatefulObject = AnnotationUtils.findAnnotation(type, Stateful.class) != null;
        this.returnMethods.putAll(this.getReturnMethods(type));
        this.deleteMethods.addAll(this.getDeleteMethods(type));
    }

    public String toString() {
        return "StatefulMetadata [deleteMethods=" + this.deleteMethods + ", isStatefulObject=" + this.isStatefulObject + ", isStatefulObjectFactory=" + this.isStatefulObjectFactory + ", returnMethods=" + this.returnMethods + "]";
    }

    private Map<String, Class<?>> getReturnMethods(Class<?> type) {
        final HashMap returnMethods = new HashMap();
        StatefulMetadata.doWithAllMethods(type, new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                ReturnsStateful rs = (ReturnsStateful)StatefulMetadata.findAnnotation(method, ReturnsStateful.class);
                Class<?> returnClass = rs.statefulInterface();
                if (ReturnsStateful.DEFAULT.class == returnClass) {
                    returnClass = method.getReturnType();
                }
                returnMethods.put(method.getName(), returnClass);
            }
        }, new ReturnsStatefulFilter());
        return returnMethods;
    }

    private Set<String> getDeleteMethods(Class<?> type) {
        final HashSet<String> deleteMethods = new HashSet<String>();
        StatefulMetadata.doWithAllMethods(type, new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                deleteMethods.add(method.getName());
            }
        }, new DeletesStatefulFilter());
        return deleteMethods;
    }

    static void doWithAllMethods(Class<?> type, ReflectionUtils.MethodCallback callback, ReflectionUtils.MethodFilter filter) {
        if (!type.isInterface()) {
            ReflectionUtils.doWithMethods(type, (ReflectionUtils.MethodCallback)callback, (ReflectionUtils.MethodFilter)filter);
        } else {
            Method[] methods = type.getDeclaredMethods();
            for (Method method : methods) {
                if (filter != null && !filter.matches(method)) continue;
                try {
                    callback.doWith(method);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
                }
            }
            for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                StatefulMetadata.doWithAllMethods(genericDeclaration, callback, filter);
            }
        }
    }

    private static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        Object annotation = method.getAnnotation(annotationType);
        if (null != annotation) {
            return annotation;
        }
        Class<?> declarationLocation = method.getDeclaringClass();
        if (!declarationLocation.isInterface()) {
            Class<?>[] interfaces = declarationLocation.getInterfaces();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (Class<?> intrfc : interfaces) {
                try {
                    Method m = intrfc.getMethod(method.getName(), parameterTypes);
                    annotation = AnnotationUtils.findAnnotation((Method)m, annotationType);
                    if (null != annotation) {
                        return annotation;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    static class DeletesStatefulFilter
    implements ReflectionUtils.MethodFilter {
        DeletesStatefulFilter() {
        }

        public boolean matches(Method method) {
            return method.getAnnotation(DeletesStateful.class) != null;
        }
    }

    static class ReturnsStatefulFilter
    implements ReflectionUtils.MethodFilter {
        ReturnsStatefulFilter() {
        }

        public boolean matches(Method method) {
            boolean found = StatefulMetadata.findAnnotation(method, ReturnsStateful.class) != null;
            return found;
        }
    }
}

