/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.annotation;

import com.sas.framework.annotation.services.Publishable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;

class PublishableServiceMetadata {
    Class<?> beanType;
    String beanName;

    public PublishableServiceMetadata(String beanName, Class<?> beanType) {
        this.beanName = beanName;
        this.beanType = beanType;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return AnnotationUtils.findAnnotation(this.beanType, annotation) != null;
    }

    private static void getPublishedInterfaces(Class<?> targetType, Set<Class<?>> matches, Set<Class<?>> seen) {
        if (seen.contains(targetType)) {
            return;
        }
        seen.add(targetType);
        Class<?>[] targetInterfaces = targetType.getInterfaces();
        Publishable ap = targetType.getAnnotation(Publishable.class);
        if (ap != null) {
            Class<?>[] annotationInterfaces = ap.interfaces();
            if (annotationInterfaces != null && annotationInterfaces.length > 0) {
                matches.addAll(Arrays.asList(annotationInterfaces));
            } else if (targetType.isInterface()) {
                matches.add(targetType);
            } else {
                matches.addAll(Arrays.asList(targetInterfaces));
            }
        }
        for (Class<?> targetInterface : targetInterfaces) {
            PublishableServiceMetadata.getPublishedInterfaces(targetInterface, matches, seen);
        }
        Class<?> superClass = targetType.getSuperclass();
        if (superClass != null) {
            PublishableServiceMetadata.getPublishedInterfaces(superClass, matches, seen);
        }
    }

    public Class<?>[] getPublishedInterfaces() {
        HashSet matches = new HashSet();
        PublishableServiceMetadata.getPublishedInterfaces(this.beanType, matches, new HashSet());
        return matches.toArray(new Class[matches.size()]);
    }
}

