/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.annotation;

import com.sas.framework.annotation.services.Content;
import com.sas.framework.annotation.services.StatefulObjectFactory;
import com.sas.svcs.cluster.httpinvoker.annotation.ContentAnnotationProcessor;
import com.sas.svcs.cluster.httpinvoker.annotation.DefaultPublishableServiceScanner;
import com.sas.svcs.cluster.httpinvoker.annotation.DefaultRootBeanClassProvider;
import com.sas.svcs.cluster.httpinvoker.annotation.DefaultSupplementalBeanDataProvider;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishAnnotationProcessor;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishableServiceMetadata;
import com.sas.svcs.cluster.httpinvoker.annotation.PublishableServiceScanner;
import com.sas.svcs.cluster.httpinvoker.annotation.RootBeanClassProvider;
import com.sas.svcs.cluster.httpinvoker.annotation.StatefulAnnotationProcessor;
import com.sas.svcs.cluster.httpinvoker.annotation.SupplementalBeanDataProvider;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.remoting.support.DefaultRemoteInvocationExecutor;

public class PublishableServiceAnnotationPostProcessor
implements BeanFactoryPostProcessor {
    private static final String REMOTE_EXECUTOR_BEAN_NAME = "com.sas.svcs.remote.executor";
    private static final Logger LOGGER = LogManager.getLogger(PublishableServiceAnnotationPostProcessor.class);
    private RootBeanClassProvider rootClassProvider = new DefaultRootBeanClassProvider();
    private SupplementalBeanDataProvider idProvider = new DefaultSupplementalBeanDataProvider();
    private PublishableServiceScanner scanner = new DefaultPublishableServiceScanner();
    private String excludedPackage;
    private final Map<Class<? extends Annotation>, PublishAnnotationProcessor> processors = new HashMap<Class<? extends Annotation>, PublishAnnotationProcessor>();

    public void setScanner(PublishableServiceScanner scanner) {
        this.scanner = scanner;
    }

    public void setIdProvider(SupplementalBeanDataProvider beanIdProvider) {
        this.idProvider = beanIdProvider;
    }

    public void setRootClassProvider(RootBeanClassProvider provider) {
        this.rootClassProvider = provider;
    }

    public void setExcludedPackage(String excludedPackage) {
        this.excludedPackage = excludedPackage;
    }

    public PublishableServiceAnnotationPostProcessor() {
        this.processors.put(StatefulObjectFactory.class, new StatefulAnnotationProcessor());
        this.processors.put(Content.class, new ContentAnnotationProcessor());
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        boolean debug = LOGGER.isDebugEnabled();
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        BeanDefinitionBuilder executorBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultRemoteInvocationExecutor.class);
        registry.registerBeanDefinition(REMOTE_EXECUTOR_BEAN_NAME, (BeanDefinition)executorBuilder.getBeanDefinition());
        Set<PublishableServiceMetadata> services = this.scanner.findAutoPublishedServices(beanFactory);
        if (debug) {
            LOGGER.debug("Found " + services.size() + " services to publish.");
        }
        for (PublishableServiceMetadata metadata : services) {
            if (debug) {
                LOGGER.debug("Processing " + metadata.beanName + " service.");
            }
            for (Class<?> iface : metadata.getPublishedInterfaces()) {
                String[] ids;
                String interfaceName = iface.getName();
                if (debug) {
                    LOGGER.debug("  interface: " + interfaceName);
                }
                if (null != this.excludedPackage && interfaceName.startsWith(this.excludedPackage)) {
                    LOGGER.debug("Excluding interface publication due to rule: " + interfaceName);
                    continue;
                }
                for (String id : ids = this.idProvider.getSupplementalData(metadata, iface)) {
                    BeanDefinitionBuilder exporterBuilder = BeanDefinitionBuilder.rootBeanDefinition(this.rootClassProvider.getRootBeanClass(metadata, iface));
                    exporterBuilder.addPropertyValue("serviceInterface", (Object)interfaceName);
                    exporterBuilder.addPropertyReference("service", metadata.beanName);
                    exporterBuilder.addPropertyReference("remoteInvocationExecutor", REMOTE_EXECUTOR_BEAN_NAME);
                    for (Map.Entry<Class<? extends Annotation>, PublishAnnotationProcessor> entry : this.processors.entrySet()) {
                        PublishAnnotationProcessor processor = entry.getValue();
                        if (!processor.requiresProcessing(metadata, iface)) continue;
                        processor.process(metadata, exporterBuilder, registry, iface, id);
                    }
                    String beanId = "/" + interfaceName;
                    if (!"".equals(id)) {
                        beanId = beanId + "-" + id;
                    }
                    BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)exporterBuilder.getBeanDefinition(), beanId);
                    BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
                }
            }
        }
    }
}

