/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.annotation;

import com.sas.framework.annotation.services.Content;
import com.sas.framework.annotation.services.ContentAlias;
import com.sas.framework.annotation.services.ContentAliases;
import com.sas.svcs.cluster.httpinvoker.content.ContentAliasExporter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationUtils;

public class ContentAliasAnnotationProcessor
implements BeanFactoryPostProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ContentAliasAnnotationProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        boolean debug = LOGGER.isDebugEnabled();
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        Set<ContentAliasMetadata> services = this.findAliasedServices(beanFactory);
        if (debug) {
            LOGGER.debug("Found " + services.size() + " aliases to publish.");
        }
        for (ContentAliasMetadata metadata : services) {
            if (debug) {
                LOGGER.debug("Processing " + metadata.beanName + " service.");
            }
            Map<String, Class<?>[]> aliases = metadata.getAliasMap();
            String[] objectTypes = metadata.getObjectTypes();
            for (String aliasType : aliases.keySet()) {
                if (debug) {
                    LOGGER.debug("  aliasType: " + aliasType);
                }
                Class<?>[] supportServices = aliases.get(aliasType);
                for (int i = 0; i < supportServices.length; ++i) {
                    Class<?> supportService = supportServices[i];
                    String interfaceName = supportService.getName();
                    for (int j = 0; j < objectTypes.length; ++j) {
                        String objectType = objectTypes[j];
                        String beanId = interfaceName + "-" + objectType;
                        BeanDefinitionBuilder exporterBuilder = BeanDefinitionBuilder.rootBeanDefinition(ContentAliasExporter.class);
                        exporterBuilder.addPropertyValue("serviceInterface", (Object)interfaceName);
                        exporterBuilder.addPropertyValue("objectType", (Object)objectType);
                        exporterBuilder.addPropertyValue("aliasType", (Object)aliasType);
                        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)exporterBuilder.getBeanDefinition(), beanId);
                        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
                    }
                }
            }
        }
    }

    private Set<ContentAliasMetadata> findAliasedServices(ConfigurableListableBeanFactory beanFactory) {
        HashSet<ContentAliasMetadata> aliasedServices = new HashSet<ContentAliasMetadata>();
        HashSet<String> beanNames = new HashSet<String>();
        beanNames.addAll(Arrays.asList(beanFactory.getBeanDefinitionNames()));
        for (String beanName : beanNames) {
            Class beanClass;
            AbstractBeanDefinition abd;
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            Class<?> handlerType = null;
            try {
                String beanClassName = definition.getBeanClassName();
                if (null != beanClassName) {
                    handlerType = Class.forName(beanClassName);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Exception finding type for '" + beanName + "'.", (Throwable)e);
                handlerType = null;
            }
            boolean isAliased = false;
            if (handlerType != null) {
                isAliased = this.isAliased(handlerType);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not get type of bean '" + beanName + "' from bean factory.");
            }
            if (isAliased) {
                aliasedServices.add(new ContentAliasMetadata(beanName, handlerType));
                continue;
            }
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
            if (!(bd instanceof AbstractBeanDefinition) || !(abd = (AbstractBeanDefinition)bd).hasBeanClass() || !this.isAliased(beanClass = abd.getBeanClass())) continue;
            aliasedServices.add(new ContentAliasMetadata(beanName, beanClass));
        }
        return aliasedServices;
    }

    private boolean isAliased(Class<?> clazz) {
        return AnnotationUtils.findAnnotation(clazz, Content.class) != null && (AnnotationUtils.findAnnotation(clazz, ContentAliases.class) != null || AnnotationUtils.findAnnotation(clazz, ContentAlias.class) != null);
    }

    class ContentAliasMetadata {
        Class<?> beanType;
        String beanName;

        public ContentAliasMetadata(String beanName, Class<?> beanType) {
            this.beanName = beanName;
            this.beanType = beanType;
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotation) {
            return AnnotationUtils.findAnnotation(this.beanType, annotation) != null;
        }

        public String[] getObjectTypes() {
            return ((Content)AnnotationUtils.findAnnotation(this.beanType, Content.class)).objectTypes();
        }

        public Map<String, Class<?>[]> getAliasMap() {
            ContentAliases cas = (ContentAliases)AnnotationUtils.findAnnotation(this.beanType, ContentAliases.class);
            HashMap<String, Class<?>[]> ret = new HashMap<String, Class<?>[]>();
            if (cas == null) {
                ContentAlias ca = (ContentAlias)AnnotationUtils.findAnnotation(this.beanType, ContentAlias.class);
                if (ca != null) {
                    this.addContentAlias(ca, ret);
                }
            } else {
                ContentAlias[] caArray = cas.value();
                for (int i = 0; i < caArray.length; ++i) {
                    this.addContentAlias(caArray[i], ret);
                }
            }
            return ret;
        }

        private void addContentAlias(ContentAlias ca, Map<String, Class<?>[]> map) {
            String aliasType = ca.objectType();
            Class[] interfaces = ca.supportServices();
            if (interfaces.length > 0) {
                map.put(aliasType, interfaces);
            }
        }
    }
}

