/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker;

import com.sas.framework.services.config.dao.ServiceURL;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.Publisher;
import com.sas.svcs.cluster.httpinvoker.AutoDiscoveredHttpServiceExporter;
import com.sas.svcs.cluster.httpinvoker.AvailabilityInterface;
import com.sas.svcs.cluster.httpinvoker.AvailabilityService;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.util.ClassUtils;

public class ServicePublisher
extends Publisher
implements DestructionAwareBeanPostProcessor,
ApplicationContextAware,
BeanFactoryPostProcessor {
    public static final String SAS_AUTO_SERVICES = "/sas/auto/services/";
    public static final String SERVICE_PREFIX = "/sas/auto/services/";
    private static final Logger LOGGER = LogManager.getLogger(ServicePublisher.class);
    private static final String URL_TOKEN = "/";
    private final String _context;
    private ServiceURLDAO serviceURLDAO;
    private ApplicationContext applicationContext;

    public ServicePublisher() {
        this._context = "/sas/auto/services/";
    }

    public ServicePublisher(String context) {
        this._context = context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        this.serviceURLDAO = serviceURLDAO;
    }

    @Deprecated
    public void setLocalIpAddress(String localIpAddress) {
        LOGGER.warn("### setLocalIpAddress is deprecated. Use setHost instead. ###");
        this.setHost(localIpAddress);
    }

    @Deprecated
    public void setLocalPort(String localPort) {
        LOGGER.warn("### setLocalPort is deprecated. Use setPort instead. ###");
        this.setPort(localPort);
    }

    @Deprecated
    public void setLocalProtocol(String localProtocol) {
        LOGGER.warn("### setLocalProtocol is deprecated. Use setProtocol instead. ###");
        this.setProtocol(localProtocol);
    }

    @Deprecated
    public void setServiceContext(String serviceContext) {
        LOGGER.warn("### setServiceContext is deprecated. Use setContext instead. ###");
        this.setContext(serviceContext);
    }

    public ServiceURL newServiceURL(Object bean, String beanName, Date date) {
        return ServicePublisher.newServiceURL(this.getServiceInterface(bean, beanName), this.getServletContext(), this.getServletName(bean, beanName), date, this.getPublishContext());
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        if (!factory.containsBean("/availabilityCheck")) {
            HttpInvokerServiceExporter exporter = new HttpInvokerServiceExporter();
            exporter.setServiceInterface(AvailabilityInterface.class);
            exporter.setService((Object)new AvailabilityService());
            exporter.afterPropertiesSet();
            factory.registerSingleton("/availabilityCheck", (Object)exporter);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                HttpInvokerProxyFactoryBean proxy = new HttpInvokerProxyFactoryBean();
                proxy.setServiceInterface(AvailabilityInterface.class);
                proxy.setServiceUrl(ServicePublisher.this.getServletContext() + "/availabilityCheck");
                proxy.afterPropertiesSet();
                AvailabilityInterface availability = (AvailabilityInterface)proxy.getObject();
                boolean available = false;
                while (!available) {
                    try {
                        available = availability.check();
                    }
                    catch (Exception e) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                ServicePublisher.this.publish();
            }
        });
        t.start();
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.isPublishable(bean, beanName) && null != this.serviceURLDAO) {
            ServiceURL serviceURL = this.newServiceURL(bean, beanName, null);
            this.removeServiceURL(serviceURL);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void publish() {
        String[] names;
        for (String name : names = this.applicationContext.getBeanDefinitionNames()) {
            this.publish(this.applicationContext.getBean(name), name);
        }
    }

    public void publish(Object bean, String beanName) {
        if (this.isPublishable(bean, beanName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Publishing service from bean, " + beanName);
            }
            if (null != this.serviceURLDAO) {
                ServiceURL serviceURL = this.newServiceURL(bean, beanName, null);
                this.addServiceURL(serviceURL);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected String makeUrl(Object bean, String beanName) {
        String servletContext = this.getServletContext();
        StringBuilder buf = new StringBuilder(servletContext.length() + beanName.length() + 1);
        buf.append(servletContext);
        if (!servletContext.endsWith(URL_TOKEN) && !beanName.startsWith(URL_TOKEN)) {
            buf.append(URL_TOKEN);
        }
        buf.append(this.getServletName(bean, beanName));
        return buf.toString();
    }

    protected String makeKey(Object bean, String beanName) {
        return "/sas/auto/services/" + this.getServiceInterface(bean, beanName);
    }

    protected String getServiceInterface(Object bean, String beanName) {
        AutoDiscoveredHttpServiceExporter exporter = (AutoDiscoveredHttpServiceExporter)((Object)bean);
        return exporter.getServiceInterfaceName();
    }

    protected boolean isPublishable(Object bean, String beanName) {
        return ClassUtils.isAssignable(AutoDiscoveredHttpServiceExporter.class, bean.getClass());
    }

    protected String getServletContext() {
        StringBuilder buf = new StringBuilder(128).append(this.getProtocol()).append("://").append(this.getHost()).append(':').append(this.getPort()).append(this.getContext());
        return buf.toString();
    }

    protected String getServletName(Object bean, String beanName) {
        return beanName;
    }

    protected boolean addServiceURL(ServiceURL request) {
        boolean wasAdded = false;
        if (null != this.serviceURLDAO) {
            ServiceURL serviceURL = this.serviceURLDAO.getServiceURL(request);
            if (null == serviceURL) {
                ServiceURL addServiceURL = new ServiceURL();
                addServiceURL.setContext(request.getContext());
                addServiceURL.setService(request.getService());
                addServiceURL.setServlet(request.getServlet());
                addServiceURL.setServletContext(request.getServletContext());
                addServiceURL.setObjectType(request.getObjectType());
                addServiceURL.setUpdatedDTTM(new Date());
                wasAdded = this.serviceURLDAO.addServiceURL(addServiceURL);
                serviceURL = addServiceURL;
            } else {
                wasAdded = this.serviceURLDAO.updateServiceURL(serviceURL);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Published service at: " + serviceURL.toString());
            }
        }
        return wasAdded;
    }

    protected boolean removeServiceURL(ServiceURL request) {
        ServiceURL serviceURL;
        boolean wasDeleted = false;
        if (null != this.serviceURLDAO && (wasDeleted = this.serviceURLDAO.delete(serviceURL = ServicePublisher.newServiceURL(request.getService(), request.getServletContext(), request.getServlet(), null, this.getPublishContext()))) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Unpublished service at: " + serviceURL.toString());
        }
        return wasDeleted;
    }

    protected String getPublishContext() {
        return this._context;
    }

    public static ServiceURL newServiceURL(String service, String servletContext, String servlet, Date updatedDTTM, String context) {
        return new ServiceURL(service, servletContext, servlet, updatedDTTM, context);
    }
}

