/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker;

import com.sas.framework.annotation.services.DropBoxKey;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.balance.CacheBasedPolicy;
import com.sas.svcs.cluster.balance.LoadBalancePolicyInterface;
import com.sas.svcs.cluster.balance.StickyRandomPolicy;
import com.sas.svcs.cluster.balance.ZeroResultsException;
import com.sas.svcs.cluster.httpinvoker.UnavailableServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpRetryException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.util.ReflectionUtils;

public class AutoDiscoveredHttpService
extends HttpInvokerProxyFactoryBean
implements InitializingBean {
    private static final String CONNECTION_FACTORY_SHUTDOWN = "Connection factory has been shutdown.";
    private static final Logger LOGGER = LogManager.getLogger(AutoDiscoveredHttpService.class);
    private static final String SERVICE_URL_PLACEHOLDER = "placeholder";
    private static final int DEFAULT_MAX_TRIES = 100;
    private static final int DEFAULT_MAX_FAILURES = 25;
    private static int warningPeriod = Integer.getInteger("sas.auto.initial.warning.period", 3600) * 1000;
    private static int failurePeriod;
    private final int failureSleepPeriod = Integer.getInteger("sas.auto.discovered.failure.sleep.period", 5000);
    private final int zeroResultsSleepPeriod = Integer.getInteger("sas.auto.discovered.zero.results.sleep.period", 15000);
    private int maxTries = Integer.getInteger("sas.auto.discovered.max.tries", 100);
    private int maxFailuresPerUrl = Integer.getInteger("sas.auto.discovered.max.failures", 25);
    private LoadBalancePolicyInterface lbPolicy;
    private long firstAttemptTime = -1L;
    private boolean remoteCallCompleted = false;
    private boolean haveIssuedError = false;
    private final Map<String, Integer> failureMap = new ConcurrentHashMap<String, Integer>();
    private Set<String> acceptsDropBoxKeyMethods = new HashSet<String>();
    private static final ThreadLocal<String> CURRENT_URL;

    public AutoDiscoveredHttpService() {
        this.setServiceUrl(SERVICE_URL_PLACEHOLDER);
    }

    public AutoDiscoveredHttpService(LoadBalancePolicyInterface p, String serviceInterface) {
        this.setLoadBalancePolicy(p);
        this.setServiceUrl(SERVICE_URL_PLACEHOLDER);
        try {
            Class<?> k = Class.forName(serviceInterface);
            this.setServiceInterface(k);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error("Unable to find class: " + serviceInterface + " for creation of bean. Please check your ClassPath and ClassLoader for its availability.");
            IllegalStateException ise = new IllegalStateException("Unable to find class: " + serviceInterface + ". Please check your ClassPath and ClassLoader for its availability.");
            ise.initCause(cnfe);
            throw ise;
        }
    }

    public void setMaximumTries(int t) {
        this.maxTries = t;
    }

    public void setLoadBalancePolicy(LoadBalancePolicyInterface p) {
        this.lbPolicy = p;
    }

    public void setMaximumFailuresPerUrl(int m) {
        this.maxFailuresPerUrl = m;
    }

    public String getServiceUrl() {
        String url = this.getCurrentUrl();
        if (null == url) {
            url = super.getServiceUrl();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Falling back to super.getServiceUrl(): " + url));
            }
        }
        return url;
    }

    public void setServiceUrl(String url) {
        if (!SERVICE_URL_PLACEHOLDER.equals(url)) {
            throw new IllegalStateException("AutoDiscoveredHttpService is just that, automatically discovered. You cannot provide the url for it.");
        }
        this.setCurrentUrl(url);
    }

    protected void setCurrentUrl(String url) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting url for current thread to " + url));
        }
        CURRENT_URL.set(url);
    }

    protected String getCurrentUrl() {
        return CURRENT_URL.get();
    }

    protected void clearCurrentUrl() {
        CURRENT_URL.remove();
    }

    public void setAcceptsDropBoxKeyMethods(Set<String> methods) {
        this.acceptsDropBoxKeyMethods = methods != null ? new HashSet<String>(methods) : new HashSet();
    }

    public void afterPropertiesSet() {
        Class serviceInterface;
        super.afterPropertiesSet();
        if (null == this.lbPolicy) {
            throw new IllegalStateException("AutoDiscoveredHttpService requires a LoadBalancePolicy. Please check your Spring configuration.");
        }
        if (this.acceptsDropBoxKeyMethods.isEmpty()) {
            serviceInterface = this.getServiceInterface();
            for (Method method : serviceInterface.getMethods()) {
                if (!AutoDiscoveredHttpService.acceptsDropBoxKey(method)) continue;
                this.acceptsDropBoxKeyMethods.add(method.getName());
            }
        }
        if (!this.acceptsDropBoxKeyMethods.isEmpty() && !(this.lbPolicy instanceof CacheBasedPolicy)) {
            serviceInterface = this.getServiceInterface();
            String msg = "Service interface " + serviceInterface.getName() + " contains a method that accepts a drop box key, but the load balancing policy for the remote proxy for the service is not a cache-based policy.";
            this.logger.warn((Object)msg);
        }
    }

    protected String getKey() {
        String serviceInterface = this.getServiceInterface().getName();
        return "/sas/auto/services/" + serviceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        this.verifyArgumentSerialization(mi);
        String serviceInterface = this.getServiceInterface().getName();
        int zeroResultsCounter = 0;
        for (int i = 0; i < this.maxTries; ++i) {
            this.handleTimePeriods(serviceInterface);
            String url = null;
            try {
                boolean clearSelectionTarget;
                block45: {
                    URI selectionTarget;
                    clearSelectionTarget = false;
                    String dropBoxKey = null;
                    if (this.acceptsDropBoxKeyMethods.contains(mi.getMethod().getName()) && StickyRandomPolicy.getSelectionTarget() == null && (dropBoxKey = AutoDiscoveredHttpService.getDropBoxKey(mi)) != null) {
                        selectionTarget = StickyRandomPolicy.getStatefulServiceURI(dropBoxKey);
                        StickyRandomPolicy.setSelectionTarget(selectionTarget);
                        clearSelectionTarget = true;
                        StickyRandomPolicy srPolicy = new StickyRandomPolicy();
                        ServiceURLDAO serviceURLDAO = ((CacheBasedPolicy)this.lbPolicy).getServiceURLDAO();
                        srPolicy.setServiceURLDAO(serviceURLDAO);
                        url = (String)srPolicy.choose(this.getKey());
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("No selection target set, dropbox key set to " + dropBoxKey + ", stateful service URI for dropbox key is " + (selectionTarget == null ? "null" : selectionTarget.toString()) + ",  sticky random chose " + url + " for method invocation " + mi.getClass() + "." + mi.getMethod().getName() + " in AutoDiscoveredHttpService " + System.identityHashCode((Object)this)));
                        }
                    } else {
                        url = (String)this.lbPolicy.choose(this.getKey());
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Load balance policy " + this.lbPolicy.getClass().getName() + " chose " + url + " for method invocation " + mi.getClass() + "." + mi.getMethod().getName() + " in AutoDiscoveredHttpService " + System.identityHashCode((Object)this)));
                        }
                    }
                    if (StickyRandomPolicy.getSelectionTarget() == null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Attempting to set the selection target before invoking since it was unset");
                        }
                        try {
                            selectionTarget = new URI(url);
                            StickyRandomPolicy.setSelectionTarget(selectionTarget);
                            clearSelectionTarget = true;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Set the selection target to '" + selectionTarget + "' since it was unset"));
                            }
                        }
                        catch (URISyntaxException use) {
                            if (!this.logger.isWarnEnabled()) break block45;
                            this.logger.warn((Object)("Could net set selection target because the current service url, '" + url + "', does not appear to be a URI"), (Throwable)use);
                        }
                    }
                }
                Object o = null;
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Attempting a call to: " + url + " to satisfy request for interface, " + serviceInterface + " for method invocation " + mi));
                    }
                    this.setCurrentUrl(url);
                    o = super.invoke(mi);
                }
                finally {
                    this.clearCurrentUrl();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Completed call to: " + url + " to satisfy request for interface, " + serviceInterface + " for method invocation " + mi));
                    }
                    if (clearSelectionTarget) {
                        StickyRandomPolicy.clearSelectionTarget();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Cleared selection target since it was set earlier by AutoDiscoveredHttpService");
                        }
                    }
                }
                this.remoteCallCompleted(url);
                Object object = o;
                return object;
            }
            catch (RemoteAccessException e) {
                Throwable cause;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received exception for remote service invocation: " + url + ", " + e.getMessage(), (Throwable)e);
                }
                if ((cause = e.getCause()) instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError || cause instanceof InvalidClassException) {
                    LOGGER.error("Received error when accessing: " + url + " due to the client having a different classpath than the server. Please ensure that your classpath contains all necessary classes for calling this service.");
                    this.remoteCallCompleted(url);
                    throw cause;
                }
                if (cause instanceof NoSuchMethodException) {
                    LOGGER.error("Received error when accessing: " + url + " due to the client having a newer interface version than the server. Please ensure that your server is at least as new as the client.");
                    NoSuchMethodError error = new NoSuchMethodError();
                    error.initCause(cause);
                    this.remoteCallCompleted(url);
                    throw error;
                }
                if (cause instanceof IllegalStateException && CONNECTION_FACTORY_SHUTDOWN.equals(cause.getMessage())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Encountered exception calling service " + url + " because HTTP connection manager is shutdown.", cause);
                    } else {
                        LOGGER.warn("Encountered exception calling service " + url + " because HTTP connection manager is shutdown.");
                    }
                    throw e;
                }
                this.handleFailure(url, e);
                continue;
            }
            catch (ZeroResultsException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Have received " + zeroResultsCounter + " failures while trying to access an auto-discoverable service to satisfy request for '" + serviceInterface + "'. Please ensure that the application and/or process surfacing this interface is still in the process of starting.");
                }
                if (this.remoteCallCompleted) break;
                if (++zeroResultsCounter % 20 == 0) {
                    this.warnAboutTries(zeroResultsCounter, serviceInterface, e);
                }
                Thread.sleep(this.zeroResultsSleepPeriod);
                continue;
            }
            catch (SocketTimeoutException e) {
                LOGGER.info("Received an error perceived as transient for url, " + url + ".", (Throwable)e);
                continue;
            }
            catch (ConnectTimeoutException e) {
                LOGGER.info("Received an error perceived as transient for url, " + url + ".", (Throwable)e);
                continue;
            }
            catch (HttpRetryException e) {
                LOGGER.info("Received an error perceived as transient for url, " + url + ".", (Throwable)e);
                continue;
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (IOException e) {
                this.handleFailure(url, e);
                continue;
            }
            catch (Throwable t) {
                this.remoteCallCompleted(url);
                throw t;
            }
            finally {
                if (!this.remoteCallCompleted) {
                    --i;
                }
            }
        }
        throw new IllegalStateException("No services are available for: " + serviceInterface + ". Is a required process not started?");
    }

    private void remoteCallCompleted(String url) {
        this.updateFailures(this.getKey(), url);
        this.remoteCallCompleted = true;
    }

    private void verifyArgumentSerialization(MethodInvocation mi) {
        ArrayList nonSerializableArgumentClasses = new ArrayList();
        Object[] args = mi.getArguments();
        if (null != args) {
            for (int i = 0; i < args.length; ++i) {
                if (null == args[i] || args[i] instanceof Serializable) continue;
                nonSerializableArgumentClasses.add(args[i].getClass());
            }
            if (nonSerializableArgumentClasses.size() > 0) {
                throw new IllegalArgumentException("One or more arguments are non-null and do not implement java.io.Serializable: " + nonSerializableArgumentClasses);
            }
        }
    }

    private void updateFailures(String key, String url) {
        if (null != key && null != url) {
            this.failureMap.remove(url);
            this.lbPolicy.affirm(key, url);
        }
    }

    private void handleFailure(String url, Throwable problem) throws InterruptedException {
        String key = this.getKey();
        int times = 0;
        Integer timesInteger = this.failureMap.get(url);
        if (null != timesInteger) {
            times = timesInteger;
        }
        if (times >= this.maxFailuresPerUrl && this.remoteCallCompleted) {
            LOGGER.warn("Received " + times + " errors when accessing: " + url + ". Removing from service.", problem);
            this.lbPolicy.remove(key, url);
        } else {
            int newTimes = times + 1;
            this.failureMap.put(url, newTimes);
            if (!this.remoteCallCompleted) {
                if (newTimes % 60 == 0) {
                    this.warnAboutTries(newTimes, url, problem);
                }
                Thread.sleep(this.failureSleepPeriod);
            }
        }
    }

    private void handleTimePeriods(String serviceInterface) {
        if (this.firstAttemptTime < 0L) {
            this.firstAttemptTime = System.currentTimeMillis();
        }
        if (!this.remoteCallCompleted && System.currentTimeMillis() - this.firstAttemptTime > (long)failurePeriod) {
            throw new UnavailableServiceException("The system attempted to find and access a service for interface '" + serviceInterface + "' for " + failurePeriod / 1000 / 60 / 60 + " hours and was unsuccessful.");
        }
        if (!this.remoteCallCompleted && !this.haveIssuedError && System.currentTimeMillis() - this.firstAttemptTime > (long)warningPeriod) {
            LOGGER.error("#############################################################################################\n### Attempting to access service for interface '" + serviceInterface + "' for " + warningPeriod / 1000 / 60 / 60 + " hours. #####\n### Please ensure that the process providing the service is starting. #######################\n### After " + failurePeriod / 1000 / 60 / 60 + " hours, the service will be considered unavailable. ##############################\n#############################################################################################");
            this.haveIssuedError = true;
        }
    }

    private void warnAboutTries(int num, String requestFor, Throwable problem) {
        LOGGER.warn("Have received " + num + " failures while trying to access an auto-discoverable service to satisfy request for '" + requestFor + "'. Please ensure that the application and/or process surfacing this interface is still in the process of starting.");
        LOGGER.debug("Failure WARNing trackback:", problem);
    }

    protected Set<String> getAcceptsDropBoxKeyMethods() {
        return this.acceptsDropBoxKeyMethods;
    }

    protected static boolean acceptsDropBoxKey(Method method) {
        for (Annotation[] annotationArray : method.getParameterAnnotations()) {
            for (Annotation parmAnn : annotationArray) {
                if (!DropBoxKey.class.isAssignableFrom(parmAnn.annotationType())) continue;
                return true;
            }
        }
        for (Annotation[] annotationArray : method.getParameterTypes()) {
            for (Method m : annotationArray.getMethods()) {
                if (!m.isAnnotationPresent(DropBoxKey.class)) continue;
                return true;
            }
            for (Field f : annotationArray.getFields()) {
                if (!f.isAnnotationPresent(DropBoxKey.class)) continue;
                return true;
            }
        }
        return false;
    }

    protected static String getDropBoxKey(MethodInvocation mi) {
        Method method = mi.getMethod();
        Annotation[][] parmAnnsArr = method.getParameterAnnotations();
        if (parmAnnsArr == null || parmAnnsArr.length == 0) {
            return null;
        }
        Object[] argv = mi.getArguments();
        for (int i = 0; i < parmAnnsArr.length; ++i) {
            Annotation[] parmAnns;
            for (Annotation parmAnn : parmAnns = parmAnnsArr[i]) {
                Object object;
                if (!DropBoxKey.class.isAssignableFrom(parmAnn.annotationType()) || (object = argv[i]) == null) continue;
                return object.toString();
            }
        }
        Class<?>[] argt = method.getParameterTypes();
        for (int i = 0; i < argt.length; ++i) {
            Object dropBoxKey;
            Class<?> parmClass = argt[i];
            for (Method method2 : parmClass.getMethods()) {
                if (!method2.isAnnotationPresent(DropBoxKey.class) || (dropBoxKey = ReflectionUtils.invokeMethod((Method)method2, (Object)argv[i])) == null) continue;
                return dropBoxKey.toString();
            }
            for (AccessibleObject accessibleObject : parmClass.getFields()) {
                if (!accessibleObject.isAnnotationPresent(DropBoxKey.class) || (dropBoxKey = ReflectionUtils.getField((Field)accessibleObject, (Object)argv[i])) == null) continue;
                return dropBoxKey.toString();
            }
        }
        return null;
    }

    static {
        CURRENT_URL = new ThreadLocal();
        warningPeriod = warningPeriod > 1200000 ? warningPeriod : 1200000;
        failurePeriod = 2 * warningPeriod;
    }
}

