/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.rpm.payload;

import com.sas.tools.installs.builder.rpm.Comparison;
import com.sas.tools.installs.builder.rpm.Util;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Date;

public class CpioHeader {
    public static final int DEFAULT_FILE_PERMISSION = 420;
    public static final int DEFAULT_DIRECTORY_PERMISSION = 493;
    public static final int FIFO = 1;
    public static final int CDEV = 2;
    public static final int DIR = 4;
    public static final int BDEV = 6;
    public static final int FILE = 8;
    public static final int SYMLINK = 10;
    public static final int SOCKET = 12;
    protected static final int CPIO_HEADER = 110;
    protected static final CharSequence MAGIC = "070701";
    protected static final String TRAILER = "TRAILER!!!";
    protected Charset charset = Charset.forName("ASCII");
    protected int inode;
    protected int type;
    protected int permissions = 420;
    protected int uid;
    protected String uname;
    protected int gid;
    protected String gname;
    protected int nlink = 1;
    protected long mtime;
    protected int filesize;
    protected int devMinor = 1;
    protected int devMajor = 9;
    protected int rdevMinor;
    protected int rdevMajor;
    protected int checksum;
    protected String name;
    protected int flags;

    public CpioHeader() {
    }

    public CpioHeader(String name) {
        this.name = name;
    }

    public CpioHeader(File file) {
        this(file.getAbsolutePath(), file);
    }

    public CpioHeader(String name, URL url) {
        try {
            URLConnection connection = url.openConnection();
            this.mtime = connection.getLastModified();
            this.filesize = connection.getContentLength();
            this.name = Util.normalizePath(name);
            this.setType(8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CpioHeader(String name, File file) {
        this.mtime = file.lastModified();
        this.filesize = (int)file.length();
        this.name = Util.normalizePath(name);
        if (file.isDirectory()) {
            this.setType(4);
        } else {
            this.setType(8);
        }
    }

    public int getType() {
        return this.type;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public int getRdevMajor() {
        return this.rdevMajor;
    }

    public int getRdevMinor() {
        return this.rdevMinor;
    }

    public int getDevMajor() {
        return this.devMajor;
    }

    public int getDevMinor() {
        return this.devMinor;
    }

    public int getMtime() {
        return (int)(this.mtime / 1000L);
    }

    public int getInode() {
        return this.inode;
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getMode() {
        return this.type << 12 | this.permissions & 0xFFF;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setFileSize(int filesize) {
        this.filesize = filesize;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public void setInode(int inode) {
        this.inode = inode;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getUname() {
        return this.uname;
    }

    public String getGname() {
        return this.gname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public void setGname(String gname) {
        this.gname = gname;
    }

    public boolean isLast() {
        return Comparison.equals(TRAILER, this.name);
    }

    public void setLast() {
        this.name = TRAILER;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getFileSize() {
        return this.filesize;
    }

    protected ByteBuffer writeSix(CharSequence data) {
        return this.charset.encode(this.pad(data, 6));
    }

    protected ByteBuffer writeEight(int data) {
        return this.charset.encode(this.pad(Integer.toHexString(data), 8));
    }

    protected CharSequence readSix(CharBuffer buffer) {
        return this.readChars(buffer, 6);
    }

    protected int readEight(CharBuffer buffer) {
        return Integer.parseInt(this.readChars(buffer, 8).toString(), 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharSequence readChars(CharBuffer buffer, int length) {
        if (buffer.remaining() < length) {
            throw new IllegalStateException("Buffer has '" + buffer.remaining() + "' bytes but '" + length + "' are needed.");
        }
        try {
            CharBuffer charBuffer = buffer.subSequence(0, length);
            return charBuffer;
        }
        finally {
            buffer.position(buffer.position() + length);
        }
    }

    protected String pad(CharSequence sequence, int length) {
        while (sequence.length() < length) {
            sequence = "0" + sequence;
        }
        return sequence.toString();
    }

    protected int skip(ReadableByteChannel channel, int total) throws IOException {
        int skipped = Util.difference(total, 3);
        Util.fill(channel, skipped);
        return skipped;
    }

    public int skip(WritableByteChannel channel, int total) throws IOException {
        int skipped = Util.difference(total, 3);
        Util.empty(channel, ByteBuffer.allocate(skipped));
        return skipped;
    }

    public int read(ReadableByteChannel channel, int total) throws IOException {
        total += this.skip(channel, total);
        ByteBuffer descriptor = Util.fill(channel, 110);
        CharBuffer buffer = this.charset.decode(descriptor);
        CharSequence magic = this.readSix(buffer);
        if (!Comparison.equals(MAGIC, magic)) {
            throw new IllegalStateException("Invalid magic number '" + magic + "' of length '" + magic.length() + "'.");
        }
        this.inode = this.readEight(buffer);
        int mode = this.readEight(buffer);
        this.permissions = mode & 0xFFF;
        this.type = mode >>> 12;
        this.uid = this.readEight(buffer);
        this.gid = this.readEight(buffer);
        this.nlink = this.readEight(buffer);
        this.mtime = 1000L * (long)this.readEight(buffer);
        this.filesize = this.readEight(buffer);
        this.devMajor = this.readEight(buffer);
        this.devMinor = this.readEight(buffer);
        this.rdevMajor = this.readEight(buffer);
        this.rdevMinor = this.readEight(buffer);
        int namesize = this.readEight(buffer);
        this.checksum = this.readEight(buffer);
        total += 110;
        this.name = this.charset.decode(Util.fill(channel, namesize - 1)).toString();
        Util.fill(channel, 1);
        total += namesize;
        total += this.skip(channel, total);
        return total;
    }

    public int write(WritableByteChannel channel, int total) throws IOException {
        ByteBuffer buffer = this.charset.encode(CharBuffer.wrap(this.name));
        int length = buffer.remaining() + 1;
        ByteBuffer descriptor = ByteBuffer.allocate(110);
        descriptor.put(this.writeSix(MAGIC));
        descriptor.put(this.writeEight(this.inode));
        descriptor.put(this.writeEight(this.getMode()));
        descriptor.put(this.writeEight(this.uid));
        descriptor.put(this.writeEight(this.gid));
        descriptor.put(this.writeEight(this.nlink));
        descriptor.put(this.writeEight((int)(this.mtime / 1000L)));
        descriptor.put(this.writeEight(this.filesize));
        descriptor.put(this.writeEight(this.devMajor));
        descriptor.put(this.writeEight(this.devMinor));
        descriptor.put(this.writeEight(this.rdevMajor));
        descriptor.put(this.writeEight(this.rdevMinor));
        descriptor.put(this.writeEight(length));
        descriptor.put(this.writeEight(this.checksum));
        descriptor.flip();
        Util.empty(channel, descriptor);
        Util.empty(channel, buffer);
        Util.empty(channel, ByteBuffer.allocate(1));
        return (total += 110 + length) + this.skip(channel, total);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Inode: ").append(this.inode).append("\n");
        builder.append("Permission: ").append(Integer.toString(this.permissions, 8)).append("\n");
        builder.append("Type: ").append(this.type).append("\n");
        builder.append("UID: ").append(this.uid).append("\n");
        builder.append("GID: ").append(this.gid).append("\n");
        builder.append("UserName: ").append(this.uname).append("\n");
        builder.append("GroupName: ").append(this.gname).append("\n");
        builder.append("Nlink: ").append(this.nlink).append("\n");
        builder.append("MTime: ").append(new Date(this.mtime)).append("\n");
        builder.append("FileSize: ").append(this.filesize).append("\n");
        builder.append("DevMinor: ").append(this.devMinor).append("\n");
        builder.append("DevMajor: ").append(this.devMajor).append("\n");
        builder.append("RDevMinor: ").append(this.rdevMinor).append("\n");
        builder.append("RDevMajor: ").append(this.rdevMajor).append("\n");
        builder.append("NameSize: ").append(this.name.length() + 1).append("\n");
        builder.append("Name: ").append(this.name).append("\n");
        return builder.toString();
    }
}

