/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.benchmark;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.benchmark.Stats;

class CountingInputStream
extends FilterInputStream {
    private final Stats stats;

    CountingInputStream(InputStream inStream, Stats stats) {
        super(inStream);
        this.stats = stats;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.stats.incTotalBytesRecv(1L);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.in.read(b);
        if (bytesRead > 0) {
            this.stats.incTotalBytesRecv(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead > 0) {
            this.stats.incTotalBytesRecv(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesRead = this.in.skip(n);
        if (bytesRead > 0L) {
            this.stats.incTotalBytesRecv(bytesRead);
        }
        return bytesRead;
    }
}

