/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.PickList;
import com.sas.app.RepositoryException;
import com.sas.app.RepositoryUtil;
import com.sas.app.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

final class LaunchLocatorEntryPoint {
    static final Attributes.Name ATTR_NAME_USER_MAIN = new Attributes.Name("SAS-User-Main-Class");
    private final Class m_callerClass;
    private final Attributes m_attr;
    private final String m_userMain;
    private URL[] m_urls;

    LaunchLocatorEntryPoint(Class callerClass) throws RuntimeException {
        Attributes attr;
        String userMain;
        URL uManifest;
        Manifest mf;
        ClassLoader callerCL;
        block15: {
            URL u;
            block14: {
                callerCL = callerClass.getClassLoader();
                String selfResPath = callerClass.getName().replace('.', '/') + ".class";
                Throwable t = null;
                u = null;
                if (callerCL != null) {
                    try {
                        u = callerCL.getResource(selfResPath);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                if (u == null) {
                    throw new RuntimeException(Util.format("LaunchLocatorEntryPoint.userManifest.ex.fmt.txt", callerClass), t);
                }
                mf = null;
                if ("jar".equals(u.getProtocol())) {
                    try {
                        URLConnection conn = u.openConnection();
                        if (conn instanceof JarURLConnection) {
                            mf = ((JarURLConnection)conn).getManifest();
                        }
                    }
                    catch (IOException conn) {
                        // empty catch block
                    }
                }
                if (mf != null) break block14;
                StringBuffer b = new StringBuffer();
                for (int i = selfResPath.split("/").length - 1; i > 0; --i) {
                    b.append("../");
                }
                b.append("META-INF/MANIFEST.MF");
                uManifest = null;
                InputStream s = null;
                try {
                    uManifest = new URL(u, b.toString());
                    s = uManifest.openStream();
                    mf = new Manifest(s);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(Util.format("LaunchLocatorEntryPoint.userManifest.read.ex.fmt.txt", callerClass, uManifest), e);
                    }
                    catch (Throwable throwable) {
                        Util.close(s);
                        throw throwable;
                    }
                }
                Util.close(s);
                break block15;
            }
            uManifest = u;
        }
        if ((userMain = (attr = mf.getMainAttributes()).getValue(ATTR_NAME_USER_MAIN)) == null) {
            throw new RuntimeException(Util.format("LaunchLocatorEntryPoint.userManifest.attr.ex.fmt.txt", uManifest, ATTR_NAME_USER_MAIN));
        }
        this.m_callerClass = callerClass;
        this.m_attr = attr;
        this.m_userMain = userMain;
        this.m_urls = Util.getClassLoaderURLs(callerCL);
    }

    URL[] getURLs() {
        return this.m_urls.length > 0 ? (URL[])this.m_urls.clone() : Util.ZERO_URLS;
    }

    String getUserMain() {
        return this.m_userMain;
    }

    PickList getPickList() throws RepositoryException {
        PickList rc = new PickList(this.m_attr, true);
        if (rc != null) {
            return rc;
        }
        return RepositoryUtil.parseDepsFor(this.m_callerClass.getClassLoader());
    }
}

