/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.GetSystemPropertyAction;
import com.sas.app.IterEnum;
import com.sas.app.LaunchLocatorEntryPoint;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import com.sas.app.RepositoryUtil;
import com.sas.app.SplashController;
import com.sas.app.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public final class AppClassLoader
extends URLClassLoader {
    public static final String PROP_DEV_CLASS_PATH = "sas.app.dev.class.path";
    public static final String PROP_DEV_CLASS_DIRS = "sas.app.dev.class.dirs";
    public static final String PROP_SAS_CLASS_PATH = "sas.app.class.path";
    public static final String PROP_SAS_CLASS_DIRS = "sas.app.class.dirs";
    public static final String PROP_PICK_LIST = "sas.app.launch.picklist";
    public static final String PROP_SAS_JAR_REPOSITORY_CONFIG = "sas.app.launch.picklist";
    static final String PROP_PICK_LIST_OLD = "sas.app.launch.config";
    public static final String PROP_SAS_CLASS_LIB_DIRS = "sas.app.class.lib.dirs";
    public static final String PROP_CONFIG_LOCATION = "sas.ext.config";
    public static final String PROP_JAVA_EXT_DIRS = "java.ext.dirs";
    public static final String PROP_OS_ARCH = "os.arch";
    private static final boolean DEBUG;
    static final boolean ATTEMPT_REENTRY_PASSTHROUGH = true;
    static final boolean ATTEMPT_REENTRY_PASSTHROUGH_WIDENING = true;
    private static final Method s_ClassLoader_findClass;
    private static final Method s_ClassLoader_findResource;
    private static final Method s_ClassLoader_findResources;
    private final ClassLoader m_delegate;
    private Helper m_helper;
    private Map m_loadedPluginNameVersions;
    private Map m_pluginNativeLibs;
    private boolean m_fullyInitted;

    public AppClassLoader(ClassLoader defAppClassLoader) {
        this(new Helper(defAppClassLoader, null));
    }

    AppClassLoader(ClassLoader defAppClassLoader, LaunchLocatorEntryPoint ll) {
        this(new Helper(defAppClassLoader, ll));
    }

    private AppClassLoader(Helper h) {
        super(Util.ZERO_URLS, h.getParent());
        this.m_delegate = h.getDelegate();
        this.m_helper = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureFullyInitted() {
        Helper h;
        AppClassLoader appClassLoader = this;
        synchronized (appClassLoader) {
            if (this.m_fullyInitted) {
                return true;
            }
            h = this.m_helper;
            if (h == null) {
                return false;
            }
            this.m_helper = null;
        }
        SplashController.doSplash();
        appClassLoader = this;
        synchronized (appClassLoader) {
            try {
                this.addURLs(h.getURLs());
                this.m_loadedPluginNameVersions = h.getPluginNameVersions();
                this.m_pluginNativeLibs = h.getPluginLibs();
                if (DEBUG) {
                    System.out.println(Util.format("AppClassLoader.debug.initted.fmt.log", this.getClass().getName()));
                    Iterator it = h.getURLs().iterator();
                    if (it.hasNext()) {
                        System.out.println(Util.format("AppClassLoader.debug.initialURLs.header.log"));
                        while (it.hasNext()) {
                            System.out.println("\t" + it.next());
                        }
                    } else {
                        System.out.println(Util.format("AppClassLoader.debug.initialURLs.none.log"));
                    }
                    System.out.println();
                }
            }
            catch (RuntimeException e) {
                SplashController.closeSplash();
                throw e;
            }
            catch (Error e) {
                SplashController.closeSplash();
                throw e;
            }
            this.m_fullyInitted = true;
        }
        return true;
    }

    public synchronized String[] getLoadedPluginNames() {
        Map nameVersions = this.getLoadedPluginNameVersions();
        if (nameVersions == null) {
            return Util.ZERO_STRINGS;
        }
        int n = nameVersions.size();
        if (n <= 0) {
            return Util.ZERO_STRINGS;
        }
        return nameVersions.keySet().toArray(new String[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getLoadedPluginNameVersions() {
        this.ensureFullyInitted();
        AppClassLoader appClassLoader = this;
        synchronized (appClassLoader) {
            int n;
            if (this.m_loadedPluginNameVersions != null && (n = this.m_loadedPluginNameVersions.size()) > 0) {
                return Collections.unmodifiableMap(new HashMap(this.m_loadedPluginNameVersions));
            }
        }
        return Collections.EMPTY_MAP;
    }

    private void addURLs(Collection urls) {
        if (urls == null || urls.isEmpty()) {
            return;
        }
        for (URL u : urls) {
            if (u == null) continue;
            super.addURL(u);
        }
    }

    @Override
    protected String findLibrary(String libname) {
        File f;
        String libPathProp;
        if (libname == null) {
            return super.findLibrary(libname);
        }
        String mapped = System.mapLibraryName(libname);
        try {
            libPathProp = (String)AccessController.doPrivileged(new GetSystemPropertyAction(PROP_SAS_CLASS_LIB_DIRS));
        }
        catch (SecurityException e) {
            libPathProp = null;
        }
        if (libPathProp != null) {
            StringTokenizer tok = new StringTokenizer(libPathProp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String dirPath = tok.nextToken();
                File f2 = new File(dirPath, mapped);
                if (!f2.isFile()) continue;
                return AppClassLoader.canonicalPath(f2);
            }
        }
        if (this.m_pluginNativeLibs != null && (f = (File)this.m_pluginNativeLibs.get(libname)) != null && f.isFile()) {
            return AppClassLoader.canonicalPath(f);
        }
        return super.findLibrary(libname);
    }

    private static String canonicalPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    /*
     * Loose catch block
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            block18: {
                if (this.ensureFullyInitted()) break block18;
                ClassLoader ourCL = this.getClass().getClassLoader();
                if (s_ClassLoader_findClass != null && ourCL != null) {
                    Object[] args = new Object[]{name};
                    try {
                        return (Class)s_ClassLoader_findClass.invoke((Object)ourCL, args);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)t;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                        // empty catch block
                    }
                }
                if (ourCL == null) break block18;
                return ourCL.loadClass(name);
                {
                    catch (ClassNotFoundException e) {
                        throw e;
                    }
                }
            }
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ClassLoader ourCL = this.getClass().getClassLoader();
                if (ourCL == null) {
                    throw e;
                }
                return ourCL.loadClass(name);
            }
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(t);
        }
    }

    @Override
    public URL findResource(String name) {
        try {
            if (!this.ensureFullyInitted()) {
                ClassLoader ourCL = this.getClass().getClassLoader();
                if (s_ClassLoader_findResource != null && ourCL != null) {
                    Object[] args = new Object[]{name};
                    try {
                        return (URL)s_ClassLoader_findResource.invoke((Object)ourCL, args);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                        // empty catch block
                    }
                }
                if (ourCL != null) {
                    return ourCL.getResource(name);
                }
            }
            return super.findResource(name);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(t);
        }
    }

    public Enumeration findResources(String name) throws IOException {
        try {
            if (!this.ensureFullyInitted()) {
                ClassLoader ourCL;
                if (s_ClassLoader_findResources != null & (ourCL = this.getClass().getClassLoader()) != null) {
                    Object[] args = new Object[]{name};
                    try {
                        return (Enumeration)s_ClassLoader_findResources.invoke((Object)ourCL, args);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof IOException) {
                            throw (IOException)t;
                        }
                    }
                    catch (NullPointerException e) {
                    }
                    catch (ExceptionInInitializerError e) {
                        // empty catch block
                    }
                }
                if (ourCL != null) {
                    return ourCL.getResources(name);
                }
            }
            Enumeration<URL> rc = super.findResources(name);
            if (this.m_delegate == null) {
                return rc;
            }
            Enumeration<URL> drc = this.m_delegate.getResources(name);
            if (!drc.hasMoreElements()) {
                return rc;
            }
            if (!rc.hasMoreElements()) {
                return drc;
            }
            IterEnum ie = new IterEnum(rc);
            ie.add(drc);
            ie.setReadOnly();
            return ie;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(t);
        }
    }

    @Override
    public URL getResource(String name) {
        URL rc = super.getResource(name);
        if (rc == null && this.m_delegate != null) {
            rc = this.m_delegate.getResource(name);
        }
        return rc;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.m_delegate == null) {
            return super.loadClass(name, resolve);
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return this.m_delegate.loadClass(name);
        }
    }

    static {
        s_ClassLoader_findClass = null;
        s_ClassLoader_findResource = null;
        s_ClassLoader_findResources = null;
        boolean debug = false;
        try {
            debug = Boolean.getBoolean("com.sas.app.AppClassLoader.DEBUG");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = debug;
    }

    private static final class Helper {
        private static final String DEFAULT_EXT_INCLUDE_RESOURCE = "JavaEXTs.config";
        private static final boolean USE_ALL_EXT_ANCESTORS = true;
        private final LaunchLocatorEntryPoint m_ll;
        private String m_devClasspath;
        private String m_devClassDirs;
        private String m_classpath;
        private String m_classDirs;
        private String m_jarRepositoryPickList;
        private String m_extConfig;
        private String m_extDirs;
        private String m_osArch;
        private LinkedHashSet m_extURLs;
        private LinkedHashSet m_urls;
        private final ClassLoader m_parent;
        private final ClassLoader m_delegate;
        private Map m_pluginNameVersions;
        private Map m_pluginLibs;
        private Repository m_repository;
        private boolean m_repositoryCreated;

        private static URL[] toURLs(Collection urls) {
            if (urls == null || urls.size() <= 0) {
                return Util.ZERO_URLS;
            }
            if (urls.size() > 1 && !(urls instanceof Set)) {
                urls = new LinkedHashSet(urls);
            }
            urls.remove(null);
            int n = urls.size();
            return n > 0 ? urls.toArray(new URL[n]) : Util.ZERO_URLS;
        }

        private static void addURLs(URL[] urls, LinkedHashSet rc) {
            if (urls == null || urls.length <= 0) {
                return;
            }
            for (int i = 0; i < urls.length; ++i) {
                URL u = urls[i];
                if (u == null) continue;
                rc.add(u);
            }
        }

        private static LinkedHashSet calcUnfilteredExtURLs(ClassLoader origExtClassLoader) {
            LinkedHashSet rc = new LinkedHashSet();
            if (origExtClassLoader == null) {
                return rc;
            }
            ArrayList<ClassLoader> list = new ArrayList<ClassLoader>();
            for (ClassLoader cl = origExtClassLoader; cl != null; cl = cl.getParent()) {
                list.add(cl);
            }
            int n = list.size();
            for (int i = n - 1; i >= 0; --i) {
                ClassLoader cl = (ClassLoader)list.get(i);
                Helper.addURLs(Util.getClassLoaderURLs(cl), rc);
            }
            return rc;
        }

        Helper(ClassLoader defAppClassLoader, LaunchLocatorEntryPoint ll) {
            this.m_ll = ll;
            this.grabSysProps();
            ClassLoader origExtClassLoader = defAppClassLoader.getParent();
            this.m_extURLs = Helper.calcUnfilteredExtURLs(origExtClassLoader);
            Set extIncludeNames = this.getExtIncludeList();
            this.filterExtURLs(this.m_extURLs, extIncludeNames);
            this.m_parent = new ExtClassLoader(Helper.toURLs(this.m_extURLs), this.m_extDirs, this.m_osArch, extIncludeNames);
            this.m_delegate = null;
        }

        LinkedHashSet getURLs() {
            LinkedHashSet appURLs;
            if (this.m_urls != null) {
                return this.m_urls;
            }
            try {
                appURLs = this.calcAppURLs();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            this.m_urls = appURLs;
            return this.m_urls;
        }

        ClassLoader getParent() {
            return this.m_parent;
        }

        ClassLoader getDelegate() {
            return this.m_delegate;
        }

        Map getPluginNameVersions() {
            this.getURLs();
            return this.m_pluginNameVersions;
        }

        Map getPluginLibs() {
            this.getURLs();
            return this.m_pluginLibs;
        }

        Repository getRepository() throws RepositoryException {
            if (!this.m_repositoryCreated) {
                this.m_repositoryCreated = true;
                this.m_repository = Repository.getDefaultRepository();
            }
            return this.m_repository;
        }

        private void grabSysProps() {
            GetSystemPropertyAction action = new GetSystemPropertyAction(new String[]{AppClassLoader.PROP_DEV_CLASS_PATH, AppClassLoader.PROP_DEV_CLASS_DIRS, AppClassLoader.PROP_SAS_CLASS_PATH, AppClassLoader.PROP_SAS_CLASS_DIRS, "sas.app.launch.picklist", AppClassLoader.PROP_PICK_LIST_OLD, AppClassLoader.PROP_CONFIG_LOCATION, AppClassLoader.PROP_JAVA_EXT_DIRS, AppClassLoader.PROP_OS_ARCH});
            AccessController.doPrivileged(action);
            String[] values = action.getValues();
            int i = 0;
            this.m_devClasspath = values[i++];
            this.m_devClassDirs = values[i++];
            this.m_classpath = values[i++];
            this.m_classDirs = values[i++];
            this.m_jarRepositoryPickList = values[i++];
            String oldPickListProp = values[i++];
            if (this.m_jarRepositoryPickList == null) {
                this.m_jarRepositoryPickList = oldPickListProp;
            }
            this.m_extConfig = values[i++];
            this.m_extDirs = values[i++];
            this.m_osArch = values[i++];
        }

        private LinkedHashSet calcAppURLs() throws IllegalArgumentException, RepositoryException {
            LinkedHashSet rc = new LinkedHashSet();
            Util.addNewFileUrls(Util.getPathFiles(this.m_devClasspath), rc);
            File[] files = Util.getPathFiles(this.m_devClassDirs);
            for (int i = 0; i < files.length; ++i) {
                Util.addNewFileUrls(files[i].listFiles(), rc);
            }
            boolean processedPickList = false;
            if (this.m_jarRepositoryPickList != null) {
                PickList pickList = PickList.calcMergedPickListForSysProp(this.m_jarRepositoryPickList);
                processedPickList = true;
                this.processPickList(pickList, rc);
            }
            Util.addNewFileUrls(Util.getPathFiles(this.m_classpath), rc);
            files = Util.getPathFiles(this.m_classDirs);
            for (int i = 0; i < files.length; ++i) {
                Util.addNewFileUrls(files[i].listFiles(), rc);
            }
            if (this.m_ll == null) {
                return rc;
            }
            if (!processedPickList) {
                this.processPickList(this.m_ll.getPickList(), rc);
            }
            Helper.addURLs(this.m_ll.getURLs(), rc);
            return rc;
        }

        private void processPickList(PickList pickList, LinkedHashSet rc) throws RepositoryException {
            this.m_pluginNameVersions = new HashMap();
            this.m_pluginLibs = Collections.EMPTY_MAP;
            if (pickList == null || pickList.isEmpty()) {
                return;
            }
            Repository r = this.getRepository();
            if (r == null) {
                return;
            }
            Plugin[] plugins = RepositoryUtil.getClasspath(r, pickList, rc, this.m_pluginNameVersions);
            assert (plugins != null);
            HashMap libs = new HashMap();
            for (int i = plugins.length - 1; i >= 0; --i) {
                libs.putAll(plugins[i].getSelectedNativeLibs());
            }
            this.m_pluginLibs = libs.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(libs);
        }

        private void filterExtURLs(Collection extURLs, Set includes) {
            if (extURLs == null || extURLs.size() <= 0) {
                return;
            }
            if (includes == null || includes.size() <= 0) {
                extURLs.clear();
                return;
            }
            Iterator it = extURLs.iterator();
            while (it.hasNext()) {
                int lastSlash;
                String s;
                URL u = (URL)it.next();
                if (u != null && (s = u.getFile()) != null && (lastSlash = s.lastIndexOf(47)) >= 0 && includes.contains(s.substring(lastSlash + 1))) continue;
                it.remove();
            }
        }

        private Set getExtIncludeList() {
            HashSet<String> rc = new HashSet<String>();
            String configLocation = this.m_extConfig;
            InputStream s = null;
            try {
                String line;
                if (this.m_extConfig == null) {
                    configLocation = DEFAULT_EXT_INCLUDE_RESOURCE;
                    s = Helper.class.getResourceAsStream(DEFAULT_EXT_INCLUDE_RESOURCE);
                    if (s == null) {
                        throw new FileNotFoundException(DEFAULT_EXT_INCLUDE_RESOURCE);
                    }
                } else {
                    s = new FileInputStream(configLocation);
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(s, "8859_1"));
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    rc.add(line);
                }
            }
            catch (IOException e) {
                try {
                    ResourceBundle rb = ResourceBundle.getBundle(Util.RB_NAME, Locale.getDefault(), Helper.class.getClassLoader());
                    String msg = MessageFormat.format(rb.getString("AppClassLoader.ConfigLocationError.fmt.log"), configLocation);
                    throw new RuntimeException(msg, e);
                }
                catch (Throwable throwable) {
                    Util.close(s);
                    throw throwable;
                }
            }
            Util.close(s);
            return Collections.unmodifiableSet(rc);
        }

        private static class ExtClassLoader
        extends URLClassLoader {
            private final File[] m_extLibPath;
            private final Set m_includeNames;

            ExtClassLoader(URL[] urls, String propJavaExtDirs, String propOSArch, Set includeNames) {
                super(urls, System.getProperty("tkj.app.launch.config") == null ? AppClassLoader.class.getClassLoader().getParent() : AppClassLoader.class.getClassLoader());
                if (includeNames == null || includeNames.isEmpty()) {
                    this.m_extLibPath = null;
                    this.m_includeNames = null;
                    return;
                }
                File[] extLibPath = Util.getPathFiles(propJavaExtDirs);
                if (extLibPath.length <= 0) {
                    this.m_extLibPath = null;
                    this.m_includeNames = null;
                    return;
                }
                if (propOSArch != null && (propOSArch = propOSArch.trim()).length() > 0) {
                    LinkedHashSet<File> s = new LinkedHashSet<File>();
                    for (int i = 0; i < extLibPath.length; ++i) {
                        File dir = extLibPath[i];
                        s.add(new File(dir, propOSArch));
                        s.add(dir);
                    }
                    extLibPath = s.toArray(new File[s.size()]);
                }
                this.m_extLibPath = extLibPath;
                this.m_includeNames = includeNames;
            }

            @Override
            protected String findLibrary(String libname) {
                if (libname != null && this.m_includeNames != null) {
                    String mapped = System.mapLibraryName(libname);
                    if (this.m_includeNames.contains(libname) || this.m_includeNames.contains(mapped)) {
                        File[] libPath = this.m_extLibPath;
                        int n = libPath.length;
                        for (int i = 0; i < n; ++i) {
                            File f = new File(libPath[i], mapped);
                            if (!f.exists()) continue;
                            return f.getAbsolutePath();
                        }
                    }
                }
                return super.findLibrary(libname);
            }
        }
    }
}

