/*
 * Decompiled with CFR 0.152.
 */
package MITI.statistics;

import MITI.messages.MIRStatisticsUtil.STATISTICS;
import MITI.sdk.MIRElementType;
import MITI.util.EscapedStringTokenizer;
import java.util.ArrayList;
import java.util.TreeMap;

public class Statistics {
    private static final String EOL = System.getProperty("line.separator");
    private static final String COMMA = ",";
    protected String toolInfo;
    protected String bridgeInfo;
    protected String modelInfo;
    protected TreeMap<String, sModelEntry> modelEntries = new TreeMap();
    protected TreeMap<String, sTrnsfEntry> trnsfEntries = new TreeMap();
    protected TreeMap<String, sCounter> counters = new TreeMap();

    public Statistics(String string, String string2, String string3) {
        this.toolInfo = string;
        this.bridgeInfo = string2;
        this.modelInfo = string3;
    }

    public Statistics(String string) {
        sParseState sParseState2 = new sParseState();
        ArrayList<sTrnsfEntry> arrayList = new ArrayList<sTrnsfEntry>();
        this.parseValue(string, sParseState2);
        this.toolInfo = this.parseValue(string, sParseState2);
        this.parseValue(string, sParseState2);
        this.bridgeInfo = this.parseValue(string, sParseState2);
        this.parseValue(string, sParseState2);
        this.modelInfo = this.parseValue(string, sParseState2);
        this.skipParseFields(string, sParseState2, 11);
        while (!sParseState2.isEol) {
            String string2 = this.parseValue(string, sParseState2);
            arrayList.add(new sTrnsfEntry("", -1, string2, ""));
        }
        this.skipParseFields(string, sParseState2, 11);
        int n = 0;
        while (!sParseState2.isEol) {
            String object3;
            ((sTrnsfEntry)arrayList.get((int)n)).toolKey = object3 = this.parseValue(string, sParseState2);
            ++n;
        }
        this.skipParseFields(string, sParseState2, 11);
        n = 0;
        while (!sParseState2.isEol) {
            String string2;
            ((sTrnsfEntry)arrayList.get((int)n)).groupName = string2 = this.parseValue(string, sParseState2);
            ++n;
        }
        this.skipParseFields(string, sParseState2, 11);
        n = 0;
        while (!sParseState2.isEol) {
            String string3 = this.parseValue(string, sParseState2);
            ((sTrnsfEntry)arrayList.get((int)n)).mirKey = MIRElementType.getByName(string3);
            ++n;
        }
        this.skipParseFields(string, sParseState2, 11);
        n = 0;
        while (!sParseState2.isEol) {
            String string4;
            ((sTrnsfEntry)arrayList.get((int)n)).imvSupport = string4 = this.parseValue(string, sParseState2);
            ++n;
        }
        while (sParseState2.pos != -1 && sParseState2.pos < string.length()) {
            Object object;
            int n2;
            String string3 = this.parseValue(string, sParseState2);
            String string5 = this.parseValue(string, sParseState2);
            String string6 = this.parseValue(string, sParseState2);
            String string7 = this.parseValue(string, sParseState2);
            if (string3.equalsIgnoreCase(" " + STATISTICS.ETL_BI_STAT_TOTAL.getText())) break;
            sModelEntry sModelEntry2 = new sModelEntry(string5, string3, string6, MIRElementType.getByName(string7));
            this.modelEntries.put(this.makeCompKey(string5, string3), sModelEntry2);
            for (n2 = 0; n2 < 6; n2 = (short)(n2 + 1)) {
                object = this.parseValue(string, sParseState2);
                if (((String)object).isEmpty()) continue;
                sModelEntry2.setCounter((short)n2, Integer.parseInt((String)object));
            }
            this.parseValue(string, sParseState2);
            n2 = 0;
            while (!sParseState2.isEol) {
                object = (sTrnsfEntry)arrayList.get(n2);
                sCounter sCounter2 = new sCounter();
                this.counters.put(this.makeCompKey(sModelEntry2.modelPath, sModelEntry2.modelName, ((sTrnsfEntry)object).toolKey, ((sTrnsfEntry)object).mirKey), sCounter2);
                String string8 = this.parseValue(string, sParseState2);
                if (!string8.isEmpty()) {
                    sCounter2.countValue = Integer.parseInt(string8);
                }
                ++n2;
            }
        }
        for (sTrnsfEntry sTrnsfEntry2 : arrayList) {
            this.trnsfEntries.put(this.makeCompKey(sTrnsfEntry2.toolKey, sTrnsfEntry2.mirKey), sTrnsfEntry2);
        }
    }

    public void incCounter(String string, String string2, String string3, short s, String string4, short s2, String string5, String string6, int n) {
        sCounter sCounter2;
        sTrnsfEntry sTrnsfEntry2;
        String string7 = string.startsWith(this.modelInfo) ? string.substring(this.modelInfo.length(), string.length()) : string;
        string7 = string7.endsWith("/" + string2) ? string7.substring(0, string7.length() - string2.length() - 1) : string7;
        string7 = string7.endsWith("/" + string2) ? string7.substring(0, string7.length() - string2.length() - 1) : string7;
        String string8 = this.makeCompKey(string7, string2);
        String string9 = this.makeCompKey(string4, s2);
        String string10 = this.makeCompKey(string7, string2, string4, s2);
        sModelEntry sModelEntry2 = this.findModelEntry(string7, string2);
        if (sModelEntry2 == null) {
            sModelEntry2 = new sModelEntry(string7, string2, string3, s);
            this.modelEntries.put(string8, sModelEntry2);
        }
        if ((sTrnsfEntry2 = this.findTrnsfEntry(string4, s2)) == null) {
            sTrnsfEntry2 = new sTrnsfEntry(string4, s2, string5, string6);
            this.trnsfEntries.put(string9, sTrnsfEntry2);
        }
        if ((sCounter2 = this.findCounter(string7, string2, string4, s2)) == null) {
            sCounter2 = new sCounter();
            this.counters.put(string10, sCounter2);
        }
        sCounter2.countValue += n;
    }

    public void incModelCounter(String string, String string2, short s, int n) {
        String string3 = string.startsWith(this.modelInfo) ? string.substring(this.modelInfo.length(), string.length()) : string;
        string3 = string3.endsWith("/" + string2) ? string3.substring(0, string3.length() - string2.length() - 1) : string3;
        sModelEntry sModelEntry2 = this.findModelEntry(string3 = string3.endsWith("/" + string2) ? string3.substring(0, string3.length() - string2.length() - 1) : string3, string2);
        if (sModelEntry2 == null) {
            sModelEntry2 = new sModelEntry(string3, string2, "", -1);
            this.modelEntries.put(this.makeCompKey(string3, string2), sModelEntry2);
        }
        sModelEntry2.incCounter(s, n);
    }

    public void setSupportValue(String string, short s, String string2) {
        sTrnsfEntry sTrnsfEntry2 = this.findTrnsfEntry(string, s);
        if (sTrnsfEntry2 == null) {
            sTrnsfEntry2 = new sTrnsfEntry(string, s, "", "");
            this.trnsfEntries.put(this.makeCompKey(string, Short.toString(s)), sTrnsfEntry2);
        }
        sTrnsfEntry2.imvSupport = string2;
    }

    /*
     * WARNING - void declaration
     */
    public String printCsv() {
        short s;
        StringBuffer stringBuffer = new StringBuffer(65535);
        stringBuffer.append(STATISTICS.ETL_BI_STAT_IMPORT_TOOL.getText() + COMMA + this.toolInfo).append(EOL).append(STATISTICS.ETL_BI_STAT_IMPORT_BRIDGE.getText() + COMMA + this.bridgeInfo).append(EOL).append(STATISTICS.ETL_BI_STAT_IMPORT_MODEL.getText() + COMMA + this.modelInfo).append(EOL);
        stringBuffer.append(STATISTICS.ETL_BI_STAT_NAME.getText() + COMMA + STATISTICS.ETL_BI_STAT_PATH.getText() + COMMA + STATISTICS.ETL_BI_STAT_TOOL_TYPE.getText() + COMMA + STATISTICS.ETL_BI_STAT_SYSTEM_TYPE.getText());
        for (short s2 = 0; s2 < 6; s2 = (short)(s2 + 1)) {
            stringBuffer.append(COMMA + sModelEntry.getCaption(s2));
        }
        stringBuffer.append(COMMA + STATISTICS.ETL_BI_STAT_COMPONENTS.getText());
        for (sTrnsfEntry object : this.trnsfEntries.values()) {
            stringBuffer.append(COMMA + object.toolName);
        }
        stringBuffer.append(EOL);
        stringBuffer.append(STATISTICS.ETL_BI_STAT_$_TOOL_TYPE.getText() + this.skipPrintFields(10));
        for (sTrnsfEntry sTrnsfEntry2 : this.trnsfEntries.values()) {
            stringBuffer.append(COMMA + sTrnsfEntry2.toolKey.replace("\"", " ").replace(COMMA, " "));
        }
        stringBuffer.append(EOL);
        stringBuffer.append(STATISTICS.ETL_BI_STAT_$_TOOL_TYPE_GROUP.getText() + this.skipPrintFields(10));
        for (sTrnsfEntry sTrnsfEntry3 : this.trnsfEntries.values()) {
            stringBuffer.append(COMMA + sTrnsfEntry3.groupName.replace("\"", " ").replace(COMMA, " "));
        }
        stringBuffer.append(EOL);
        stringBuffer.append(STATISTICS.ETL_BI_STAT_$_SYSTEM_TYPE.getText() + this.skipPrintFields(10));
        for (sTrnsfEntry sTrnsfEntry4 : this.trnsfEntries.values()) {
            void var4_18;
            String string = MIRElementType.getName(sTrnsfEntry4.mirKey);
            if (string == null) {
                String string2 = "";
            }
            stringBuffer.append(COMMA + var4_18.replace("\"", " ").replace(COMMA, " "));
        }
        stringBuffer.append(EOL);
        stringBuffer.append(STATISTICS.ETL_BI_STAT_$_TARGET_TOOL_TYPE.getText() + this.skipPrintFields(10));
        for (sTrnsfEntry sTrnsfEntry5 : this.trnsfEntries.values()) {
            stringBuffer.append(COMMA + sTrnsfEntry5.imvSupport);
        }
        stringBuffer.append(EOL);
        int n = 0;
        for (sModelEntry sModelEntry2 : this.modelEntries.values()) {
            short s3;
            String string = MIRElementType.getName(sModelEntry2.mirType);
            stringBuffer.append(sModelEntry2.modelName.replace("\"", " ").replace(COMMA, " ") + COMMA + sModelEntry2.modelPath.replace("\"", " ").replace(COMMA, " ") + COMMA + sModelEntry2.toolType.replace("\"", " ").replace(COMMA, " ") + COMMA + (string != null ? string : STATISTICS.ETL_BI_STAT_UNKNOWN.getText()));
            for (s3 = 0; s3 < 6; s3 = (short)(s3 + 1)) {
                stringBuffer.append(COMMA + (sModelEntry2.getCounter(s3) > 0 ? Integer.toString(sModelEntry2.getCounter(s3)) : ""));
            }
            s3 = this.calcTotalByModel(sModelEntry2);
            stringBuffer.append(COMMA + (s3 != 0 ? Integer.toString(s3) : ""));
            n += s3;
            for (sTrnsfEntry sTrnsfEntry6 : this.trnsfEntries.values()) {
                String string3 = new String();
                sCounter sCounter2 = this.findCounter(sModelEntry2.modelPath, sModelEntry2.modelName, sTrnsfEntry6.toolKey, sTrnsfEntry6.mirKey);
                if (sCounter2 != null) {
                    string3 = sCounter2.countValue != 0 ? Integer.toString(sCounter2.countValue) : "";
                }
                stringBuffer.append(COMMA + string3);
            }
            stringBuffer.append(EOL);
        }
        stringBuffer.append(" " + STATISTICS.ETL_BI_STAT_TOTAL.getText() + this.skipPrintFields(3));
        boolean bl = false;
        while (s < 6) {
            int n2 = s != 4 && s != 5 ? this.calcTotalByCounter(s) : 0;
            stringBuffer.append(COMMA + (n2 != 0 ? Integer.toString(n2) : ""));
            s = (short)(s + true);
        }
        stringBuffer.append(COMMA + (n != 0 ? Integer.toString(n) : ""));
        for (sTrnsfEntry sTrnsfEntry7 : this.trnsfEntries.values()) {
            int n3 = this.calcTotalByTransf(sTrnsfEntry7);
            stringBuffer.append(COMMA + (n3 != 0 ? Integer.toString(n3) : ""));
        }
        stringBuffer.append(EOL);
        return stringBuffer.toString();
    }

    public static boolean isStatisticsOn(String string, StringBuilder stringBuilder) {
        String string2 = "Statistics";
        boolean bl = false;
        EscapedStringTokenizer escapedStringTokenizer = new EscapedStringTokenizer(string, ';', '\u0000');
        String string3 = escapedStringTokenizer.getNextToken();
        while (string3 != null) {
            if (string3.toUpperCase().startsWith(string2.toUpperCase())) {
                bl = true;
                if (stringBuilder != null) {
                    stringBuilder.setLength(0);
                }
                if ((string3 = string3.substring(string2.length(), string3.length()).trim()).startsWith("=")) {
                    if ((string3 = string3.substring(1, string3.length()).trim()).startsWith("\"") && string3.endsWith("\"")) {
                        string3 = string3.substring(1, string3.length() - 1).trim();
                    }
                    if (stringBuilder != null) {
                        stringBuilder.append(string3);
                    }
                }
            }
            string3 = escapedStringTokenizer.getNextToken();
        }
        return bl;
    }

    private String parseValue(String string, sParseState sParseState2) {
        if (sParseState2.pos != -1 && sParseState2.pos < string.length()) {
            int n = sParseState2.pos;
            int n2 = sParseState2.pos;
            int n3 = sParseState2.pos;
            int n4 = string.indexOf(COMMA, sParseState2.pos);
            int n5 = string.indexOf(EOL, sParseState2.pos);
            boolean bl = false;
            if (n5 != -1 && n4 != -1) {
                if (n4 < n5) {
                    n3 = n4;
                    n2 = n3++;
                    bl = false;
                } else {
                    n2 = n3 = n5;
                    n3 += EOL.length();
                    bl = true;
                }
            } else if (n5 == -1 && n4 != -1) {
                n3 = n4;
                n2 = n3++;
                bl = false;
            } else if (n5 != -1 && n4 == -1) {
                n2 = n3 = n5;
                n3 += EOL.length();
                bl = true;
            } else {
                n2 = n3 = string.length();
                bl = false;
            }
            sParseState2.pos = n3;
            sParseState2.isEol = bl;
            return string.substring(n, n2);
        }
        sParseState2.pos = -1;
        return "";
    }

    private sModelEntry findModelEntry(String string, String string2) {
        return this.modelEntries.get(this.makeCompKey(string, string2));
    }

    private sTrnsfEntry findTrnsfEntry(String string, short s) {
        return this.trnsfEntries.get(this.makeCompKey(string, s));
    }

    private sCounter findCounter(String string, String string2, String string3, short s) {
        return this.counters.get(this.makeCompKey(string, string2, string3, s));
    }

    private int calcTotalByModel(sModelEntry sModelEntry2) {
        int n = 0;
        for (sTrnsfEntry sTrnsfEntry2 : this.trnsfEntries.values()) {
            sCounter sCounter2 = this.counters.get(this.makeCompKey(sModelEntry2.modelPath, sModelEntry2.modelName, sTrnsfEntry2.toolKey, sTrnsfEntry2.mirKey));
            if (sCounter2 == null) continue;
            n += sCounter2.countValue;
        }
        return n;
    }

    private int calcTotalByTransf(sTrnsfEntry sTrnsfEntry2) {
        int n = 0;
        for (sModelEntry sModelEntry2 : this.modelEntries.values()) {
            sCounter sCounter2 = this.counters.get(this.makeCompKey(sModelEntry2.modelPath, sModelEntry2.modelName, sTrnsfEntry2.toolKey, sTrnsfEntry2.mirKey));
            if (sCounter2 == null) continue;
            n += sCounter2.countValue;
        }
        return n;
    }

    private int calcTotalByCounter(short s) {
        int n = 0;
        for (sModelEntry sModelEntry2 : this.modelEntries.values()) {
            n += sModelEntry2.getCounter(s);
        }
        return n;
    }

    private String skipPrintFields(int n) {
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + COMMA;
        }
        return string;
    }

    private void skipParseFields(String string, sParseState sParseState2, int n) {
        for (int i = 0; i < n; ++i) {
            this.parseValue(string, sParseState2);
        }
    }

    private String makeCompKey(String string, String string2) {
        return string + ":" + string2;
    }

    private String makeCompKey(String string, Short s) {
        return string + ":" + Short.toString(s);
    }

    private String makeCompKey(String string, String string2, String string3, Short s) {
        return string + ":" + string2 + ":" + string3 + ":" + Short.toString(s);
    }

    private static class sParseState {
        public int pos = 0;
        public boolean isEol = false;

        private sParseState() {
        }
    }

    private static class sCounter {
        int countValue = 0;
    }

    private static class sTrnsfEntry {
        String toolKey;
        short mirKey;
        String toolName;
        String groupName;
        String imvSupport;

        public sTrnsfEntry(String string, short s, String string2, String string3) {
            this.toolKey = string;
            this.mirKey = s;
            this.toolName = string2;
            this.groupName = string3;
            this.imvSupport = "";
        }
    }

    public static class sModelEntry {
        public static final short ECI_ERRORS = 0;
        public static final short ECI_WARNINGS = 1;
        public static final short ECI_LINKS = 2;
        public static final short ECI_SQL = 3;
        public static final short ECI_COLUMNS = 4;
        public static final short ECI_TABLES = 5;
        public static final short ECI_COUNTS = 6;
        String modelPath;
        String modelName;
        String toolType;
        short mirType;
        int[] imvCounters = new int[6];

        public sModelEntry(String string, String string2, String string3, short s) {
            this.modelPath = string;
            this.modelName = string2;
            this.toolType = string3;
            this.mirType = s;
            for (int i = 0; i < 6; ++i) {
                this.imvCounters[i] = 0;
            }
        }

        public int getCounter(short s) {
            return s >= 0 && s < 6 ? this.imvCounters[s] : 0;
        }

        public void setCounter(short s, int n) {
            if (s >= 0 && s < 6) {
                this.imvCounters[s] = n;
            }
        }

        public void incCounter(short s, int n) {
            if (s >= 0 && s < 6) {
                short s2 = s;
                this.imvCounters[s2] = this.imvCounters[s2] + n;
            }
        }

        public static String getCaption(short s) {
            switch (s) {
                case 0: {
                    return STATISTICS.ETL_BI_STAT_ERRORS.getText();
                }
                case 1: {
                    return STATISTICS.ETL_BI_STAT_WARNINGS.getText();
                }
                case 2: {
                    return STATISTICS.ETL_BI_STAT_LINKS.getText();
                }
                case 3: {
                    return STATISTICS.ETL_BI_STAT_SQL.getText();
                }
                case 4: {
                    return STATISTICS.ETL_BI_STAT_COLUMNS.getText();
                }
                case 5: {
                    return STATISTICS.ETL_BI_STAT_TABLES.getText();
                }
            }
            return "";
        }
    }
}

