/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.typedictionary;

import com.sas.metadata.logical.typedictionary.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TypeDefinition;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;

public class TypeDefInfoTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    CMetadata m_metadata = null;
    boolean modelPopulated = false;
    protected cPropTableModel m_optionsModel;
    protected WATable m_optionsTable;
    protected JScrollPane attrPanel;

    public TypeDefInfoTab(CMetadata metaObject) {
        try {
            this.m_metadata = metaObject;
            this.initialize();
            this.layoutWidgets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initialize() {
        this.m_optionsModel = new cPropTableModel();
        this.m_optionsTable = new WATable((WATableModel)this.m_optionsModel, false);
        this.attrPanel = new JScrollPane((Component)this.m_optionsTable, 20, 30);
        this.m_optionsTable.setToolTipColumn(2);
        this.setHelpTopic("advanced_tab");
        this.setHelpProduct("shared");
        super.setEditable(false);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.attrPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.setDataChanged(false);
        }
        return true;
    }

    public void stateChanged(ChangeEvent e) {
        this.setDataChanged(true);
    }

    protected class cPropTableModel
    extends WATableModel {
        private static final long serialVersionUID = 1L;
        protected ArrayList m_cellChoices = new ArrayList();
        protected ArrayList hidden_values = new ArrayList();
        protected boolean[] m_columnIsEditable = new boolean[]{false, false, false};
        protected boolean[] m_columnIsChoice = new boolean[]{false, false, false};

        public cPropTableModel() {
            this.columnNames.add(RB.getStringResource("cPropTableModel.Name.txt"));
            this.columnNames.add(RB.getStringResource("cPropTableModel.Value.txt"));
            this.hidden_values.add("LockedBy");
            this.hidden_values.add("UsageVersion");
            this.hidden_values.add("PublicType");
            this.hidden_values.add("ResourceTemplate");
            this.hidden_values.add("ChangeState");
            this.setupModel();
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public String getColumnName(int col) {
            return (String)this.columnNames.get(col);
        }

        public String getRowName(int row) {
            return String.valueOf(row + 1);
        }

        public boolean isCellEditable(int row, int col) {
            return this.m_columnIsEditable[col];
        }

        public Object getRowValue(int row) {
            return String.valueOf(row + 1);
        }

        public void setupModel() {
            try {
                Map attrs = TypeDefInfoTab.this.m_metadata.getAttrs();
                Set attrnames = attrs.keySet();
                Iterator attrIter = attrnames.iterator();
                int count = 0;
                int rows = this.getRowCount();
                for (int i = rows - 1; i >= 0; --i) {
                    this.deleteRow(i);
                }
                this.fireTableRowsDeleted(0, rows);
                while (attrIter.hasNext()) {
                    String attrname = (String)attrIter.next();
                    if (this.hidden_values != null && this.hidden_values.contains(attrname)) continue;
                    String attrvalue = (String)attrs.get(attrname);
                    if (attrname.equals("MetadataCreated") || attrname.equals("MetadataUpdated")) {
                        attrvalue = WsMetadataUtil.formatDate((String)attrvalue, null);
                    }
                    this.insertRow(attrname, attrvalue, attrvalue);
                    ++count;
                }
                AssociationList props = ((TypeDefinition)TypeDefInfoTab.this.m_metadata).getProperties();
                for (Property elem : props) {
                    if (!elem.getPropertyName().equals("LogicalTypeClass")) continue;
                    this.insertRow("LogicalTypeClass", elem.getDefaultValue(), elem.getDefaultValue());
                    ++count;
                }
                this.fireTableRowsInserted(0, count);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public boolean insertRow(String name, String value, String toolTip) {
            ++this.instanceCount;
            ArrayList<String> m = new ArrayList<String>();
            m.add(name);
            m.add(value);
            m.add(toolTip);
            this.data.add(m);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return true;
        }

        public void removeData() {
            this.data.clear();
            this.m_cellChoices.clear();
        }

        public ArrayList getCellChoices(int row) {
            return (ArrayList)this.m_cellChoices.get(row);
        }
    }
}

