/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.subscriber.content;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.subscriber.content.RB;
import com.sas.metadata.remote.ITContentSubscriber;
import com.sas.metadata.remote.Root;
import com.sas.services.information.metadata.SubscriberInterface;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class ContentSubscriberLogicalObject
extends LogicalObject
implements MemberInterface {
    private static final Logger log = Logger.getLogger(ContentSubscriberLogicalObject.class.getName());

    public ContentSubscriberLogicalObject(ITContentSubscriber mdoITContentSubscriber, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoITContentSubscriber, type, factory);
    }

    public boolean delete(OperationUserInteractionInterface oui) {
        String progressText = UtilMisc.getMessage((String)RB.getStringResource("CSLO.UpdProgDelete.fmt.txt"), (Object)this.getName());
        oui.updateProgress(progressText);
        try {
            SubscriberInterface sub = (SubscriberInterface)UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)this);
            if (sub == null) {
                return false;
            }
            sub.delete();
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            if (oui.continueOperationWithPrompting()) {
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("CSLO.DeleteFailedMsg.fmt.txt"), (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)e));
                int choice = oui.displayMessage(RB.getStringResource("CSLO.DeleteFailedTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
            }
            return false;
        }
    }

    public Icon getIcon() {
        return this.getTypeInterface().getIcon(1);
    }

    public MoveDisallowedCause checkMoveAllowed() throws LogicalTypeException, RemoteException {
        return MoveDisallowedCause.NO_SUPPORT_FROM_TYPE;
    }

    public MoveDisallowedCause checkMoveAllowed(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        return MoveDisallowedCause.NO_SUPPORT_FROM_TYPE;
    }
}

