/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.subscriber.content;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.messagequeue.MessageQueueConnectionType;
import com.sas.metadata.logical.server.BasePathConnectionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.subscriber.content.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.services.information.metadata.ContentSubscriberInterface;
import com.sas.services.information.metadata.MessageQueueInterface;
import java.util.Iterator;
import java.util.List;

public class ContentSubscriberImportListener
extends AbstractImportListener {
    protected static final Class[] CONNECTION_TYPES = new Class[]{OtherServerConnectionType.class, MessageQueueConnectionType.class, BasePathConnectionType.class};

    public ContentSubscriberImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        int retVal = 0;
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("CSIL.ProjectRepos.txt"));
        }
        this.verifyImportFolder(importItems);
        return retVal;
    }

    private void verifyImportFolder(List importItems) throws MetadataPromotionException {
        Iterator itor = importItems.iterator();
        DefaultImportItem dit = null;
        while (itor.hasNext()) {
            dit = (DefaultImportItem)itor.next();
            String[] path = dit.getTargetPath();
            if (path.length != 4) {
                throw new MetadataPromotionException(RB.getStringResource("CSIL.InvalidFolder.ex.txt"));
            }
            if (!path[0].equals("System")) {
                throw new MetadataPromotionException(RB.getStringResource("CSIL.InvalidFolder.ex.txt"));
            }
            if (!path[1].equals("Publishing")) {
                throw new MetadataPromotionException(RB.getStringResource("CSIL.InvalidFolder.ex.txt"));
            }
            if (!path[2].equals("Subscribers")) {
                throw new MetadataPromotionException(RB.getStringResource("CSIL.InvalidFolder.ex.txt"));
            }
            if (path[3].equals("Content Subscribers")) continue;
            throw new MetadataPromotionException(RB.getStringResource("CSIL.InvalidFolder.ex.txt"));
        }
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        for (DefaultImportItem dii : objects) {
            try {
                ContentSubscriberInterface sub = (ContentSubscriberInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)dii.getTargetID(), (String)"ITContentSubscriber");
                if (!sub.getDeliveryTransport().equals("queue")) continue;
                MessageQueueInterface q = sub.getMessageQueue(true);
                sub.setQueueName(q.getQueueURI());
                sub.update();
            }
            catch (Exception e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return iRC;
    }
}

