/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server.sas;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.messagequeue.JMSDestinationConnectionType;
import com.sas.metadata.logical.messagequeue.MessageQueueConnectionType;
import com.sas.metadata.logical.server.AppServerConnectionUtil;
import com.sas.metadata.logical.server.BaseServerImportListener;
import com.sas.metadata.logical.server.CommandSubstitutionType;
import com.sas.metadata.logical.server.ConfigurablePropertiesHandler;
import com.sas.metadata.logical.server.HostSubstitutionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.server.ServerUtil;
import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import java.rmi.RemoteException;
import java.util.List;

public class MQPLServerImportListener
extends BaseServerImportListener {
    private ConfigurablePropertiesHandler confPropHandler;
    protected static final Class[] CONNECTION_TYPES = new Class[]{MessageQueueConnectionType.class, JMSDestinationConnectionType.class, OtherServerConnectionType.class};

    public MQPLServerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    @Override
    public Class[] getSubstitutionTypes() {
        return new Class[]{HostSubstitutionType.class, CommandSubstitutionType.class};
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean backupSuccess = AppServerConnectionUtil.backupConfigurableProperties(this.confPropHandler, objects);
        return backupSuccess ? 0 : 4;
    }

    @Override
    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        Log logger = operation.getLogger();
        try {
            ConnectionManagerInterface connectionManager = ConnectionManager.getInstance((PromotionInterface)operation);
            ServerInterface server = operation.getServer();
            RepositoryInterface repo = server.getFoundationRepository();
            for (ImportItemInterface importItem : objects) {
                iRC |= ServerUtil.updateAuthDomainConnectionPoint(connections, connectionManager, server, repo, logger);
                iRC |= AppServerConnectionUtil.updateLoginConnectionPoint(connections, connectionManager, server, repo, logger);
                iRC |= AppServerConnectionUtil.updateIdentityGroupConnectionPoint(connections, connectionManager, server, repo, logger);
            }
            if (operation.getPromotionType() == 2) {
                ServerUtil.updateHostConnection(operation);
            }
            return iRC;
        }
        catch (RemoteException re) {
            iRC |= 4;
            logger.warn((Object)re.getMessage());
        }
        catch (ServiceException se) {
            iRC |= 4;
            logger.warn((Object)se.getMessage());
        }
        catch (Exception e) {
            iRC |= 4;
            logger.warn((Object)e.getMessage());
        }
        return iRC;
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.confPropHandler = ConfigurablePropertiesHandler.getInstance();
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean restored = AppServerConnectionUtil.restoreConfigurableProperties(this.confPropHandler, objects);
        return restored ? 0 : 4;
    }
}

