/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server.sas;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.server.AppServerConnectionUtil;
import com.sas.metadata.logical.server.BaseServerImportListener;
import com.sas.metadata.logical.server.ConfigurablePropertiesHandler;
import com.sas.metadata.logical.server.LogicalServerImportItem;
import com.sas.metadata.logical.server.NestedServerMergeManager;
import com.sas.metadata.logical.server.sas.RB;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.ServerComponent;
import java.rmi.RemoteException;
import java.util.List;

public class LogicalFederationServerImportListener
extends BaseServerImportListener {
    private ConfigurablePropertiesHandler confPropHandler;

    public LogicalFederationServerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    @Override
    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new LogicalServerImportItem(name, id, type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean allMerged = NestedServerMergeManager.merge(objects);
        boolean backupSuccess = AppServerConnectionUtil.backupConfigurableProperties(this.confPropHandler, objects);
        if (allMerged && backupSuccess) {
            return 0;
        }
        return 4;
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.confPropHandler = ConfigurablePropertiesHandler.getInstance();
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean restored = AppServerConnectionUtil.restoreConfigurableProperties(this.confPropHandler, objects);
        Prototype usingPrototype = null;
        String classId = "E803E04B-AAF0-4C74-86A6-F7008AA702DC";
        int flags = 8460;
        String strTemplate = "<TEMPLATES><LogicalServer><UsingComponents/><UsingPrototype/></LogicalServer><ServerComponent><SourceConnections/><UsingPrototype/></ServerComponent><SASClientConnection><UsingPrototype/></SASClientConnection></TEMPLATES>";
        try {
            for (LogicalServerImportItem lsItem : objects) {
                LogicalServer lsSrv = (LogicalServer)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "LogicalServer", lsItem.getTargetID(), null, null, strTemplate, flags);
                ServerComponent srvComponent = (ServerComponent)lsSrv.getUsingComponents().get(0);
                AssociationList lstCon = srvComponent.getSourceConnections();
                for (Connection con : lstCon) {
                    if (!con.getCMetadataType().equalsIgnoreCase("SASClientConnection")) continue;
                    if (usingPrototype == null) {
                        flags = 8584;
                        String select = "<XMLSELECT search = \"*[@Name='Server.FED.Prototype.SASConnection.Name.xmlKey.txt'][Associations/AssociationProperty[@Name='Server.Property.SourceConnections.Name.xmlKey.txt']\"/>";
                        List upList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "Prototype", flags, select);
                        if (upList.size() > 0) {
                            usingPrototype = (Prototype)upList.get(0);
                        }
                    }
                    if (usingPrototype == null) {
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("LogicalFederationServerImportListener.UsingPrototypeNotFound.fmt.txt"), (Object)lsSrv.getName()));
                        continue;
                    }
                    con.getUsingPrototypes().add(usingPrototype);
                    operation.getStore().updatedMetadataAll();
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        return restored ? 0 : 4;
    }
}

