/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.ObjectRenameManager;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.UniqueNameValidator;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ServerUniqueNameValidator
extends UniqueNameValidator
implements ImportNameValidatorInterface {
    private static Log logger;
    private ObjectRenameManager renameManager;
    private Set<String> renamedItemSet = new HashSet<String>();
    private String currentParentItemId;
    private int currentParentItemRenameCount;

    private ServerUniqueNameValidator(UniqueNameValidator.ValidatorContext context) {
        super(context);
    }

    public static ServerUniqueNameValidator getRepositoryNameValidator() {
        return new ServerUniqueNameValidator(UniqueNameValidator.ValidatorContext.REPOSITORY);
    }

    public static ServerUniqueNameValidator getServerNameValidator() {
        return new ServerUniqueNameValidator(UniqueNameValidator.ValidatorContext.SERVER);
    }

    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        try {
            if (logger == null) {
                logger = importOperation.getLogger();
            }
            this.renameManager = ObjectRenameManager.getInstance((ImportOperationInterface)importOperation);
            this.setServer(importOperation.getServer());
            this.setCurrentParentItemId(importItem.getID());
            this.setCurrentParentItemRenameCount(this.renameManager.getObjectRenameCounter(importItem));
            return this.validateName(importItem);
        }
        catch (ServiceException exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
        }
        catch (RemoteException exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    private boolean validateName(ImportItemInterface importItem) {
        String importItemName = importItem.getName();
        String importItemType = importItem.getTypeInterface().getMetadataType();
        boolean isParentImportItemNameUnique = true;
        try {
            if (!this.validateName(importItemName, importItemType)) {
                if (this.getCurrentParentItemId().equalsIgnoreCase(importItem.getID())) {
                    isParentImportItemNameUnique = false;
                } else {
                    this.renameNestedImportItem((NestedImportItemInterface)importItem);
                }
            }
            if (isParentImportItemNameUnique && this.isNestedNamevalidate()) {
                List listNestedItem = importItem.getNestedItems();
                for (NestedImportItemInterface childItem : listNestedItem) {
                    this.validateName((ImportItemInterface)childItem);
                }
            }
            return isParentImportItemNameUnique;
        }
        catch (ServiceException exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
        }
        catch (RemoteException exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            logger.debug((Object)exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    protected boolean validateName(String objName, String objType) throws Exception {
        return !this.renamedItemSet.contains(objName) && super.validateName(objName, objType);
    }

    private boolean renameNestedImportItem(NestedImportItemInterface nestedImportItem) throws Exception {
        String newName = null;
        int renameCounter = 1;
        String importItemName = nestedImportItem.getName();
        String importItemType = nestedImportItem.getTypeInterface().getMetadataType();
        if (this.getCurrentParentItemRenameCount() > 1) {
            renameCounter = this.getCurrentParentItemRenameCount();
        }
        while (true) {
            if (this.validateName(newName = ObjectRenameManager.generateDefaultCopyName((String)importItemName, (int)renameCounter), importItemType)) break;
            ++renameCounter;
        }
        this.renameManager.renameNestedImportItem(nestedImportItem, newName);
        this.renamedItemSet.add(newName);
        this.registerNameChange(nestedImportItem);
        return true;
    }

    private void registerNameChange(NestedImportItemInterface nestedimportItem) {
        ImportItemInterface serverContext;
        if (nestedimportItem.getTypeInterface().getMetadataType().equals("ServerComponent") && (serverContext = this.getRootParent(nestedimportItem)) != null) {
            PropertiesManager manager = nestedimportItem.getImportOperation().getPropertiesManager();
            manager.createSubstitutionProperty(serverContext, nestedimportItem.getOriginalName(), nestedimportItem.getName());
        }
    }

    private ImportItemInterface getRootParent(NestedImportItemInterface nestedServer) {
        ImportItemInterface parent = null;
        if (nestedServer != null && (parent = nestedServer.getParent()) instanceof NestedImportItemInterface) {
            parent = this.getRootParent((NestedImportItemInterface)parent);
        }
        return parent;
    }

    public String getCurrentParentItemId() {
        return this.currentParentItemId;
    }

    public void setCurrentParentItemId(String currentParentItemId) {
        this.currentParentItemId = currentParentItemId;
    }

    public int getCurrentParentItemRenameCount() {
        return this.currentParentItemRenameCount;
    }

    public void setCurrentParentItemRenameCount(int currentParentItemRenameCount) {
        this.currentParentItemRenameCount = currentParentItemRenameCount;
    }
}

