/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.remote.ServerContext;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.Map;

public class PhysicalDirectoryManager
implements NotificationListener {
    private Map _serverMap = new LinkedHashMap(5);
    private PromotionInterface _operation;

    public PhysicalDirectoryManager(PromotionInterface operation) {
        this._operation = operation;
        this._operation.addNotificationListener((NotificationListener)this);
    }

    public boolean exists(ServerContext server, String directoryName) throws WsAppServerFailException, RemoteException {
        if (server == null || directoryName == null) {
            return true;
        }
        WsAppServer appServer = this.getAppServerConnection(server);
        try {
            return appServer == null ? true : appServer.doesFileExist(directoryName);
        }
        catch (GenericError ge) {
            if (appServer != null && "OS".equalsIgnoreCase(appServer.getOperatingSystem())) {
                return false;
            }
            throw new WsAppServerFailException(ge.getLocalizedMessage());
        }
    }

    public void create(ServerContext server, String directoryName) {
    }

    private WsAppServer getAppServerConnection(ServerContext server) throws WsAppServerFailException, RemoteException {
        if (this._serverMap.containsKey(server.getId())) {
            return (WsAppServer)this._serverMap.get(server.getId());
        }
        WsAppServer appServer = ContentHelper.openAppServerConnectionWithoutPrompting((PromotionInterface)this._operation, (ServerContext)server);
        if (appServer != null) {
            this._serverMap.put(server.getId(), appServer);
        }
        return appServer;
    }

    public void notify(NotificationEvent event) {
        switch (event.getEventType()) {
            case 200: 
            case 205: {
                this.closeServerConnections();
                break;
            }
        }
    }

    public void closeServerConnections() {
        for (String serverID : this._serverMap.keySet()) {
            WsAppServer server = (WsAppServer)this._serverMap.get(serverID);
            if (!server.isOpen()) continue;
            server.close();
        }
        this._serverMap.clear();
    }
}

