/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.AppServerConnectionUtil;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import java.rmi.RemoteException;
import java.util.List;

public class NestedServerMergeManager {
    public static boolean merge(List<ImportItemInterface> serversToImport) {
        boolean allUpdated = true;
        if (serversToImport != null) {
            for (ImportItemInterface appServer : serversToImport) {
                if (appServer.getImportState() != 2) continue;
                allUpdated &= NestedServerMergeManager.updateNestedItemStates(appServer);
            }
        }
        return allUpdated;
    }

    private static boolean updateNestedItemStates(ImportItemInterface serverImportItem) {
        boolean updated = true;
        if (serverImportItem.containsNestedItems()) {
            try {
                PublicObjectInterface appServerPO = AppServerConnectionUtil.convertToTargetPublicObject(serverImportItem, serverImportItem.getImportOperation().getServer());
                List children = null;
                String targetId = null;
                if (appServerPO instanceof PublicObjectContainerInterface) {
                    children = ((PublicObjectContainerInterface)appServerPO).getChildren();
                }
                List nestedItems = serverImportItem.getNestedItems();
                for (ImportItemInterface nestedItem : nestedItems) {
                    if (children == null) continue;
                    targetId = NestedServerMergeManager.getTargetID(children, nestedItem);
                    if (targetId != null) {
                        nestedItem.setImportState(2);
                        nestedItem.setTargetID(targetId);
                        continue;
                    }
                    nestedItem.setImportState(1);
                }
            }
            catch (ServiceException exception) {
                serverImportItem.getImportOperation().getLogger().error((Object)exception.getLocalizedMessage());
                updated = false;
            }
            catch (RemoteException exception) {
                serverImportItem.getImportOperation().getLogger().error((Object)exception.getLocalizedMessage());
                updated = false;
            }
        }
        return updated;
    }

    private static String getTargetID(List<MetadataInterface> children, ImportItemInterface nestedServer) throws RemoteException, ServiceException {
        for (MetadataInterface child : children) {
            if (!child.getName().equalsIgnoreCase(nestedServer.getName())) continue;
            return child.getIdentifier();
        }
        return null;
    }
}

