/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.AppServerValidationUtil;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class HostConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface {
    public static final String TYPE_NAME = "Host";
    private static String CLASS_NAME = HostConnectionType.class.getName();
    private List _macineConnectionPoints;
    private static final String MACHINE_TEMPLATE = "<Templates><Machine Name=\"\"><DeployedComponents/></Machine><ServerComponent Name=\"\"/></Templates>";

    public HostConnectionType(PromotionInterface promotionOperation) {
        super(promotionOperation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public static String getTypeClassName() {
        return CLASS_NAME;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("HostConnectionType.localizedTypeName.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.server.HostConnectionPanel";
    }

    public List getSourceConnections() {
        if (this._macineConnectionPoints == null) {
            this._macineConnectionPoints = new ArrayList();
            List machines = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "Machine");
            if (machines.size() > 0) {
                LinkedHashMap<String, SourceConnectionInterface> serverMap = new LinkedHashMap<String, SourceConnectionInterface>();
                ArrayList servers = new ArrayList();
                servers.addAll(machines);
                for (ConnectionPointInterface pt : servers) {
                    SourceConnectionInterface source;
                    String MachineName = HostConnectionType.getMachineName(pt);
                    if (serverMap.containsKey(MachineName)) {
                        source = (SourceConnectionInterface)serverMap.get(MachineName);
                        source.addConnectionPoint(pt);
                        continue;
                    }
                    source = this.createSourceConnection(pt, MachineName);
                    serverMap.put(MachineName, source);
                }
                this._macineConnectionPoints.addAll(serverMap.values());
            }
        }
        return this._macineConnectionPoints;
    }

    public static String getMachineName(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int index = searchAttribute.indexOf("@Name='");
        return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
    }

    public List getTargetConnections() throws MdException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        int flags = 8580;
        List targetServers = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._operation.getStore(), this._operation.getRepositoryID(), "Machine", flags, MACHINE_TEMPLATE, false);
        ArrayList<TargetConnectionInterface> servers = new ArrayList<TargetConnectionInterface>(targetServers.size());
        for (Machine serverMachine : targetServers) {
            servers.add(this.createTargetConnection((CMetadata)serverMachine, serverMachine.getName()));
        }
        return servers;
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return false;
    }

    public void validate(ValidationResponse response, ImportOperationInterface importOperation, SourceConnectionInterface sourceValue) throws MdException, RemoteException {
        AppServerValidationUtil.validateHost(sourceValue.getConnectionPoint().getTargetID(), response);
    }
}

