/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasePathConnectionType
extends AbstractConnectionType
implements DependentConnectionTypeInterface {
    private static final String TYPE_NAME = "Base Path";
    public static final String DAV_SERVER_REQUIRED = "DAV_REQUIRED";
    private List _directoryConnections;
    private DependentConnectionMapping _dependentConnectionMap;
    private Map _targetValueMap;

    public BasePathConnectionType(PromotionInterface operation) {
        super(operation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public List getSourceConnections() {
        if (this._directoryConnections == null) {
            this._directoryConnections = new ArrayList();
            List directories = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "Directory");
            for (ConnectionPointInterface cp : directories) {
                String classId = this.getClassId(cp);
                if (classId == null || !classId.equals("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) continue;
                String directoryName = this.getDirectoryName(cp);
                SourceConnectionInterface source = this.createSourceConnection(cp, directoryName == null ? cp.getName() : directoryName);
                this._directoryConnections.add(source);
            }
        }
        return this._directoryConnections;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("BCCT.ConnectionType.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.server.BasePathConnectionPanel";
    }

    public List getTargetConnections() throws MdException, RemoteException {
        return new ArrayList();
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return true;
    }

    public DependentConnectionMapping getDependentConnectionMapping() {
        if (this._dependentConnectionMap == null) {
            this._dependentConnectionMap = new DependentConnectionMapping();
            ConnectionTypeInterface serverType = this._operation.getConnectionType(OtherServerConnectionType.class.getName());
            List serverConnections = serverType.getSourceConnections();
            if (serverConnections == null || serverConnections.size() == 0) {
                return this._dependentConnectionMap;
            }
            List connections = this.getSourceConnections();
            for (SourceConnectionInterface directoryConnection : connections) {
                String serverName = this.getServerName(directoryConnection);
                SourceConnectionInterface serverConnection = this.getServerConnection(serverType, serverConnections, serverName);
                if (serverConnection == null) continue;
                this._dependentConnectionMap.addDependentConnection(serverConnection, directoryConnection);
            }
        }
        return this._dependentConnectionMap;
    }

    public List getTargetValues(SourceConnectionInterface parentConnection) throws MdException, RemoteException {
        ConnectionTypeInterface type = this._operation.getConnectionType(OtherServerConnectionType.class.getName());
        TargetConnectionInterface target = type.getTargetConnection(parentConnection);
        if (target != null && target.getMetadataObject() instanceof ServerComponent) {
            if (this._targetValueMap == null) {
                this._targetValueMap = new HashMap();
            } else if (this._targetValueMap.containsKey(target)) {
                return (List)this._targetValueMap.get(target);
            }
            ArrayList<TargetConnectionInterface> directoryList = new ArrayList<TargetConnectionInterface>();
            MdFactory factory = this._operation.getMetadataFactory();
            int flags = 268;
            String options = "<Templates><ServerComponent><DataPackages/></ServerComponent><Directory><Properties/></Directory></Templates>";
            ServerComponent server = (ServerComponent)factory.getOMIUtil().getMetadataAllDepths(target.getMetadataObject(), null, null, options, flags);
            List bpList = UtilMetadata.getHTTPServerBasePaths((ServerComponent)server);
            for (Directory dir : bpList) {
                directoryList.add(this.createTargetConnection((CMetadata)dir, dir.getDirectoryName()));
            }
            this._targetValueMap.put(target, directoryList);
            return directoryList;
        }
        return new ArrayList();
    }

    public ConnectionTypeInterface getDependentType() {
        return this._operation.getConnectionType(OtherServerConnectionType.class.getName());
    }

    public void validate(ValidationResponse response, ImportOperationInterface importOperation, SourceConnectionInterface sourceConnection) throws MdException, RemoteException {
        ConnectionPointInterface pt = sourceConnection.getConnectionPoint();
        if (pt != null && pt.getTargetID() != null) {
            String prop = pt.getUserDefinedProperty(DAV_SERVER_REQUIRED);
            if (prop == null || !prop.equals("1")) {
                return;
            }
            MdFactory factory = importOperation.getMetadataFactory();
            int flags = 268;
            String options = "<Templates><Directory><Properties/></Directory></Templates>";
            Directory dir = (Directory)factory.getOMIUtil().getMetadataAllDepths((MdStore)importOperation.getStore(), "Directory", pt.getTargetID(), null, null, options, flags);
            boolean supportsDAV = false;
            for (Property p : dir.getProperties(true)) {
                if (!p.getPropertyName().equals("SupportsWebDAV")) continue;
                supportsDAV = true;
                break;
            }
            if (!supportsDAV) {
                response.setReturnCode(2);
                response.setMessage(RB.getStringResource("BasePathConnectionType.invalid.basepath.selection.txt"));
            }
        }
    }

    private String getDirectoryName(ConnectionPointInterface pt) {
        return PromotionUtil.getAttrValue((String)pt.getSourceSearchString(), (String)"DirectoryName");
    }

    private SourceConnectionInterface getServerConnection(ConnectionTypeInterface serverType, List connections, String serverName) {
        for (SourceConnectionInterface source : connections) {
            if (!serverName.equals(source.getDisplayName())) continue;
            return source;
        }
        return null;
    }

    private String getServerName(SourceConnectionInterface source) {
        int startIndex;
        ConnectionPointInterface pt;
        String searchAttribute;
        int index;
        List connections = source.getConnectionPoints();
        if (connections.size() > 0 && (index = (searchAttribute = (pt = (ConnectionPointInterface)connections.get(0)).getSourceSearchString()).indexOf("@Name='", startIndex = searchAttribute.indexOf("DeployedComponents"))) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }

    private String getClassId(ConnectionPointInterface cp) {
        if (cp != null) {
            List searchStrings = cp.getSourceSearchList();
            for (String searchStr : searchStrings) {
                int startIndex;
                int classIdx = searchStr.indexOf("@ClassIdentifier='", startIndex = searchStr.indexOf("DeployedComponents"));
                if (classIdx <= -1) continue;
                String classId = searchStr.substring(classIdx + 18, searchStr.indexOf(39, classIdx + 18));
                return classId;
            }
        }
        return null;
    }
}

