/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.server.AppServerConnectionUtil;
import com.sas.metadata.logical.server.ApplicationServerImportItem;
import com.sas.metadata.logical.server.BaseServerImportListener;
import com.sas.metadata.logical.server.CommandSubstitutionType;
import com.sas.metadata.logical.server.ConfigurablePropertiesHandler;
import com.sas.metadata.logical.server.HostSubstitutionType;
import com.sas.metadata.logical.server.NestedServerMergeManager;
import com.sas.metadata.logical.server.PortSubstitutionType;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.logical.server.ServerUtil;
import com.sas.metadata.logical.server.ServersOptionsPanel;
import com.sas.metadata.logical.server.SpawnerConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationServerImportListener
extends BaseServerImportListener {
    private ServersOptionsPanel serverOptionsPanel;
    private Class[] CONNECTION_TYPES = new Class[]{SpawnerConnectionType.class};
    private Class[] SUBSTITUTION_TYPES = new Class[]{HostSubstitutionType.class, PortSubstitutionType.class, CommandSubstitutionType.class};
    private ConfigurablePropertiesHandler confPropHandler;
    private static final String SERVER_CONTEXT_PROPERTIES = "ServerContextProperties";

    public ApplicationServerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return this.CONNECTION_TYPES;
    }

    @Override
    public Class[] getSubstitutionTypes() {
        return this.SUBSTITUTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean allMerged = NestedServerMergeManager.merge(objects);
        boolean backupSuccess = AppServerConnectionUtil.backupConfigurableProperties(this.confPropHandler, objects);
        if (allMerged && backupSuccess) {
            return 0;
        }
        return 4;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        boolean restored = AppServerConnectionUtil.restoreConfigurableProperties(this.confPropHandler, objects);
        if (!restored) {
            rc = 4;
        }
        return rc |= this.attachServersToApplication(operation, objects);
    }

    @Override
    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        if (operation.getPromotionType() == 2) {
            try {
                ServerUtil.updateHostConnection(operation);
            }
            catch (ServiceException exception) {
                iRC = 4;
                operation.getLogger().warn((Object)exception.getLocalizedMessage());
            }
            catch (RemoteException exception) {
                iRC = 4;
                operation.getLogger().warn((Object)exception.getLocalizedMessage());
            }
        }
        return iRC |= AppServerConnectionUtil.updateConnectionPointForServer(operation, connections);
    }

    @Override
    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new ApplicationServerImportItem(name, id, type);
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.confPropHandler = ConfigurablePropertiesHandler.getInstance();
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface handler) {
        if (this.serverOptionsPanel == null) {
            this.serverOptionsPanel = new ServersOptionsPanel(1);
        }
        this.serverOptionsPanel.populateImportOptions(aItems, handler);
        return this.serverOptionsPanel;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface handler) {
        return null;
    }

    public void saveSettings() {
    }

    private int attachServersToApplication(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        for (Object o : objects) {
            ImportItemInterface importItem = (ImportItemInterface)o;
            List connections = importItem.getConnectionPoints();
            if (connections == null || connections.isEmpty()) continue;
            for (ConnectionPointInterface cp : connections) {
                if (!"PropertySet".equalsIgnoreCase(cp.getMetadataType()) || !SERVER_CONTEXT_PROPERTIES.equalsIgnoreCase(cp.getName())) continue;
                rc |= this.attachServerToApplication(operation, importItem, cp);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int attachServerToApplication(ImportOperationInterface operation, ImportItemInterface importItem, ConnectionPointInterface cp) {
        int rc = 0;
        MdFactory factory = null;
        MdObjectStore store = null;
        if (operation.getPromotionType() == 2) {
            return rc;
        }
        try {
            factory = operation.getMetadataFactory();
            store = factory.createObjectStore();
            ServerContext sc = (ServerContext)UtilMetadata.locateExistingObject((MdObjectStore)store, (String)"ServerContext", (String)importItem.getTargetID(), (String)"");
            if (sc == null) {
                throw new MetadataPromotionException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationServerImportListener.server.not.found.fmt", (Object)importItem.getName()));
            }
            String appName = cp.getUserDefinedProperty("ApplicationName");
            String compId = cp.getUserDefinedProperty("ComponentClassId");
            if (appName != null && compId != null) {
                AssociationList implementors;
                if (importItem.getImportState() == 1) {
                    rc |= this.createServerContextPropertySet(operation, factory, sc, store, cp);
                } else if (importItem.getImportState() == 2 && (implementors = sc.getImplementedObjects()) != null && !this.isServerContextPropertyExist((List<CMetadata>)implementors)) {
                    rc |= this.createServerContextPropertySet(operation, factory, sc, store, cp);
                }
            }
        }
        catch (Exception e) {
            rc = 4;
            operation.getLogger().warn((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationServerImportListener.connection.preserve.err.fmt", (Object)importItem.getName(), (Object)cp.getUserDefinedProperty("ApplicationName")));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Cause:", (Throwable)e);
            }
        }
        finally {
            try {
                if (store != null && !store.isDisposed()) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                operation.getLogger().warn((Object)e.getLocalizedMessage());
            }
        }
        return rc;
    }

    private boolean isServerContextPropertyExist(List<CMetadata> lstPropertyset) throws RemoteException {
        for (CMetadata prop : lstPropertyset) {
            if (!"PropertySet".equalsIgnoreCase(prop.getCMetadataType()) || !SERVER_CONTEXT_PROPERTIES.equalsIgnoreCase(prop.getName())) continue;
            return true;
        }
        return false;
    }

    private int createServerContextPropertySet(ImportOperationInterface operation, MdFactory factory, ServerContext sc, MdObjectStore store, ConnectionPointInterface cp) throws RemoteException, MdException {
        int rc = 0;
        operation.getLogger().info((Object)("Connecting " + sc.getName() + " to the Web Infra Platform Services application."));
        String xmlSelect = "<XMLSelect search=\"*[@Name='Custom Application Configuration'][OwningObject/DeployedComponent[@ClassIdentifier='" + cp.getUserDefinedProperty("ComponentClassId") + "']/DescriptiveComponent/SoftwareComponent[@Name?'" + cp.getUserDefinedProperty("ApplicationName") + "']]\" />";
        List configurationProperties = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, factory.getOMIUtil().getFoundationReposID(), "PropertySet", 384, xmlSelect);
        if (configurationProperties != null && configurationProperties.size() == 1) {
            PropertySet configurationProperty = (PropertySet)configurationProperties.get(0);
            MdSecurityUtil securityUtil = factory.getSecurityUtil();
            boolean authorized = securityUtil.isWriteAuthorized("PropertySet", configurationProperty.getFQID());
            if (authorized) {
                PropertySet serverContextProperty = (PropertySet)factory.createComplexMetadataObject(store, null, SERVER_CONTEXT_PROPERTIES, "PropertySet", configurationProperty.getRepositoryID());
                serverContextProperty.setOwningObject((Root)configurationProperty);
                sc.getImplementedObjects().add((Object)serverContextProperty);
                String propertyValues = cp.getUserDefinedProperty("SetProperties");
                if (propertyValues != null && !propertyValues.isEmpty()) {
                    Document doc = XMLUtil.convertStringToDocument((String)propertyValues);
                    Node node = doc.getFirstChild();
                    NodeList propertyList = node.getChildNodes();
                    for (int i = 0; i < propertyList.getLength(); ++i) {
                        Node propertyNode = propertyList.item(i);
                        NamedNodeMap attrs = propertyNode.getAttributes();
                        if (attrs == null) continue;
                        String propName = attrs.getNamedItem("Name").getNodeValue();
                        String propValue = attrs.getNamedItem("DefaultValue").getNodeValue();
                        String propType = attrs.getNamedItem("SQLType").getNodeValue();
                        Property property = (Property)factory.createComplexMetadataObject(store, propName, "Property", serverContextProperty.getRepositoryID());
                        property.setDefaultValue(propValue);
                        property.setSQLType(propType);
                        serverContextProperty.getSetProperties().add((Object)property);
                    }
                }
                store.updatedMetadataAll();
            } else {
                rc = 4;
                operation.getLogger().warn((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationServerImportListener.user.authorized.fmt", (Object)sc.getName(), (Object)cp.getUserDefinedProperty("ApplicationName")));
            }
        }
        return rc;
    }
}

