/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.server.ApplicationServerExportItem;
import com.sas.metadata.logical.server.ConfigurablePropertiesHandler;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.logical.server.ServerUtil;
import com.sas.metadata.logical.server.SpawnerConnectionType;
import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class AppServerConnectionUtil {
    private AppServerConnectionUtil() {
    }

    static int updateExportSpawnerConnection(List<ApplicationServerExportItem> serverContexts) throws MdException, RemoteException {
        ConnectionPointInterface cpSpawner = null;
        int rc = 0;
        if (serverContexts != null && serverContexts.size() > 0) {
            ExportOperationInterface _operation = serverContexts.get(0).getExportOperation();
            Set<PublicObjectInterface> spawners = null;
            ConnectionManagerInterface manager = _operation.getConnectionManager();
            for (ApplicationServerExportItem exportItem : serverContexts) {
                try {
                    spawners = AppServerConnectionUtil.getAssociatedSpawners(exportItem);
                    if (spawners == null) continue;
                    for (PublicObjectInterface spawner : spawners) {
                        cpSpawner = _operation.getConnectionManager().getConnection(spawner.getIdentifier());
                        if (cpSpawner == null) continue;
                        cpSpawner.addAssociatedObject((PromotionItemInterface)exportItem);
                    }
                }
                catch (ServiceException exception) {
                    _operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationServer.spawnersub.exception.err.fmt", (Object)exportItem.getName(), (Object)exception.getLocalizedMessage()));
                    rc = 8;
                }
            }
        }
        return rc;
    }

    public static int updateSpawnerConnections(ImportOperationInterface operation) {
        int rc = 0;
        ConnectionTypeInterface spawnerType = operation.getConnectionType(SpawnerConnectionType.getTypeClassName());
        List sourceConnections = spawnerType.getSourceConnections();
        try {
            List targetConnections = spawnerType.getTargetConnections();
            if (sourceConnections != null) {
                ConnectionManagerInterface connectionManager = operation.getConnectionManager();
                TargetConnectionInterface target = null;
                for (SourceConnectionInterface source : sourceConnections) {
                    target = AppServerConnectionUtil.searchTargetConnection(targetConnections, source);
                    if (target == null) continue;
                    connectionManager.mapConnectionByTargetValue(operation, spawnerType, source, target);
                }
            }
        }
        catch (MdException exception) {
            operation.getLogger().warn((Object)exception.getMessage());
            rc = 4;
        }
        catch (RemoteException exception) {
            rc = 4;
            operation.getLogger().warn((Object)exception.getMessage());
        }
        catch (MetadataPromotionException exception) {
            rc = 4;
            operation.getLogger().warn((Object)exception.getMessage());
        }
        return rc;
    }

    private static TargetConnectionInterface searchTargetConnection(List<TargetConnectionInterface> targetConnections, SourceConnectionInterface source) throws RemoteException, MdException {
        Object found = null;
        String name = null;
        String targetPublicType = null;
        if (source != null) {
            for (TargetConnectionInterface target : targetConnections) {
                name = target.getMetadataObject().getName();
                targetPublicType = AppServerConnectionUtil.getPublicTypeAttribute(target.getMetadataObject());
                if (!name.equals(source.getConnectionPoint().getName()) || !source.getConnectionPoint().getPublicType().equals(targetPublicType)) continue;
                return target;
            }
        }
        return null;
    }

    private static String getPublicTypeAttribute(CMetadata object) throws RemoteException {
        Map attrNames = object.getAttrs();
        return attrNames != null ? (String)attrNames.get("PublicType") : null;
    }

    static ServerContext convertToMdObject(ExportItemInterface serverContext, MdStore objectStore) throws MdException, RemoteException {
        int options = 264;
        MdFactory _factory = objectStore.getFactory();
        return (ServerContext)_factory.getOMIUtil().getMetadataAllDepths(objectStore, "ServerContext", serverContext.getID(), null, null, null, options);
    }

    static com.sas.services.information.metadata.ServerInterface getServerPublicObject(ApplicationServerExportItem object) throws ServiceException, RemoteException {
        ObjectConverter convertor = ObjectConverter.getInstance();
        return (com.sas.services.information.metadata.ServerInterface)convertor.convertToPublicObject((SimpleLogicalObjectInterface)object, object.getExportOperation().getServer());
    }

    static Set<PublicObjectInterface> getAssociatedSpawners(ApplicationServerExportItem object) throws ServiceException, RemoteException {
        com.sas.services.information.metadata.ServerInterface server = AppServerConnectionUtil.getServerPublicObject(object);
        HashSet<com.sas.services.information.metadata.ServerInterface> spawners = null;
        Set<com.sas.services.information.metadata.ServerInterface> lServerSpawners = null;
        List<com.sas.services.information.metadata.ServerInterface> serverSpawners = null;
        if (server != null) {
            List servers = server.getServers();
            spawners = new HashSet<com.sas.services.information.metadata.ServerInterface>();
            for (com.sas.services.information.metadata.ServerInterface lserver : servers) {
                if (lserver instanceof LogicalServerInterface) {
                    lServerSpawners = AppServerConnectionUtil.getAssociatedSpawners(lserver.getServers());
                    if (lServerSpawners == null) continue;
                    spawners.addAll(lServerSpawners);
                    continue;
                }
                serverSpawners = AppServerConnectionUtil.getAssociatedSpawners(lserver);
                if (serverSpawners == null) continue;
                spawners.addAll(serverSpawners);
            }
        }
        return spawners != null && spawners.size() > 0 ? spawners : null;
    }

    static Set<SimpleLogicalObjectInterface> getAssociatedSpawnerObjects(ApplicationServerExportItem object) throws ServiceException, RemoteException {
        Set<PublicObjectInterface> spawners = AppServerConnectionUtil.getAssociatedSpawners(object);
        HashSet<SimpleLogicalObjectInterface> lSpawners = null;
        if (spawners != null) {
            SimpleLogicalObjectInterface logicalObject = null;
            ObjectConverter convertor = ObjectConverter.getInstance();
            lSpawners = new HashSet<SimpleLogicalObjectInterface>(spawners.size());
            for (PublicObjectInterface spawner : spawners) {
                logicalObject = convertor.convertToLogicalObject(spawner);
                lSpawners.add(logicalObject);
            }
        }
        return lSpawners;
    }

    private static Set<com.sas.services.information.metadata.ServerInterface> getAssociatedSpawners(List<com.sas.services.information.metadata.ServerInterface> servers) throws ServiceException, RemoteException {
        List<com.sas.services.information.metadata.ServerInterface> serverSpawners = null;
        HashSet<com.sas.services.information.metadata.ServerInterface> spawners = new HashSet<com.sas.services.information.metadata.ServerInterface>();
        for (com.sas.services.information.metadata.ServerInterface server : servers) {
            serverSpawners = AppServerConnectionUtil.getAssociatedSpawners(server);
            if (serverSpawners == null) continue;
            spawners.addAll(serverSpawners);
        }
        return spawners.size() > 0 ? spawners : null;
    }

    private static List<com.sas.services.information.metadata.ServerInterface> getAssociatedSpawners(com.sas.services.information.metadata.ServerInterface server) throws ServiceException, RemoteException {
        List spawners = server.getServers();
        ArrayList<com.sas.services.information.metadata.ServerInterface> objectSpawners = null;
        if (spawners != null && spawners.size() > 0) {
            objectSpawners = new ArrayList<com.sas.services.information.metadata.ServerInterface>(spawners.size());
            String spawnerType = null;
            for (com.sas.services.information.metadata.ServerInterface spawner : spawners) {
                spawnerType = spawner.getType();
                if (!"Spawner.IOM".equals(spawnerType) && !"Spawner.Connect".equals(spawnerType)) continue;
                objectSpawners.add(spawner);
            }
        }
        return objectSpawners;
    }

    public static PublicObjectInterface convertToTargetPublicObject(ImportItemInterface logicalObject, ServerInterface server) throws ServiceException, RemoteException {
        if (server == null) {
            throw new IllegalStateException("Invalid server instance");
        }
        String publicType = logicalObject.getTypeInterface().getPublicType();
        TypeDescriptorInterface type = server.getTypeDescriptor(publicType);
        if (type == null) {
            throw new IllegalArgumentException("Invalid public type definition");
        }
        if (logicalObject.getTargetID() != null) {
            String objectKey = SASFoldersUtil.getISEntityKey((String)logicalObject.getTargetID(), (String)type.getMetadataType());
            return server.fetch(objectKey, true);
        }
        return null;
    }

    public static boolean backupConfigurableProperties(ConfigurablePropertiesHandler confPropHandler, List objects) {
        boolean backupSuccess = true;
        if (objects != null) {
            ImportItemInterface importItem = null;
            for (Object object : objects) {
                importItem = (ImportItemInterface)object;
                if (!confPropHandler.backupRequired(importItem)) continue;
                try {
                    confPropHandler.backup(importItem);
                }
                catch (ServiceException exception) {
                    importItem.getImportOperation().getLogger().warn((Object)exception.getLocalizedMessage());
                    backupSuccess = false;
                }
                catch (RemoteException exception) {
                    importItem.getImportOperation().getLogger().warn((Object)exception.getLocalizedMessage());
                    backupSuccess = false;
                }
                catch (MdException exception) {
                    importItem.getImportOperation().getLogger().warn((Object)exception.getLocalizedMessage());
                    backupSuccess = false;
                }
            }
        }
        return backupSuccess;
    }

    public static boolean restoreConfigurableProperties(ConfigurablePropertiesHandler confPropHandler, List objects) {
        boolean restoreSuccess = true;
        if (objects != null) {
            ImportItemInterface importItem = null;
            for (Object object : objects) {
                importItem = (ImportItemInterface)object;
                if (!confPropHandler.restoreRequired(importItem)) continue;
                try {
                    confPropHandler.restore(importItem);
                }
                catch (ServiceException exception) {
                    importItem.getImportOperation().getLogger().warn((Object)exception.getMessage());
                    restoreSuccess = false;
                }
                catch (RemoteException exception) {
                    importItem.getImportOperation().getLogger().warn((Object)exception.getMessage());
                    restoreSuccess = false;
                }
                catch (MdException exception) {
                    importItem.getImportOperation().getLogger().warn((Object)exception.getMessage());
                    restoreSuccess = false;
                }
                catch (Exception exception) {
                    importItem.getImportOperation().getLogger().warn((Object)exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        return restoreSuccess;
    }

    public static int updateConnectionPointForServer(ImportOperationInterface operation, List connections) {
        Log logger = operation.getLogger();
        int iRC = 0;
        try {
            ConnectionManagerInterface connectionManager = ConnectionManager.getInstance((PromotionInterface)operation);
            ServerInterface server = operation.getServer();
            RepositoryInterface repo = server.getFoundationRepository();
            iRC |= ServerUtil.updateAuthDomainConnectionPoint(connections, connectionManager, server, repo, logger);
            iRC |= AppServerConnectionUtil.updateLoginConnectionPoint(connections, connectionManager, server, repo, logger);
            return iRC |= AppServerConnectionUtil.updateIdentityGroupConnectionPoint(connections, connectionManager, server, repo, logger);
        }
        catch (RemoteException re) {
            iRC |= 4;
            logger.warn((Object)re.getMessage());
        }
        catch (ServiceException se) {
            iRC |= 4;
            logger.warn((Object)se.getMessage());
        }
        catch (Exception e) {
            iRC |= 4;
            logger.warn((Object)e.getMessage());
        }
        return iRC;
    }

    public static int updateLoginConnectionPoint(List connections, ConnectionManagerInterface connectionManager, ServerInterface server, RepositoryInterface repo, Log logger) {
        String sourceSearchString = null;
        String userId = null;
        PublicObjectInterface object = null;
        String objectId = null;
        TypeInterface cpType = null;
        int iRC = 0;
        List listConnectionPoint = connectionManager.getConnections(ConnectionObjectType.MetadataType, "Login");
        try {
            for (ConnectionPointInterface cp : listConnectionPoint) {
                if (null != cp.getTargetID()) continue;
                sourceSearchString = cp.getSourceSearchString();
                userId = sourceSearchString.split("'")[1];
                object = AppServerConnectionUtil.searchByUserId(userId, cp.getMetadataType(), server);
                if (null == object) {
                    objectId = null;
                    cpType = Factory.getInstance().getTypeInterface(cp.getPublicType());
                    for (PromotionItemInterface promotionItem : cp.getAssociatedObjects()) {
                        iRC |= 4;
                        logger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ServerImportListener.ConnectionSkipped.fmt"), (Object)promotionItem.getTypeInterface().getDisplayType(), (Object)promotionItem.getDisplayName(), (Object)cpType.getDisplayType(), (Object)userId));
                    }
                } else {
                    objectId = object.getIdentifier();
                }
                if (null == objectId) continue;
                cp.setTargetID(objectId);
                connections.add(cp);
            }
            return iRC;
        }
        catch (RemoteException re) {
            iRC |= 4;
            logger.warn((Object)re.getMessage());
        }
        catch (ServiceException se) {
            iRC |= 4;
            logger.warn((Object)se.getMessage());
        }
        catch (Exception e) {
            iRC |= 4;
            logger.warn((Object)e.getMessage());
        }
        return iRC;
    }

    public static int updateIdentityGroupConnectionPoint(List connections, ConnectionManagerInterface connectionManager, ServerInterface server, RepositoryInterface repo, Log logger) {
        List listConnectionPoint = connectionManager.getConnections(ConnectionObjectType.PublicType, "UserGroup");
        PublicObjectInterface object = null;
        String objectId = null;
        TypeInterface cpType = null;
        int iRC = 0;
        try {
            for (ConnectionPointInterface cp : listConnectionPoint) {
                if (null != cp.getTargetID()) continue;
                object = ServerUtil.searchByName(cp.getName(), cp.getMetadataType(), server);
                if (null == object) {
                    objectId = null;
                    cpType = Factory.getInstance().getTypeInterface(cp.getPublicType());
                    for (PromotionItemInterface promotionItem : cp.getAssociatedObjects()) {
                        iRC |= 4;
                        logger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ServerImportListener.ConnectionSkipped.fmt"), (Object)promotionItem.getTypeInterface().getDisplayType(), (Object)promotionItem.getDisplayName(), (Object)cpType.getDisplayType(), (Object)cp.getName()));
                    }
                } else {
                    objectId = object.getIdentifier();
                }
                if (null == objectId) continue;
                cp.setTargetID(objectId);
                connections.add(cp);
            }
            return iRC;
        }
        catch (RemoteException re) {
            iRC |= 4;
            logger.warn((Object)re.getMessage());
        }
        catch (ServiceException se) {
            iRC |= 4;
            logger.warn((Object)se.getMessage());
        }
        catch (Exception e) {
            iRC |= 4;
            logger.warn((Object)e.getMessage());
        }
        return iRC;
    }

    private static PublicObjectInterface searchByUserId(String userId, String type, ServerInterface server) throws ServiceException, RemoteException {
        Filter loginFilter = new Filter("UserID", 0, userId);
        loginFilter.setType(type);
        List listLogin = server.search((FilterInterface)loginFilter);
        if (null != listLogin && listLogin.size() > 0) {
            return (PublicObjectInterface)listLogin.get(0);
        }
        return null;
    }
}

