/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.user;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.security.LoginUtil;
import com.sas.metadata.logical.security.user.RB;
import com.sas.metadata.logical.security.user.UserImportListener;
import com.sas.metadata.logical.security.user.UserUtil;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class LoginMergeManager {
    ImportOperationInterface m_operation = null;
    AbstractImportListener m_listener = null;
    boolean m_ignoreLoginCase = true;

    public LoginMergeManager(UserImportListener importListener, ImportOperationInterface operation) {
        this.m_listener = importListener;
        this.m_operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int analyzeLoginForOverwrite(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        try {
            ArrayList<ImportItemInterface> objectsToOverwrite = new ArrayList<ImportItemInterface>();
            for (ImportItemInterface importItem : objects) {
                if (importItem.getImportState() != 2) continue;
                objectsToOverwrite.add(importItem);
            }
            if (objectsToOverwrite.isEmpty()) {
                return iRC;
            }
            Map mapExternalFiles = operation.getAssociationsForObjects(objectsToOverwrite, "<Template><Person Name=\"\"><Logins><Login Name=\"\" UserID=\"\"></Login></Logins></Person></Template>");
            int index = 1;
            int count = objectsToOverwrite.size();
            for (ImportItemInterface importItem : objectsToOverwrite) {
                this.m_listener.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getDisplayName(), (int)index++, (int)count));
                List lstlogins = importItem.getNestedItems();
                Map mapExtFile = (Map)mapExternalFiles.get(importItem.getID());
                List llogins = (List)mapExtFile.get(UserUtil.ASSOCIATION_LOGIN_NAME);
                for (ImportItemInterface nestedImportItem : lstlogins) {
                    List connectionPoint = nestedImportItem.getConnectionPoints();
                    boolean NullAuth = true;
                    String importloginUniqueId = "";
                    String importloginId = "";
                    for (ConnectionPointInterface connPoint : connectionPoint) {
                        if (!"AuthenticationDomain".equals(connPoint.getMetadataType())) continue;
                        NullAuth = false;
                        String AuthName = connPoint.getName();
                        importloginId = nestedImportItem.getID();
                        String Userid = UserUtil.getUserIdforLogin(llogins, importloginId);
                        Userid = LoginUtil.getModifiedUserId(Userid);
                        importloginUniqueId = Userid + "::##::" + AuthName;
                    }
                    if (nestedImportItem.getTypeInterface().getMetadataType().equalsIgnoreCase("Login") && NullAuth) {
                        importloginId = nestedImportItem.getID();
                        String Userid = UserUtil.getUserIdforLogin(llogins, importloginId);
                        Userid = LoginUtil.getModifiedUserId(Userid);
                        importloginUniqueId = Userid + "::##::" + RB.getStringResource("UserImportListener.AuthDomainNone.txt");
                    }
                    nestedImportItem.setUserObject((Object)importloginUniqueId);
                }
                String targetUserID = importItem.getTargetID();
                if (targetUserID == null || targetUserID.length() <= 0) continue;
                MdObjectStore mdStore = null;
                try {
                    mdStore = operation.getMetadataFactory().createObjectStore();
                    Person targetUser = this.getPersonMetadataObject(mdStore, importItem);
                    if (targetUser == null) {
                        iRC |= 8;
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("UserImportListener.TargetFqidNotFoundError.fmt"), (Object)importItem.getDisplayName()));
                        continue;
                    }
                    iRC |= this.analyzeNestedImportedlogins(mdStore, importItem, targetUser);
                }
                finally {
                    if (mdStore == null || mdStore.isDisposed()) continue;
                    mdStore.dispose();
                }
            }
        }
        catch (RemoteException re) {
            operation.getLogger().error((Object)re.getLocalizedMessage());
            iRC |= 8;
        }
        catch (MdException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        catch (LogicalTypeException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        return iRC;
    }

    private int analyzeNestedImportedlogins(MdObjectStore mdStore, ImportItemInterface importItem, Person targetUser) throws RemoteException, MdException, LogicalTypeException, MetadataPromotionException {
        String objectType = null;
        try {
            ServerInterface server = this.m_operation.getServer();
            TypeDescriptorInterface type = server.getTypeDescriptor(targetUser.getPublicType());
            if (type != null) {
                objectType = type.getType();
            }
        }
        catch (Exception e) {
            this.m_operation.getLogger().debug((Object)e.getLocalizedMessage());
        }
        if (objectType == null) {
            objectType = "User";
        }
        int iRC = 0;
        HashMap<String, Login> idMappings = new HashMap<String, Login>();
        AssociationList logins = targetUser.getLogins();
        HashMap<String, Login> AuthDomainMap = new HashMap<String, Login>(logins.size());
        for (Login login : logins) {
            String uniqueloginId = UserUtil.generateloginUniqueId(login, this.m_ignoreLoginCase);
            idMappings.put(uniqueloginId, login);
            AssociationList lstDomain = login.getDomains();
            if (lstDomain != null && lstDomain.size() > 0) {
                AuthenticationDomain Domain = (AuthenticationDomain)lstDomain.get(0);
                AuthDomainMap.put(Domain.toString(), login);
                continue;
            }
            AuthDomainMap.put(RB.getStringResource("UserImportListener.AuthDomainNone.txt"), login);
        }
        if (importItem.containsNestedItems()) {
            List nestedlogins = importItem.getNestedItems();
            for (NestedImportItemInterface nestedItem : nestedlogins) {
                Login target = (Login)idMappings.get(nestedItem.getUserObject().toString());
                if (target != null) {
                    nestedItem.setImportState(0);
                } else {
                    String Key2 = nestedItem.getUserObject().toString();
                    String Domain = null;
                    Login oLogin = null;
                    String UserID = "";
                    boolean chkUnique = false;
                    boolean chkDomain = false;
                    if (Key2 != null && !Key2.equals("")) {
                        String Uniquepair = Key2;
                        String UserId2 = "";
                        UserID = Uniquepair.substring(0, Uniquepair.indexOf(":"));
                        Domain = Uniquepair.substring(Uniquepair.lastIndexOf(":") + 1, Uniquepair.length());
                        oLogin = this.checkifDomainExist(AuthDomainMap, Domain);
                        UserId2 = LoginUtil.getCounterUserId(UserID);
                        chkUnique = this.checkifloginExistsinreposiroty(mdStore, importItem, Uniquepair, UserID, UserId2);
                    }
                    if (chkUnique) {
                        nestedItem.setImportState(0);
                        if (chkUnique) {
                            this.m_operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("UserImportListener.LoginExists.fmt"), (Object)UserID, (Object)importItem.getDisplayName(), (Object)nestedItem.getTypeInterface().getDisplayType(), (Object)importItem.getTypeInterface().getDisplayType()));
                        }
                        iRC |= 4;
                    } else {
                        if (oLogin != null) {
                            this.m_operation.getLogger().warn((Object)Message.format((ResourceBundle)RB.getResources(), (String)"UserImportListener.AuthenticationDomainExists.fmt", (Object)UserID, Domain, (Object)importItem.getDisplayName(), (Object)nestedItem.getTypeInterface().getDisplayType(), (Object)importItem.getTypeInterface().getDisplayType()));
                        }
                        nestedItem.setImportState(1);
                    }
                }
                idMappings.remove(nestedItem.getUserObject().toString());
            }
        }
        return iRC;
    }

    private Login checkifDomainExist(Map hmmAuthDomain, String Domain) throws RemoteException {
        Login objLogin = null;
        objLogin = (Login)hmmAuthDomain.get(Domain);
        return objLogin;
    }

    private boolean checkifloginExistsinreposiroty(MdObjectStore mdStore, ImportItemInterface importItem, String Uniquepair, String UserID, String UserId2) throws RemoteException, MdException {
        Login objLogin;
        Identity lstIdnty;
        String ReposId = importItem.getImportOperation().getRepositoryID();
        String XMLSelect = "<XMLSelect search=\"Login[@UserID='" + UserID + "' or @UserID='" + UserId2 + "']]\"/>";
        int Flag = 8588;
        List object = mdStore.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)mdStore, ReposId, "Login", Flag, XMLSelect);
        if (object != null && object.size() > 0 && (lstIdnty = (objLogin = (Login)object.get(0)).getAssociatedIdentity()) != null) {
            return !lstIdnty.getName().equalsIgnoreCase(importItem.getName());
        }
        return false;
    }

    public Person getPersonMetadataObject(MdObjectStore store, ImportItemInterface importItem) throws RemoteException, MdException {
        String type = importItem.getTypeInterface().getMetadataType();
        String fqid = importItem.getTargetID();
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, "<Templates><Person><Logins/></Person></Templates>", options);
        if (object instanceof Person) {
            return (Person)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int analyzeLoginForAdd(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        try {
            ArrayList<ImportItemInterface> objectsToAdd = new ArrayList<ImportItemInterface>();
            for (ImportItemInterface importItem : objects) {
                if (importItem.getImportState() != 1) continue;
                objectsToAdd.add(importItem);
            }
            if (objectsToAdd.isEmpty()) {
                return iRC;
            }
            Map mapExternalFiles = operation.getAssociationsForObjects(objectsToAdd, "<Template><Person Name=\"\"><Logins><Login Name=\"\" UserID=\"\"></Login></Logins></Person></Template>");
            int index = 1;
            int count = objectsToAdd.size();
            for (ImportItemInterface importItem : objectsToAdd) {
                this.m_listener.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getDisplayName(), (int)index++, (int)count));
                List llogins = importItem.getNestedItems();
                Map mapExtFile = (Map)mapExternalFiles.get(importItem.getID());
                List lstlogins = (List)mapExtFile.get(UserUtil.ASSOCIATION_LOGIN_NAME);
                HashMap<String, String> loginMetadataIdToUniqueId = new HashMap<String, String>(lstlogins.size());
                for (ImportItemInterface nestedImportItem : llogins) {
                    List connectionPoint = nestedImportItem.getConnectionPoints();
                    boolean NullAuth = true;
                    for (ConnectionPointInterface connPoint : connectionPoint) {
                        if (!"AuthenticationDomain".equals(connPoint.getMetadataType())) continue;
                        NullAuth = false;
                        String AuthName = connPoint.getName();
                        String importloginId = nestedImportItem.getID();
                        String Userid = UserUtil.getUserIdforLogin(lstlogins, importloginId);
                        Userid = LoginUtil.getModifiedUserId(Userid);
                        String importloginUniqueId = Userid + "::##::" + AuthName;
                        loginMetadataIdToUniqueId.put(importloginUniqueId, importloginId);
                    }
                    if (!nestedImportItem.getTypeInterface().getMetadataType().equalsIgnoreCase("Login") || !NullAuth) continue;
                    String importloginId = nestedImportItem.getID();
                    String Userid = UserUtil.getUserIdforLogin(lstlogins, importloginId);
                    Userid = LoginUtil.getModifiedUserId(Userid);
                    String importloginUniqueId = Userid + "::##::[None]";
                    loginMetadataIdToUniqueId.put(importloginUniqueId, importloginId);
                }
                String targetUserID = importItem.getTargetID();
                if (targetUserID == null) {
                    MdObjectStore mdStore = null;
                    try {
                        mdStore = operation.getMetadataFactory().createObjectStore();
                        iRC |= this.analyzeloginsforAddedObject(mdStore, importItem, loginMetadataIdToUniqueId);
                        continue;
                    }
                    finally {
                        if (mdStore != null && !mdStore.isDisposed()) {
                            mdStore.dispose();
                        }
                        continue;
                    }
                }
                iRC |= 8;
            }
        }
        catch (RemoteException re) {
            operation.getLogger().error((Object)re.getLocalizedMessage());
            iRC |= 8;
        }
        catch (MdException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        catch (MetadataPromotionException e) {
            iRC = 8;
            operation.getLogger().info((Object)RB.getStringResource("SecurityValidationUtil.InsufficientRights.txt"));
            throw new MetadataPromotionException((Throwable)e);
        }
        return iRC;
    }

    private int analyzeloginsforAddedObject(MdObjectStore mdStore, ImportItemInterface importItem, Map loginMetadataIdToUniqueId) throws RemoteException, MdException {
        int iRC = 0;
        if (importItem.containsNestedItems()) {
            List nestedlogins = importItem.getNestedItems();
            for (NestedImportItemInterface nestedItem : nestedlogins) {
                String UserID;
                List Key2 = UserUtil.getKeysFromValue(loginMetadataIdToUniqueId, nestedItem.getID().toString());
                boolean chkExists = false;
                if (Key2.size() <= 0) continue;
                String UserId2 = "";
                String Uniquepair = (String)Key2.get(0);
                chkExists = this.checkifloginExistsinreposiroty(mdStore, importItem, Uniquepair, UserID = Uniquepair.substring(0, Uniquepair.indexOf(":")), UserId2 = LoginUtil.getCounterUserId(UserID));
                if (chkExists) {
                    nestedItem.setImportState(0);
                    this.m_operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("UserImportListener.LoginExists.fmt"), (Object)UserID, (Object)importItem.getDisplayName(), (Object)nestedItem.getTypeInterface().getDisplayType(), (Object)importItem.getTypeInterface().getDisplayType()));
                    iRC |= 4;
                    continue;
                }
                nestedItem.setImportState(1);
            }
        }
        return iRC;
    }
}

