/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.role;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.security.role.RoleExportItem;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.ApplicationAction;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import java.rmi.RemoteException;
import java.util.List;

public class RoleExportListener
extends AbstractExportListener {
    public static final String ApplicationProperty = "ApplicationName";
    private static final String ACE_APPLICATION_TEMPLATE = "<Templates><AccessControlEntry><Objects/></AccessControlEntry><ApplicationAction><Trees/></ApplicationAction><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";

    public RoleExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new RoleExportItem(name, id, type);
    }

    public int analyzeConnections(ExportOperationInterface operation, List objects) throws MdException, RemoteException {
        int rc = 0;
        return rc |= this.analyzeRoleConnections(operation, objects);
    }

    private int analyzeRoleConnections(ExportOperationInterface operation, List objects) {
        int rc = 0;
        for (Object o : objects) {
            ExportItemInterface exportItem = (ExportItemInterface)o;
            try {
                List listConnectionPoint = exportItem.getConnectionPoints();
                for (ConnectionPointInterface cp : listConnectionPoint) {
                    Tree tree;
                    SoftwareComponent sc;
                    ApplicationAction action;
                    AssociationList lstTree;
                    AccessControlEntry ACE;
                    AssociationList lstAppAction;
                    if (!cp.getMetadataType().equalsIgnoreCase("AccessControlEntry") || (lstAppAction = (ACE = (AccessControlEntry)UtilMetadata.locateExistingObject((MdObjectStore)operation.getStore(), (String)"AccessControlEntry", (String)cp.getSourceID(), (String)ACE_APPLICATION_TEMPLATE)).getObjects()) == null || lstAppAction.isEmpty() || (lstTree = (action = (ApplicationAction)lstAppAction.get(0)).getTrees()) == null || lstTree.isEmpty() || (sc = this.getSoftwareComponentFromTopLevelTree(tree = (Tree)lstTree.get(0))) == null) continue;
                    cp.addUserDefinedProperty(ApplicationProperty, sc.getName());
                }
            }
            catch (MdException e) {
                rc |= 4;
                operation.getLogger().error((Object)e.getLocalizedMessage());
                if (!operation.getLogger().isDebugEnabled()) continue;
                operation.getLogger().debug((Object)"Cause:", (Throwable)e);
            }
            catch (RemoteException e) {
                rc |= 4;
                operation.getLogger().error((Object)e.getLocalizedMessage());
                if (!operation.getLogger().isDebugEnabled()) continue;
                operation.getLogger().debug((Object)"Cause:", (Throwable)e);
            }
        }
        return rc;
    }

    private SoftwareComponent getSoftwareComponentFromTopLevelTree(Tree tree) throws RemoteException, MdException {
        SoftwareComponent sc = null;
        Tree pTree = tree.getParentTree();
        if (pTree == null) {
            AssociationList lstcmp;
            if (tree.getSoftwareComponents() != null && tree.getSoftwareComponents().size() > 0 && (lstcmp = tree.getSoftwareComponents()) != null && lstcmp.size() > 0) {
                sc = (SoftwareComponent)lstcmp.get(0);
                return sc;
            }
        } else {
            sc = this.getSoftwareComponentFromTopLevelTree(pTree);
        }
        return sc;
    }
}

