/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.identitygroup;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.security.LogConnectionSkipped;
import com.sas.metadata.logical.security.LoginUtil;
import com.sas.metadata.logical.security.SecurityValidationUtil;
import com.sas.metadata.logical.security.authenticationdomain.AuthDomainUtil;
import com.sas.metadata.logical.security.identitygroup.LoginMergeManager;
import com.sas.metadata.logical.security.identitygroup.RB;
import com.sas.metadata.logical.security.identitygroup.UserGroupImportItem;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

public class UserGroupImportListener
extends AbstractImportListener {
    private LoginMergeManager m_manager = null;

    public UserGroupImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new UserGroupImportItem(name, id, type);
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        try {
            ConnectionManagerInterface connectionManager = ConnectionManager.getInstance((PromotionInterface)operation);
            ServerInterface server = operation.getServer();
            RepositoryInterface repo = server.getFoundationRepository();
            Log logger = operation.getLogger();
            for (ImportItemInterface importItem : objects) {
                List lConnectionPoints = importItem.getConnectionPoints();
                AuthDomainUtil.updateAuthDomainConnectionPoint(connections, connectionManager, server, repo, logger);
                Iterator iterConnections = lConnectionPoints.iterator();
                while (iterConnections.hasNext()) {
                    String searchCriteria;
                    int flags = 8576;
                    ConnectionPointInterface connPoint = (ConnectionPointInterface)iterConnections.next();
                    if ("IdentityGroup".equals(connPoint.getMetadataType())) {
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List identityGroupList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "IdentityGroup", flags, searchCriteria);
                        if (identityGroupList.isEmpty()) continue;
                        IdentityGroup identityGroupObj = (IdentityGroup)identityGroupList.get(0);
                        connPoint.setTargetID(identityGroupObj.getFQID());
                        connections.add(connPoint);
                        continue;
                    }
                    if ("Person".equals(connPoint.getMetadataType())) {
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List personList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "Person", flags, searchCriteria);
                        if (personList.isEmpty()) continue;
                        Person personObj = (Person)personList.get(0);
                        connPoint.setTargetID(personObj.getFQID());
                        connections.add(connPoint);
                        continue;
                    }
                    if (!"AccessControlTemplate".equals(connPoint.getMetadataType())) continue;
                    searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                    List loginList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "AccessControlTemplate", flags, searchCriteria);
                    if (loginList.isEmpty()) continue;
                    AccessControlTemplate loginObj = (AccessControlTemplate)loginList.get(0);
                    connPoint.setTargetID(loginObj.getFQID());
                    connections.add(connPoint);
                }
            }
        }
        catch (MdException mde) {
            iRC = 8;
            throw new MetadataPromotionException((Throwable)mde);
        }
        catch (RemoteException re) {
            iRC = 8;
            throw new MetadataPromotionException((Throwable)re);
        }
        catch (ServiceException me) {
            throw new MetadataPromotionException((Throwable)me);
        }
        return iRC;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        try {
            LoginUtil.setHostInformation(operation.getPropertiesFile().getProperty("SourceHost"), LoginUtil.getShortHostName(operation.getServer().getHost()));
        }
        catch (ServiceException e) {
            operation.getLogger().error((Object)RB.getStringResource("UserGroupImportListener.hostinformation.not.found.txt"));
            iRC = 4;
        }
        catch (RemoteException e) {
            operation.getLogger().error((Object)RB.getStringResource("UserGroupImportListener.hostinformation.not.found.txt"));
            iRC = 4;
        }
        iRC |= SecurityValidationUtil.isUniqueIdentity(operation, objects);
        iRC |= SecurityValidationUtil.analyzeRights(operation, objects);
        iRC |= this.m_manager.analyzeLoginForOverwrite(operation, objects);
        return iRC |= this.m_manager.analyzeLoginForAdd(operation, objects);
    }

    public int updateObjects(ImportOperationInterface operation, List objects) {
        int returnValue = 0;
        returnValue |= LogConnectionSkipped.logLostConnections(operation, objects);
        try {
            this.updateIdentityGroupLogin(operation, objects);
        }
        catch (RemoteException e) {
            operation.getLogger().error((Object)RB.getStringResource("UserGroupImportListener.login.not.updated.txt"));
            returnValue = 4;
        }
        catch (MdException e) {
            operation.getLogger().error((Object)RB.getStringResource("UserGroupImportListener.login.not.updated.txt"));
            returnValue = 4;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIdentityGroupLogin(ImportOperationInterface operation, List objects) throws RemoteException, MdException {
        for (ImportItemInterface importItem : objects) {
            String targetUserID = importItem.getTargetID();
            if (targetUserID == null || targetUserID.length() <= 0) continue;
            MdObjectStore mdStore = null;
            try {
                mdStore = operation.getMetadataFactory().createObjectStore();
                IdentityGroup targetUser = this.m_manager.getIdentityGroupMetadataObject(mdStore, importItem);
                AssociationList lstLogin = targetUser.getLogins();
                if (lstLogin != null && lstLogin.size() > 0) {
                    LoginUtil.updateLogin(operation, lstLogin);
                }
                mdStore.updatedMetadataAll();
            }
            finally {
                if (mdStore == null || mdStore.isDisposed()) continue;
                mdStore.dispose();
            }
        }
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.m_manager = new LoginMergeManager(this, operation);
    }
}

