/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.identitygroup;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UserGroupExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    private static final String USEDBY_TEMPLATE = "<Templates><AccessControlEntry><AccessControlTemplates/></AccessControlEntry></Templates>";

    public UserGroupExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        try {
            ArrayList<SimpleLogicalObjectInterface> lLogicalObjects = new ArrayList<SimpleLogicalObjectInterface>();
            MdFactory factory = this._exportOperation.getMetadataFactory();
            MdObjectStore mdStore = factory.createObjectStore(null, "UserGroupExportItem.getRelatedObjects");
            try {
                List<String> associations;
                IdentityGroup mdIdentityGroup;
                if (relationshipType == 0) {
                    List<String> associations2 = Arrays.asList("MemberIdentities");
                    IdentityGroup mdIdentityGroup2 = this.getIdentityGroup(factory, mdStore, null, associations2);
                    if (mdIdentityGroup2 != null) {
                        AssociationList lMembers = mdIdentityGroup2.getMemberIdentities();
                        for (Root metadataObject : lMembers) {
                            SimpleLogicalObjectInterface logicalObj = PrivateObjectImportUtility.getLogicalFromJOMAObject(metadataObject);
                            if (logicalObj == null) continue;
                            lLogicalObjects.add(logicalObj);
                        }
                    }
                } else if (relationshipType == 1 && (mdIdentityGroup = this.getIdentityGroup(factory, mdStore, USEDBY_TEMPLATE, associations = Arrays.asList("AccessControlEntries", "IdentityGroups"))) != null) {
                    AssociationList lstAccessControlEntries = mdIdentityGroup.getAccessControlEntries();
                    if (lstAccessControlEntries.size() > 0) {
                        for (int nAce = 0; nAce < lstAccessControlEntries.size(); ++nAce) {
                            AccessControlEntry mdIACES = (AccessControlEntry)lstAccessControlEntries.get(nAce);
                            AssociationList lstActs = mdIACES.getAccessControlTemplates();
                            for (int nObj = 0; nObj < lstActs.size(); ++nObj) {
                                SimpleLogicalObjectInterface lo;
                                AccessControlTemplate mdIACTs = (AccessControlTemplate)lstActs.get(nObj);
                                if (!"ACT".equals(mdIACTs.getPublicType()) || (lo = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)mdIACTs)) == null) continue;
                                lLogicalObjects.add(lo);
                            }
                        }
                    }
                    AssociationList lGroups = mdIdentityGroup.getIdentityGroups();
                    for (IdentityGroup mdIGroups : lGroups) {
                        SimpleLogicalObjectInterface lo;
                        if (!"UserGroup".equals(mdIGroups.getPublicType()) || (lo = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)mdIGroups)) == null) continue;
                        lLogicalObjects.add(lo);
                    }
                }
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            finally {
                mdStore.dispose();
            }
            return lLogicalObjects;
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
    }

    private IdentityGroup getIdentityGroup(MdFactory factory, MdObjectStore mdStore, String template, List<String> associations) throws MdException, RemoteException {
        int iOptions = 268;
        IdentityGroup mdIdentityGroup = (IdentityGroup)factory.getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "IdentityGroup", this.getID(), null, associations, template, iOptions);
        return mdIdentityGroup;
    }
}

