/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security;

import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoginUtil {
    private static final String BACKSLASHSTYLE_PATTERN = "^([^\\\\]+)\\\\(.*)$";
    private static final String FORWARDSLASH_PATTERN = "^(.*)/([^/]+)$";
    private static final String ATSIGNSTYLE_PATTERN = "^(.*)@([^@]+)$";
    public static final String METADATA_HOST_NAME = "SourceHost";
    private static String strSourceHost = "";
    private static String strTargetHost = "";

    public static String getModifiedUserId(String strMetadataUserId) {
        String strTargetUserId = LoginUtil.getNewUserId(strMetadataUserId);
        return strTargetUserId != null ? strTargetUserId : strMetadataUserId;
    }

    private static String getNewUserId(String strMetadataUserId) {
        String strNewUserId = null;
        if (strSourceHost != null && !strSourceHost.equals("") && strMetadataUserId.contains(strSourceHost)) {
            String remainder;
            String domain;
            Matcher matcher = null;
            Pattern domainStyle1 = Pattern.compile(BACKSLASHSTYLE_PATTERN);
            Pattern domainStyle2 = Pattern.compile(ATSIGNSTYLE_PATTERN);
            Pattern domainStyle3 = Pattern.compile(FORWARDSLASH_PATTERN);
            matcher = domainStyle1.matcher(strMetadataUserId);
            if (matcher.matches()) {
                domain = matcher.group(1);
                remainder = matcher.group(2);
                strNewUserId = strTargetHost + "\\" + remainder;
            }
            if ((matcher = domainStyle2.matcher(strMetadataUserId)).matches()) {
                domain = matcher.group(2);
                remainder = matcher.group(1);
                strNewUserId = remainder + "@" + strTargetHost;
            }
            if ((matcher = domainStyle3.matcher(strMetadataUserId)).matches()) {
                domain = matcher.group(1);
                remainder = matcher.group(2);
                strNewUserId = strTargetHost + "/" + remainder;
            }
        } else {
            strNewUserId = strMetadataUserId;
        }
        return strNewUserId;
    }

    public static void updateLogin(ImportOperationInterface operation, AssociationList objects) throws RemoteException, MdException {
        for (Login _login : objects) {
            String newUserId = LoginUtil.getNewUserId(_login.getUserID());
            if (newUserId == null || newUserId.equals(_login.getUserID())) continue;
            _login.setUserID(newUserId);
            _login.updateMetadataAll();
        }
    }

    public static String getShortHostName(String strHost) {
        String strShortHost = null;
        if (strHost != null && strHost.length() > 0) {
            int indexDot = strHost.indexOf(".");
            strShortHost = indexDot != -1 ? strHost.substring(0, indexDot) : strHost.substring(0, strHost.length());
        }
        return strShortHost;
    }

    public static String getCounterUserId(String userId) {
        String strNewUserId = null;
        Pattern domainStyle1 = Pattern.compile(BACKSLASHSTYLE_PATTERN);
        Pattern domainStyle2 = Pattern.compile(ATSIGNSTYLE_PATTERN);
        Matcher matcher = domainStyle1.matcher(userId);
        if (matcher.matches()) {
            String domain = matcher.group(1);
            String remainder = matcher.group(2);
            strNewUserId = remainder + "@" + domain;
        } else {
            matcher = domainStyle2.matcher(userId);
            if (matcher.matches()) {
                String domain = matcher.group(2);
                String remainder = matcher.group(1);
                strNewUserId = domain + "\\" + remainder;
            } else {
                strNewUserId = userId;
            }
        }
        return strNewUserId;
    }

    public static void setHostInformation(String sourceHost, String targetHost) {
        strSourceHost = sourceHost;
        strTargetHost = targetHost;
    }
}

