/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.search;

import com.sas.metadata.logical.ActionType;
import com.sas.metadata.logical.BaseObjectFactory;
import com.sas.metadata.logical.ContainerContextInterface;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalObjectPropertyDialogInterface;
import com.sas.metadata.logical.SmartObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.common.GoToFolderLocationAction;
import com.sas.metadata.logical.search.RB;
import com.sas.metadata.logical.search.SearchDetailsPropertyTab;
import com.sas.metadata.logical.search.SearchFolderGeneralTab;
import com.sas.metadata.logical.search.SearchFolderPropertyDialog;
import com.sas.metadata.logical.search.SearchObject;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Search;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.search.SearchFolder;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class SearchObjectFactory
extends BaseObjectFactory
implements ContainerContextInterface,
SmartObjectFactoryInterface,
LogicalObjectPropertyDialogInterface {
    private Action[] NO_ACTIONS = new Action[0];
    private TypeInterface m_type;
    private Factory m_factory;

    public SearchObjectFactory(TypeInterface type, Factory factory) {
        super(type, factory);
        this.m_type = type;
        this.m_factory = factory;
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root mdo) throws RemoteException {
        return new SearchObject((Search)mdo, this.m_type, this.m_factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String sRepositoryFQID) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("<Templates><");
            sb.append(this.m_type.getMetadataType());
            sb.append(" ");
            sb.append(this.m_factory.getTemplateFormOfRequiredAndNeededAttributes(this.m_type));
            sb.append("/></Templates>");
            int fFlags = 260;
            List lSearchs = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "Search", fFlags, sb.toString());
            ArrayList<LogicalObjectInterface> lObjects = new ArrayList<LogicalObjectInterface>(lSearchs.size());
            for (int iSearch = 0; iSearch < lSearchs.size(); ++iSearch) {
                lObjects.add(this.createItemFromMetadataObject((Root)((Search)lSearchs.get(iSearch))));
            }
            ArrayList<LogicalObjectInterface> arrayList = lObjects;
            return arrayList;
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
    }

    public List<? extends WAPropertyTab> getPropertyTabs(LogicalObjectInterface lob, ChildServerInterface csi, MetadataInterface miObj, Root mdo, Config config) throws MdException, RemoteException {
        ArrayList<Object> lTabs = new ArrayList<Object>(3);
        try {
            SearchFolderGeneralTab tabGeneral = new SearchFolderGeneralTab(mdo, (Tree)mdo.getTrees().get(0), 1, lob, config);
            tabGeneral.setName(RB.getStringResource("SearchObjectFactory.General.txt"));
            lTabs.add((Object)tabGeneral);
            if (lob.isReadCompatible()) {
                SearchDetailsPropertyTab tabCriteria = new SearchDetailsPropertyTab(csi, (SearchFolder)miObj, lob);
                tabCriteria.setName(RB.getStringResource("SearchOjectFactory.Criteria.txt"));
                lTabs.add((Object)tabCriteria);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return lTabs;
    }

    public Action[] getActions(LogicalObjectInterface lobData, Root mdoData, Config config) {
        return this.NO_ACTIONS;
    }

    public Action[] getActions(LogicalObjectInterface[] aLogicalObjects, Root[] aObjects, Config config) {
        return this.NO_ACTIONS;
    }

    public Action[] getActionsForMembers(LogicalObjectInterface container, List<LogicalObjectInterface> selectedMembers, List<PublicObjectInterface> allMembers) throws RemoteException {
        if (container instanceof SearchObject) {
            ArrayList<GoToFolderLocationAction> actions = new ArrayList<GoToFolderLocationAction>(3);
            if (selectedMembers != null && selectedMembers.size() == 1) {
                LogicalObjectInterface obj = selectedMembers.get(0);
                try {
                    if (this._factory.isTypeContainedByFolder(obj.getTypeInterface().getPublicType())) {
                        actions.add(new GoToFolderLocationAction(obj));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return actions.toArray(new Action[actions.size()]);
        }
        return EMPTY_ACTION_ARRAY;
    }

    public boolean isActionSupportedForMembers(ActionType action, LogicalObjectInterface container, List<LogicalObjectInterface> selectedMembers) throws ServiceException, RemoteException {
        return true;
    }

    public WAPropertyDialog getPropertyDialog(Frame Owner, String sTitle, boolean bModal, LogicalObjectInterface lob) {
        return new SearchFolderPropertyDialog(Owner, sTitle, lob, true);
    }
}

