/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.search;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.search.RB;
import com.sas.metadata.logical.search.SearchAdvancedFilterDialog;
import com.sas.metadata.logical.search.SearchFolderPropertyDialog;
import com.sas.metadata.logical.visuals.search.DateFilterComponent;
import com.sas.metadata.logical.visuals.search.DefaultAdvancedFilterDialog;
import com.sas.metadata.logical.visuals.search.FolderScopeComponent;
import com.sas.metadata.logical.visuals.search.NameFilterComponent;
import com.sas.metadata.logical.visuals.search.PublicTypeFilterComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.search.DateFilter;
import com.sas.services.information.search.ExtendedAttributesFilter;
import com.sas.services.information.search.KeywordFilter;
import com.sas.services.information.search.NotesFilter;
import com.sas.services.information.search.ObjectNameFilter;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.ResponsibilitiesFilter;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchFolder;
import com.sas.services.information.search.SearchUtility;
import com.sas.services.information.search.SortOrder;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.UnderlineIcon;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SearchDetailsPropertyTab
extends WAPropertyTab {
    private static final long serialVersionUID = 3554147465288694110L;
    private JPanel _headerPanel;
    private LabelView _headerLabel;
    private JButton _headerResetButton;
    private ObjectNameFilter _startingNameFilter = null;
    private NameFilterComponent nameComponent;
    private PublicTypeFilterComponent ptfComponent;
    private PublicTypeFilter _startingTypeFilter = null;
    private boolean _previouslyLoaded = false;
    private DateFilterComponent dateComponent;
    private DateFilter _startingDateFilter = null;
    private ResponsibilitiesFilter _startingResponsibleFilter = null;
    private KeywordFilter _startingKeywordFilter = null;
    private NotesFilter _startingNotesFilter = null;
    private ExtendedAttributesFilter _startingExtAttrFilter = null;
    private FolderScopeComponent folderComponent;
    private PathUrl _startingFolderUrl = null;
    protected DefaultAdvancedFilterDialog _advancedFilterDialog;
    List<SearchFilter> _advancedFilters = null;
    private boolean _openAdvancedDialog = false;
    private List<String> _keywords = null;
    private String _rpName = null;
    private String _rpRole = null;
    private List<String> _notes = null;
    Map<String, String> _extAttrs = null;
    private ResultDetails.ResultLimit _resultLimit;
    private ResultDetails.ResultLimit _updatedResultLimit = null;
    private SortOrder[] _order;
    private SortOrder[] _updatedOrder = null;
    private SearchFolder m_searchObj;
    private Search _search;
    private List<SearchFilter> _filtersList;
    private List<SearchFilter> _updatedFiltersList;
    private boolean _startingRecursiveSearch;
    private ChildServerInterface _server;
    private JButton _advancedButton;
    private SearchAdvancedFilterDialog _advancedDialog;
    protected boolean isEditable = true;
    LogicalObjectInterface m_LogicalObject = null;
    protected boolean refreshSearch = false;

    public SearchDetailsPropertyTab(ChildServerInterface csi, SearchFolder searchObj, LogicalObjectInterface loi) {
        this.m_searchObj = searchObj;
        this.m_LogicalObject = loi;
        this._server = csi;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("searchview");
        this.setHelpTopic("search_criteria");
    }

    protected void initialize() {
        this.nameComponent = new NameFilterComponent();
        this.ptfComponent = new PublicTypeFilterComponent();
        this.ptfComponent.setTypeDimension(new Dimension(450, 100));
        this.dateComponent = new DateFilterComponent(true);
        this.folderComponent = new FolderScopeComponent();
        this.folderComponent.addPropertyChangeListener("scopeToFolder", (PropertyChangeListener)this.ptfComponent);
        this._advancedButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._advancedButton, (String)RB.getStringResource("SearchDetailsTab.AdvancedButtonLabel.txt"));
        this._advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDetailsPropertyTab.this.onOpenAdvancedDialog();
            }
        });
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        this.configureHeaderPanel();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)this._headerPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        mainPanel.add((Component)this.folderComponent, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this.nameComponent, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this.ptfComponent, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this.dateComponent, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)this._advancedButton, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(mainPanel);
    }

    protected void configureHeaderPanel() {
        this._headerPanel = new JPanel();
        this.add(this._headerPanel);
        AutoSizingGridLayout headerLayout = new AutoSizingGridLayout(1, -1);
        headerLayout.setFillCell(true);
        headerLayout.setUseColumnRemainder(true);
        headerLayout.setRemainderColumn(1);
        this._headerPanel.setLayout((LayoutManager)headerLayout);
        this._headerLabel = new LabelView();
        this._headerLabel.setText(RB.getStringResource("SearchDetailsTab.Header.txt"));
        this._headerLabel.setPreferredSpanSize(new Dimension(-101, -1));
        this._headerPanel.add((Component)this._headerLabel);
        this._headerResetButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._headerResetButton, (String)RB.getStringResource("SearchDetailsTab.ResetDefaults.txt"));
        this._headerResetButton.setRolloverIcon((Icon)new UnderlineIcon(true));
        this._headerResetButton.setIcon((Icon)new UnderlineIcon(false));
        this._headerResetButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this._headerResetButton.setBorderPainted(false);
        this._headerResetButton.setContentAreaFilled(false);
        this._headerResetButton.setVerticalAlignment(3);
        this._headerResetButton.setForeground(SystemColor.blue);
        this._headerResetButton.addActionListener(new ResetAction());
        this._headerPanel.add(this._headerResetButton);
    }

    private void initializeCriteriaTabData() {
        try {
            this._search = this.m_searchObj.getSearch();
            this._filtersList = this._search.getFilters();
            this._order = this._search.getResultDetails().getSortOrder();
            this._resultLimit = this._search.getResultDetails().getResultLimit();
            this._startingFolderUrl = this._search.getFolderScope();
            this._startingRecursiveSearch = this._search.isFolderSearchRecursive();
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        SearchUtility.ValidCriteriaResults results = this.validateCriteria();
        if (results != null && !results.isValidCriteria()) {
            List errorMsgs = results.getCriteriaErrorMsgs();
            MessageUtil.displayListMessage((String)RB.getStringResource("SearchDetailsTab.LoadErrorDialog.Msg.txt"), (List)errorMsgs, (String)RB.getStringResource("SearchDetailsTab.Dialog.Title.txt"), (int)0);
        }
        this.loadCriteria(results);
    }

    private void loadCriteria(SearchUtility.ValidCriteriaResults results) {
        try {
            this.folderComponent.setPreviousValues(this._startingFolderUrl, this._startingRecursiveSearch);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (this._filtersList != null) {
            int len = this._filtersList.size();
            for (int index = 0; index < len; ++index) {
                SearchFilter sc = this._filtersList.get(index);
                if (sc instanceof ObjectNameFilter) {
                    this._startingNameFilter = (ObjectNameFilter)sc;
                    try {
                        this.nameComponent.setPreviousValues((SearchFilter)this._startingNameFilter);
                    }
                    catch (Exception e) {
                        this.nameComponent.resetValues();
                    }
                    continue;
                }
                if (sc instanceof PublicTypeFilter) {
                    this._startingTypeFilter = (PublicTypeFilter)sc;
                    if (this._startingFolderUrl == null) continue;
                    if (results.isFolderValid()) {
                        this.ptfComponent.setTypeScopeToFolders(true);
                        continue;
                    }
                    this.ptfComponent.setTypeScopeToFolders(false);
                    continue;
                }
                if (sc instanceof DateFilter) {
                    this._startingDateFilter = (DateFilter)sc;
                    try {
                        this.dateComponent.loadInitialData();
                        if (this._startingDateFilter == null) continue;
                        this.dateComponent.setPreviousValues((SearchFilter)this._startingDateFilter);
                    }
                    catch (Exception e) {
                        this.dateComponent.resetValues();
                    }
                    continue;
                }
                if (sc instanceof ResponsibilitiesFilter) {
                    this._startingResponsibleFilter = (ResponsibilitiesFilter)sc;
                    if (!results.isResponsibleUserValid()) continue;
                    this._rpName = this._startingResponsibleFilter.getReponsiblePartyName();
                    this._rpRole = this._startingResponsibleFilter.getReponsiblePartyRole();
                    continue;
                }
                if (sc instanceof KeywordFilter) {
                    this._startingKeywordFilter = (KeywordFilter)sc;
                    this._keywords = this._startingKeywordFilter.getKeywords();
                    continue;
                }
                if (sc instanceof NotesFilter) {
                    this._startingNotesFilter = (NotesFilter)sc;
                    this._notes = this._startingNotesFilter.getNotes();
                    continue;
                }
                if (!(sc instanceof ExtendedAttributesFilter)) continue;
                this._startingExtAttrFilter = (ExtendedAttributesFilter)sc;
                this._extAttrs = this._startingExtAttrFilter.getExtendedAttributes();
            }
        }
        try {
            this.ptfComponent.loadInitialData();
            if (this._startingTypeFilter != null) {
                this.ptfComponent.setPreviousValues((SearchFilter)this._startingTypeFilter);
            }
        }
        catch (Exception e) {
            this.ptfComponent.resetValues();
        }
    }

    protected SearchUtility.ValidCriteriaResults validateCriteria() {
        SearchUtility.ValidCriteriaResults results = null;
        try {
            results = SearchUtility.validateSearchCriteria((Search)this._search, (ServerInterface)this._server);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel && !this._previouslyLoaded) {
            this.initializeCriteriaTabData();
            this._previouslyLoaded = true;
        }
        return true;
    }

    private boolean createNameFilter(List<SearchFilter> filtersList) {
        SearchFilter nameFilter = null;
        try {
            nameFilter = this.nameComponent.createFilter();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (nameFilter != null) {
            this.addFilter(filtersList, nameFilter);
        }
        return true;
    }

    private boolean createTypeFilter(List<SearchFilter> filtersList) throws ServiceException {
        SearchFilter typesFilter = null;
        try {
            typesFilter = this.ptfComponent.createFilter();
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (typesFilter != null) {
            this.addFilter(filtersList, typesFilter);
        }
        return true;
    }

    private boolean createDateFilter(List<SearchFilter> filtersList) {
        SearchFilter datesFilter = null;
        try {
            datesFilter = this.dateComponent.createFilter();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (datesFilter != null) {
            this.addFilter(filtersList, datesFilter);
        }
        return true;
    }

    private void addFilter(List<SearchFilter> filtersList, SearchFilter filter) {
        if (filtersList == null) {
            filtersList = new ArrayList<SearchFilter>();
        }
        filtersList.add(filter);
    }

    public boolean validateData() {
        if (this._updatedFiltersList != null) {
            this._updatedFiltersList.clear();
        } else {
            this._updatedFiltersList = new ArrayList<SearchFilter>();
        }
        List currentFiltersList = null;
        try {
            currentFiltersList = this._search.getFilters();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (currentFiltersList != null) {
            currentFiltersList.clear();
        }
        boolean valid = this.populateSearchValues(this._search, this._updatedFiltersList);
        return valid;
    }

    private boolean populateSearchValues(Search search, List<SearchFilter> searchFiltersList) {
        if (search == null) {
            return false;
        }
        try {
            this.createTypeFilter(searchFiltersList);
        }
        catch (ServiceException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            return false;
        }
        this.createNameFilter(searchFiltersList);
        this.createDateFilter(searchFiltersList);
        if (this._advancedFilters != null) {
            searchFiltersList.addAll(this._advancedFilters);
        } else if (!this._openAdvancedDialog) {
            if (this._keywords != null) {
                this.addFilter(searchFiltersList, (SearchFilter)new KeywordFilter(this._keywords));
            }
            if (this._rpName != null || this._rpRole != null) {
                this.addFilter(searchFiltersList, (SearchFilter)new ResponsibilitiesFilter(this._rpName, this._rpRole));
            }
            if (this._notes != null) {
                this.addFilter(searchFiltersList, (SearchFilter)new NotesFilter(this._notes));
            }
            if (this._extAttrs != null) {
                this.addFilter(searchFiltersList, (SearchFilter)new ExtendedAttributesFilter(this._extAttrs));
            }
        }
        try {
            for (SearchFilter sf : searchFiltersList) {
                search.addFilter(sf);
            }
            if (this.folderComponent.getSelectedPathUrl() != null) {
                search.setFolderScope(this.folderComponent.getSelectedPathUrl(), this.folderComponent.getRecursiveFlag());
            } else {
                search.setFolderScope(null, this.folderComponent.getRecursiveFlag());
            }
            if (this._updatedResultLimit == null) {
                search.getResultDetails().setResultLimit(this._resultLimit);
            } else {
                search.getResultDetails().setResultLimit(this._updatedResultLimit);
            }
            if (this._updatedOrder == null) {
                search.getResultDetails().setSortOrder(this._order);
            } else {
                search.getResultDetails().setSortOrder(this._updatedOrder);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            return false;
        }
        SortOrder.setSortingEnabled((boolean)false);
        SearchUtility.ValidCriteriaResults results = this.validateCriteria();
        if (results != null && !results.isValidCriteria()) {
            List errorMsgs = results.getCriteriaErrorMsgs();
            MessageUtil.displayListMessage((String)RB.getStringResource("SearchDetailsTab.SaveErrorDialog.Msg.txt"), (List)errorMsgs, (String)RB.getStringResource("SearchDetailsTab.Dialog.Title.txt"), (int)0);
            return false;
        }
        return true;
    }

    public void onParentOK() {
        WAPropertyDialog dialog;
        if (this._search == null) {
            try {
                this._search = this.m_searchObj.getSearch();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            SearchUtility.ValidCriteriaResults results = this.validateCriteria();
            if (results != null && !results.isValidCriteria()) {
                List errorMsgs = results.getCriteriaErrorMsgs();
                MessageUtil.displayListMessage((String)RB.getStringResource("SearchDetailsTab.SaveErrorDialog.Msg.txt"), (List)errorMsgs, (String)RB.getStringResource("SearchDetailsTab.Dialog.Title.txt"), (int)0);
            }
        }
        super.onParentOK();
        this.removePropertyChangeListener("scopeToFolder", (PropertyChangeListener)this.ptfComponent);
        boolean criteriaChanged = this.isSearchModified(this._search);
        if (criteriaChanged && (dialog = (WAPropertyDialog)this.getRootPane().getParent()) instanceof SearchFolderPropertyDialog) {
            ((SearchFolderPropertyDialog)dialog).setRefreshRequiredIndicator(true);
        }
    }

    private boolean isSearchModified(Search _search) {
        boolean isChanged = false;
        try {
            List currentFiltersList = _search.getFilters();
            PathUrl currentFolderUrl = _search.getFolderScope();
            boolean currentRecursiveSearch = _search.isFolderSearchRecursive();
            if (currentFolderUrl != null) {
                if (!currentFolderUrl.equals((Object)this._startingFolderUrl)) {
                    isChanged = true;
                    return isChanged;
                }
            } else if (this._startingFolderUrl != null) {
                isChanged = true;
                return isChanged;
            }
            if (currentRecursiveSearch != this._startingRecursiveSearch) {
                isChanged = true;
                return isChanged;
            }
            ObjectNameFilter currentNameFilter = null;
            PublicTypeFilter currentTypeFilter = null;
            DateFilter currentDateFilter = null;
            ResponsibilitiesFilter currentResponsibleFilter = null;
            KeywordFilter currentKeywordFilter = null;
            NotesFilter currentNotesFilter = null;
            ExtendedAttributesFilter currentExtAttrFilter = null;
            for (SearchFilter sf : currentFiltersList) {
                if (sf instanceof ObjectNameFilter) {
                    currentNameFilter = (ObjectNameFilter)sf;
                    if (currentNameFilter.equals((Object)this._startingNameFilter)) continue;
                    isChanged = true;
                    continue;
                }
                if (sf instanceof PublicTypeFilter) {
                    currentTypeFilter = (PublicTypeFilter)sf;
                    if (currentTypeFilter.equals((Object)this._startingTypeFilter)) continue;
                    isChanged = true;
                    continue;
                }
                if (sf instanceof DateFilter) {
                    currentDateFilter = (DateFilter)sf;
                    if (currentDateFilter.equals((Object)this._startingDateFilter)) continue;
                    isChanged = true;
                    continue;
                }
                if (sf instanceof ResponsibilitiesFilter) {
                    currentResponsibleFilter = (ResponsibilitiesFilter)sf;
                    if (currentResponsibleFilter.equals((Object)this._startingResponsibleFilter)) continue;
                    isChanged = true;
                    continue;
                }
                if (sf instanceof KeywordFilter) {
                    currentKeywordFilter = (KeywordFilter)sf;
                    if (currentKeywordFilter.equals((Object)this._startingKeywordFilter)) continue;
                    isChanged = true;
                    continue;
                }
                if (sf instanceof NotesFilter) {
                    currentNotesFilter = (NotesFilter)sf;
                    if (currentNotesFilter.equals((Object)this._startingNotesFilter)) continue;
                    isChanged = true;
                    continue;
                }
                if (!(sf instanceof ExtendedAttributesFilter) || (currentExtAttrFilter = (ExtendedAttributesFilter)sf).equals((Object)this._startingExtAttrFilter)) continue;
                isChanged = true;
            }
            if (isChanged) {
                return isChanged;
            }
            if (this._startingNameFilter != null && currentNameFilter == null) {
                isChanged = true;
            } else if (this._startingTypeFilter != null && currentTypeFilter == null) {
                isChanged = true;
            } else if (this._startingDateFilter != null && currentDateFilter == null) {
                isChanged = true;
            } else if (this._startingResponsibleFilter != null && currentResponsibleFilter == null) {
                isChanged = true;
            } else if (this._startingKeywordFilter != null && currentKeywordFilter == null) {
                isChanged = true;
            } else if (this._startingNotesFilter != null && currentNotesFilter == null) {
                isChanged = true;
            } else if (this._startingExtAttrFilter != null && currentExtAttrFilter == null) {
                isChanged = true;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return isChanged;
    }

    public void onParentCancel() {
        super.onParentCancel();
        this.removePropertyChangeListener("scopeToFolder", (PropertyChangeListener)this.ptfComponent);
    }

    private void resetAllValues() {
        this.resetFolderValues();
        this.resetNameFilter();
        this.resetTypeFilter();
        this.resetDateFilter();
        if (this._advancedDialog != null) {
            this._advancedDialog.resetAllValues();
            this._advancedDialog.validateData();
        }
    }

    private void resetNameFilter() {
        try {
            this.nameComponent.setPreviousValues((SearchFilter)this._startingNameFilter);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void resetTypeFilter() {
        try {
            this.ptfComponent.setPreviousValues((SearchFilter)this._startingTypeFilter);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void resetDateFilter() {
        try {
            this.dateComponent.setPreviousValues((SearchFilter)this._startingDateFilter);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void resetFolderValues() {
        try {
            this.folderComponent.setPreviousValues(this._startingFolderUrl, this._startingRecursiveSearch);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void onOpenAdvancedDialog() {
        if (this._advancedDialog == null) {
            Container container = this.getTopLevelAncestor();
            WAPropertyDialog dialog = (WAPropertyDialog)container;
            String title = RB.getStringResource("SearchDetailsTab.AdvancedDialog.Title.txt");
            this._advancedDialog = new SearchAdvancedFilterDialog(title, this.m_searchObj, (Dialog)dialog);
        }
        this._advancedDialog.setSearchEditable(this.isEditable);
        this._advancedDialog.show();
        this._openAdvancedDialog = true;
        this._advancedDialog.dispose();
        this._advancedFilters = this._advancedDialog.getFilters();
        if (this._advancedDialog.isDisplayingResultsConfiguration()) {
            this._updatedOrder = this._advancedDialog.getResultsPanel().getSortOrder();
            this._updatedResultLimit = this._advancedDialog.getResultsPanel().getResultLimit();
        }
    }

    public void setEditable(boolean bEditable) {
        boolean editableValue = bEditable;
        try {
            if (!this.m_searchObj.isCompatible()) {
                editableValue = false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.isEditable = editableValue;
        super.setEditable(editableValue);
        this._headerResetButton.setEnabled(editableValue);
        this.folderComponent.setEditable(editableValue);
        this.nameComponent.setEditable(editableValue);
        this.ptfComponent.setEditable(editableValue);
        this.dateComponent.setEditable(editableValue);
    }

    class ResetAction
    implements ActionListener {
        ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchDetailsPropertyTab.this.resetAllValues();
        }
    }
}

