/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.option.GridOptionsSet;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.option.GridOptionsSet.GridOptionsSetExportListener;
import com.sas.metadata.logical.option.GridOptionsSet.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.ApplicationFilter;
import com.sas.services.information.metadata.ApplicationInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GridApplicationInterface;
import com.sas.services.information.metadata.GridServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GridOptionsSetImportListener
extends AbstractImportListener {
    public final String SASAPPNAMEINSEARCHSTRING = "Name";
    protected static final String GRIDCAPABLE = "isGridCapable";
    protected static final String GRIDCAPABLE2 = "IsGridCapable";

    public GridOptionsSetImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return GridOptionsSetExportListener.CONNECTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        int retVal = 0;
        this.verifyImportFolder(importItems);
        return retVal;
    }

    private void verifyImportFolder(List importItems) throws MetadataPromotionException {
        Iterator itor = importItems.iterator();
        DefaultImportItem cit = null;
        while (itor.hasNext()) {
            cit = (DefaultImportItem)itor.next();
            String[] path = cit.getTargetPath();
            if (path.length < 3 || path.length > 3) {
                throw new MetadataPromotionException(RB.getStringResource("GridOptionsSetImportListener.InvalidFolder.ex.txt"));
            }
            if (!path[0].equals("Shared Data")) {
                throw new MetadataPromotionException(RB.getStringResource("GridOptionsSetImportListener.InvalidFolder.ex.txt"));
            }
            if (!path[1].equals("SAS Grid Manager")) {
                throw new MetadataPromotionException(RB.getStringResource("GridOptionsSetImportListener.InvalidFolder.ex.txt"));
            }
            if (path[2].equals("Grid Options Set")) continue;
            throw new MetadataPromotionException(RB.getStringResource("GridOptionsSetImportListener.InvalidFolder.ex.txt"));
        }
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int retVal = 0;
        ServerInterface server = null;
        ArrayList<BrowseMetadataInterface> totalUsers = new ArrayList();
        ArrayList<FolderInterface> totalApps = new ArrayList();
        Log importLogger = operation.getLogger();
        if (importLogger == null) {
            throw new MetadataPromotionException(RB.getStringResource("GridOptionsSetImportListener.NoLog.txt"));
        }
        try {
            UserContextInterface userContext = operation.getUserContext();
            server = userContext.getAuthServer();
            totalUsers = this.getTotalUsers(server);
            totalApps = this.getAppFolderList(server);
        }
        catch (ServiceException e1) {
            retVal = 8;
            importLogger.error((Object)RB.getStringResource("GridOptionsSetExportListener.findNoUser.txt"));
        }
        catch (RemoteException e) {
            retVal = 8;
            importLogger.error((Object)RB.getStringResource("GridOptionsSetExportListener.findNoUser.txt"));
        }
        catch (MdException e) {
            retVal = 8;
            importLogger.error((Object)RB.getStringResource("GridOptionsSetExportListener.findNoUser.txt"));
        }
        for (DefaultImportItem dii : objects) {
            GridApplicationInterface gos = null;
            try {
                gos = (GridApplicationInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)dii.getTargetID(), (String)dii.getTypeInterface().getMetadataType());
            }
            catch (RemoteException e) {
                retVal = 8;
                importLogger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                importLogger.error((Object)RB.getStringResource("GridOptionsSetImportListener.findNoGOS.fmt.txt"));
            }
            catch (ServiceException e) {
                retVal = 8;
                importLogger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                importLogger.error((Object)RB.getStringResource("GridOptionsSetImportListener.findNoGOS.fmt.txt"));
            }
            List connectionPointList = dii.getConnectionPoints();
            PromotionPropertiesFile propertiesFile = operation.getPropertiesFile();
            ArrayList<String> appList = new ArrayList<String>();
            HashMap<String, String> appServerMap = new HashMap<String, String>();
            for (Object o : connectionPointList) {
                ConnectionPointInterface cpi = (ConnectionPointInterface)o;
                if (cpi.getMetadataType().equalsIgnoreCase("Property")) {
                    String searchString = cpi.getSourceSearchString();
                    String sasAppName = PromotionUtil.getAttrValue((String)searchString, (String)"Name");
                    appList.add(sasAppName);
                }
                if (!cpi.getMetadataType().equalsIgnoreCase("LogicalServer")) continue;
                String sourceName = cpi.getName();
                String targetID = cpi.getTargetID();
                appServerMap.put(sourceName, targetID);
            }
            for (Map.Entry pairs : appServerMap.entrySet()) {
                String sourceName = pairs.getKey().toString();
                String targetID = pairs.getValue().toString();
                try {
                    CMetadata temp = UtilMetadata.locateExistingObject((MdObjectStore)operation.getStore(), (String)"LogicalServer", (String)targetID, null);
                    LogicalServer sx = (LogicalServer)temp;
                    ServerComponent sc = this.getServerComponent(sx);
                    try {
                        GridServerInterface gridServer = (GridServerInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (CMetadata)sc);
                        LinkedHashSet titles = new LinkedHashSet(appList);
                        appList.clear();
                        appList.addAll(titles);
                        for (String app : appList) {
                            String key = sourceName + "||" + dii.getName() + "||" + app;
                            String value = propertiesFile.getProperty(key);
                            List<String> identityList = this.parseStringIntoList(value, ";");
                            ArrayList<String> newUserList = new ArrayList<String>();
                            for (String user : identityList) {
                                if (!this.isAppGridCapable(app, server)) {
                                    importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("GridOptionsSetImportListener.sasAppNotGridCapable.fmt.txt"), (Object)app));
                                }
                                if (!this.isAppExisted(app, totalApps)) {
                                    retVal = 4;
                                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("GridOptionsSetImportListener.findNoSASAppinTarget.fmt.txt"), (Object)app));
                                    break;
                                }
                                if (!this.findUserbyName(user, totalUsers)) {
                                    retVal = 4;
                                    importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("GridOptionsSetImportListener.findNoUserinTarget.fmt.txt"), (Object)user));
                                    continue;
                                }
                                newUserList.add(user);
                            }
                            if (newUserList.size() <= 0 || gos == null || app == null) continue;
                            gridServer.setUserMappings(app, newUserList, gos);
                            String userL = this.makeListIntoString(newUserList, ";");
                            importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("GridOptionsSetImportListener.setusermapping.fmt.txt"), (Object)gridServer.getName(), (Object)app, (Object)userL, (Object)gos.getName()));
                        }
                        gridServer.update();
                    }
                    catch (ServiceException e) {
                        retVal = 8;
                        importLogger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                catch (RemoteException e) {
                    retVal = 8;
                    importLogger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (MdException e) {
                    retVal = 8;
                    importLogger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return retVal;
    }

    private List<String> parseStringIntoList(String propertyValue, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (propertyValue == null) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(propertyValue, delimiter);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            result.add(nextToken);
        }
        return result;
    }

    private String makeListIntoString(List<String> valueList, String delimiter) {
        if (valueList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String nextValue : valueList) {
            if (!isFirst) {
                sb.append(delimiter);
            }
            sb.append(nextValue);
            isFirst = false;
        }
        return sb.toString();
    }

    private ServerComponent getServerComponent(LogicalServer sc) throws RemoteException, MdException {
        AssociationList lsList = sc.getUsingComponents();
        if (lsList != null && lsList.size() > 0) {
            ServerComponent ls = (ServerComponent)lsList.get(0);
            return ls;
        }
        return null;
    }

    private boolean findUserbyName(String newUser, List<BrowseMetadataInterface> totalUsers) {
        for (BrowseMetadataInterface user : totalUsers) {
            String expectedUser = user.getName();
            if (!expectedUser.equalsIgnoreCase(newUser)) continue;
            return true;
        }
        return false;
    }

    public List<BrowseMetadataInterface> getTotalUsers(ServerInterface server) throws ServiceException, MdException, RemoteException {
        List identitiesList = null;
        ArrayList<BrowseMetadataInterface> users = new ArrayList<BrowseMetadataInterface>();
        String searchString = "<XMLSelect search=\"*[@PublicType='User' or @PublicType='UserGroup']\"/>";
        int flags = 26780;
        Filter filter = new Filter();
        filter.setOMRFlags(flags);
        filter.setType("Identity");
        filter.setExplicitSearchString("omi", searchString);
        identitiesList = server.browseSearch((FilterInterface)filter);
        for (BrowseMetadataInterface e : identitiesList) {
            if (e.getName().equalsIgnoreCase("PUBLIC") || e.getName().equalsIgnoreCase("SASUSERS")) continue;
            users.add(e);
        }
        return users;
    }

    private List<FolderInterface> getAppFolderList(ServerInterface server) throws ServiceException, RemoteException {
        ArrayList<FolderInterface> appList = new ArrayList<FolderInterface>();
        String path = "/System/Applications";
        PathUrl pathURL = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
        FolderInterface appFolder = (FolderInterface)server.getObjectByPath(pathURL);
        List allItems = appFolder.getSubfolders();
        for (FolderInterface folder : allItems) {
            appList.add(folder);
        }
        return appList;
    }

    private boolean isAppGridCapable(String appName, ServerInterface server) throws ServiceException, RemoteException {
        boolean gridCapable = false;
        ApplicationFilter filter = new ApplicationFilter();
        filter.setOnlyGridCapable(true);
        List appList = server.search((FilterInterface)filter);
        for (ApplicationInterface app : appList) {
            String name;
            FolderInterface parentFolder;
            FolderInterface folder = app.getParent();
            if (folder == null || (parentFolder = folder.getParent()) == null || !appName.equalsIgnoreCase(name = parentFolder.getName())) continue;
            return true;
        }
        return gridCapable;
    }

    private boolean isAppExisted(String appName, List<FolderInterface> appList) throws RemoteException, ServiceException {
        boolean found = false;
        for (FolderInterface f : appList) {
            if (!f.getName().equalsIgnoreCase(appName)) continue;
            found = true;
            List keywordList = f.getKeywords();
            for (Object obj : keywordList) {
                if (obj.toString().equalsIgnoreCase(GRIDCAPABLE) && obj.toString().startsWith(GRIDCAPABLE) && obj.toString().startsWith(GRIDCAPABLE2)) continue;
                ArrayList<String> keyword = new ArrayList<String>();
                keyword.add(GRIDCAPABLE);
                f.setKeywords(keyword);
            }
        }
        return found;
    }
}

