/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.option.GridOptionsSet;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.option.GridOptionsSet.GridOptionsSetInterface;
import com.sas.metadata.logical.option.GridOptionsSet.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.GridApplicationInterface;
import com.sas.services.information.metadata.GridServerInterface;
import com.sas.services.information.metadata.OMRGridApplication;
import com.sas.services.information.metadata.OMRGridServer;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.List;

public class GridOptionsSetExportListener
extends AbstractExportListener
implements GridOptionsSetInterface {
    public static final String ORIGINALPATH = "OriginalPath";
    protected static final Class[] CONNECTION_TYPES = new Class[]{AppServerConnectionType.class};

    public GridOptionsSetExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public int analyzeConnections(ExportOperationInterface operation, List objects) throws MdException, RemoteException {
        int retVal = super.analyzeConnections(operation, objects);
        ServerInterface server = null;
        Log exportLogger = operation.getLogger();
        ConnectionManagerInterface connMgr = operation.getConnectionManager();
        try {
            UserContextInterface userContext = operation.getUserContext();
            server = userContext.getAuthServer();
        }
        catch (ServiceException e1) {
            retVal = 8;
            exportLogger.error((Object)RB.getStringResource("GridOptionsSetExportListener.findNoUser.txt"));
        }
        for (Object o : objects) {
            ExportItemInterface exportItem = (ExportItemInterface)o;
            String exportItemID = exportItem.getID();
            try {
                GridApplicationInterface gos = (GridApplicationInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)exportItemID, (String)exportItem.getTypeInterface().getMetadataType());
                if (gos == null) continue;
                List serverList = gos.getGOSRelatedServers();
                for (ServerComponent s : serverList) {
                    LogicalServer ls = this.getLogicalServer(s);
                    ServerContext sx = this.getServerContext(ls);
                    ConnectionPointInterface cpt = connMgr.createConnection("LogicalServer", ls.getId(), ls.getName());
                    if (cpt == null) {
                        retVal = 8;
                        exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("GridOptionsSetExportListener.findNoConnectionPointError.txt"), (Object)exportItemID));
                        continue;
                    }
                    cpt.setPublicType("LogicalServer.Grid");
                    cpt.addAssociatedObject((PromotionItemInterface)exportItem);
                    StringBuffer b = new StringBuffer();
                    b.append("*[@ClassIdentifier='D7E796B4-654C-4ab3-B690-657EE79309FB' and @Name='");
                    b.append(ls.getName());
                    b.append("'][UsedByComponents/");
                    b.append("[@ClassIdentifier='SAS Application Server' and @Name='");
                    b.append(sx.getName());
                    b.append("']");
                    cpt.addSourceSearch(b.toString());
                    GridServerInterface gridServer = this.getGridServerInterface(s, server);
                    List psList = gridServer.getPropertySetNames();
                    for (PropertySet ps : psList) {
                        List gaoList = gridServer.getExistingGOSListForApp(server, ps.getName());
                        for (OMRGridApplication a : gaoList) {
                            List userList = gridServer.getUserMappings(ps.getName(), a.getName());
                            PromotionPropertiesFile propertiesFile = operation.getPropertiesFile();
                            if (userList == null || userList.size() <= 0) continue;
                            propertiesFile.addProperty(ls.getName() + "||" + a.getName() + "||" + ps.getName(), this.makeListIntoString(userList, ";"));
                        }
                    }
                }
            }
            catch (ServiceException e) {
                retVal = 8;
                exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("GridOptionsSetExportListener.findNoSmartObjectError.txt"), (Object)exportItemID));
            }
            catch (RemoteException e) {
                retVal = 8;
                exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("GridOptionsSetExportListener.findNoSmartObjectError.txt"), (Object)exportItemID));
            }
        }
        return retVal;
    }

    private String makeListIntoString(List<String> valueList, String delimiter) {
        if (valueList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String nextValue : valueList) {
            if (!isFirst) {
                sb.append(delimiter);
            }
            sb.append(nextValue);
            isFirst = false;
        }
        return sb.toString();
    }

    private GridServerInterface getGridServerInterface(ServerComponent s, ServerInterface authServer) throws ServiceException, RemoteException {
        Object server = null;
        FilterComponent fc1 = new FilterComponent("PublicType", 0, "Server.Grid");
        Filter filter = new Filter();
        filter.setFilterComponent(fc1);
        filter.setType("ServerComponent");
        filter.setName(s.getName());
        List serverList = authServer.search((FilterInterface)filter);
        if (serverList.size() > 0) {
            return (GridServerInterface)serverList.get(0);
        }
        OMRGridServer gridServer = new OMRGridServer(s);
        return gridServer;
    }

    private LogicalServer getLogicalServer(ServerComponent s) throws RemoteException, MdException {
        AssociationList lsList = s.getUsedByComponents();
        if (lsList != null && lsList.size() > 0) {
            LogicalServer ls = (LogicalServer)lsList.get(0);
            return ls;
        }
        return null;
    }

    private ServerContext getServerContext(LogicalServer s) throws RemoteException, MdException {
        AssociationList lsList = s.getUsedByComponents();
        if (lsList != null && lsList.size() > 0) {
            return (ServerContext)lsList.get(0);
        }
        return null;
    }
}

