/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.messagequeue;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.messagequeue.AbstractMessageQueueManagerImportListener;
import com.sas.metadata.logical.messagequeue.RB;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import java.rmi.RemoteException;
import java.util.List;

public class MessageQueueManagerImportListener
extends AbstractMessageQueueManagerImportListener {
    public MessageQueueManagerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        MdFactory factory = operation.getMetadataFactory();
        for (DefaultImportItem item : objects) {
            String message;
            try {
                MetadataInterface mi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)item.getTargetID(), (String)item.getTypeInterface().getMetadataType());
                if (!(mi instanceof ServerComponentInterface)) continue;
                ServerComponent scomp = (ServerComponent)mi.getRepositoryEntity();
                String hostName = ((TCPIPConnection)scomp.getSourceConnections().get(0)).getHostName();
                int flags = 8604;
                String strOpts = "<XMLSelect search=\"*[@Name='" + hostName + "']\"/><TEMPLATES><Machine/></TEMPLATES>";
                List machines = factory.getOMIUtil().getMetadataObjectsSubset(scomp.getObjectStore(), "A0000001." + scomp.getRepositoryID(), "Machine", flags, strOpts);
                Machine machine = null;
                machine = machines.size() == 0 ? (Machine)factory.createComplexMetadataObject(factory.createObjectStore(), null, hostName, "Machine", scomp.getRepositoryID(), null) : (Machine)machines.get(0);
                scomp.setAssociatedMachine(machine);
                scomp.updateMetadataAll();
            }
            catch (ServiceException e) {
                message = UtilMisc.getMessage((String)RB.getStringResource("MQM.ImportListener.ServiceException.fmt.txt"), (Object)e.getMessage());
                operation.getLogger().error((Object)message);
                return 8;
            }
            catch (RemoteException e) {
                message = UtilMisc.getMessage((String)RB.getStringResource("MQM.ImportListener.RemoteException.txt"), (Object)e.getMessage());
                operation.getLogger().error((Object)message);
                return 8;
            }
            catch (MdException e) {
                message = UtilMisc.getMessage((String)RB.getStringResource("MQM.ImportListener.MetadataException.fmt.txt"), (Object)e.getMessage());
                operation.getLogger().error((Object)message);
                return 8;
            }
        }
        return 0;
    }
}

