/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.messagequeue;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.messagequeue.RB;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class AbstractQueueObjectConnectionType
extends AbstractConnectionType
implements DependentConnectionTypeInterface {
    private static final String QUEUE_MAN_KEY = "MESSAGE_QUEUE_SERVER_NAME";
    protected DependentConnectionMapping _dependentConnectionMap;
    protected List _qObjConnections;
    protected Map _targetValueMap;

    public AbstractQueueObjectConnectionType(PromotionInterface promotionOperation) {
        super(promotionOperation);
    }

    public void analyzeConnections() throws MdException, RemoteException {
        List queueConnections = this._connectionManager.getConnections(ConnectionObjectType.PublicType, this.getQueueObjectType(), true);
        for (ConnectionPointInterface cpi : queueConnections) {
            try {
                MetadataInterface queueObj = PromotionUtil.getSmartObject((PromotionInterface)this._operation, (String)cpi.getSourceID(), (String)cpi.getMetadataType());
                Transformation trans = (Transformation)queueObj.getRepositoryEntity();
                ServerComponent qman = (ServerComponent)trans.getDeployedComponents().get(0);
                ConnectionPointInterface newCp = this._connectionManager.createConnection("ServerComponent", qman.getFQID(), qman.getName());
                Vector<PromotionItemInterface> objects = new Vector<PromotionItemInterface>();
                PromotionItemInterface pi = this._operation.getPromotionItem(cpi.getPublicType(), cpi.getSourceID());
                if (pi != null) {
                    objects.add(pi);
                }
                objects.addAll(cpi.getAssociatedObjects());
                newCp.addAssociatedObjects(objects);
                cpi.addUserDefinedProperty(QUEUE_MAN_KEY, qman.getName());
                StringBuffer b = new StringBuffer();
                b.append("[@ClassIdentifier='");
                b.append(qman.getClassIdentifier());
                b.append("' and @Name='");
                b.append(qman.getName());
                b.append("']");
                newCp.addSourceSearch(b.toString());
                newCp.setPublicType(qman.getPublicType());
                String qmanPath = this._operation.getMetadataFactory().getOMIUtil().getObjectPath((MdObjectStore)qman.getObjectStore(), (PrimaryType)qman, false);
                if (qmanPath == null || qmanPath.equals("")) continue;
                newCp.setSourcePath(qmanPath);
            }
            catch (ServiceException e) {
                String message = UtilMisc.getMessage((String)RB.getStringResource("MQ.ConnectionType.ServiceException.fmt.txt"), (Object)e.getMessage());
                this._operation.getLogger().error((Object)message);
            }
        }
    }

    public static String getClassIdentifier(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int endIndex = searchAttribute.indexOf(93);
        int index = searchAttribute.indexOf("@ClassIdentifier='");
        if (index < endIndex && index > -1) {
            return searchAttribute.substring(index + 18, searchAttribute.indexOf(39, index + 18));
        }
        return "";
    }

    public DependentConnectionMapping getDependentConnectionMapping() {
        if (this._dependentConnectionMap == null) {
            this._dependentConnectionMap = new DependentConnectionMapping();
            ConnectionTypeInterface qManType = this._operation.getConnectionType(OtherServerConnectionType.getTypeClassName());
            if (qManType == null) {
                return this._dependentConnectionMap;
            }
            List qManConnections = qManType.getSourceConnections();
            if (qManConnections == null || qManConnections.size() == 0) {
                return this._dependentConnectionMap;
            }
            List<SourceConnectionInterface> connections = this.getSourceConnections();
            for (SourceConnectionInterface qObjConnection : connections) {
                String qManName = this.getQueueManagerName(qObjConnection.getConnectionPoint());
                SourceConnectionInterface qManConnection = this.getQueueManagerConnection(qManType, qManConnections, qManName);
                if (qManConnection == null) continue;
                this._dependentConnectionMap.addDependentConnection(qManConnection, qObjConnection);
            }
        }
        return this._dependentConnectionMap;
    }

    public ConnectionTypeInterface getDependentType() {
        return this._operation.getConnectionType(OtherServerConnectionType.getTypeClassName());
    }

    protected SourceConnectionInterface getQueueManagerConnection(ConnectionTypeInterface qManType, List connections, String qManName) {
        if (qManName == null) {
            return null;
        }
        for (SourceConnectionInterface source : connections) {
            ConnectionPointInterface pt = source.getConnectionPoint();
            if (!qManName.equals(source.getDisplayName()) || !this.isMatchingClassIdentifier(AbstractQueueObjectConnectionType.getClassIdentifier(pt))) continue;
            return source;
        }
        return null;
    }

    protected String getQueueManagerName(ConnectionPointInterface pt) {
        int startIndex;
        String value = pt.getUserDefinedProperty(QUEUE_MAN_KEY);
        if (value != null) {
            return value;
        }
        String searchAttribute = pt.getSourceSearchString();
        int index = searchAttribute.indexOf("@Name='", startIndex = searchAttribute.indexOf("DeployedComponents"));
        if (index > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }

    public List<SourceConnectionInterface> getSourceConnections() {
        if (this._qObjConnections == null) {
            this._qObjConnections = new ArrayList();
            List qobjs = this._connectionManager.getConnections(ConnectionObjectType.PublicType, this.getQueueObjectType());
            for (ConnectionPointInterface pt : qobjs) {
                SourceConnectionInterface source = this.createSourceConnection(pt, pt.getName());
                this._qObjConnections.add(source);
            }
        }
        return this._qObjConnections;
    }

    public List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException {
        return new ArrayList<TargetConnectionInterface>();
    }

    public List getTargetValues(SourceConnectionInterface parentConnection) throws MdException, RemoteException {
        TargetConnectionInterface target;
        ConnectionTypeInterface type = this._operation.getConnectionType(OtherServerConnectionType.getTypeClassName());
        if (type != null && (target = type.getTargetConnection(parentConnection)) != null && target.getMetadataObject() instanceof ServerComponent) {
            if (this._targetValueMap == null) {
                this._targetValueMap = new HashMap();
            } else if (this._targetValueMap.containsKey(target)) {
                return (List)this._targetValueMap.get(target);
            }
            ArrayList<TargetConnectionInterface> qObjList = new ArrayList<TargetConnectionInterface>();
            MdFactory factory = this._operation.getMetadataFactory();
            int flags = 268;
            String options = "<Templates><ServerComponent><InitProcesses/></ServerComponent></Templates>";
            ServerComponent qMan = (ServerComponent)factory.getOMIUtil().getMetadataAllDepths(target.getMetadataObject(), null, null, options, flags);
            AssociationList qObjs = qMan.getInitProcesses();
            for (Object obj : qObjs) {
                if (!(obj instanceof Transformation)) continue;
                Transformation qTrans = (Transformation)obj;
                if (!this.getQueueObjectTransformRole().equals(qTrans.getTransformRole())) continue;
                qObjList.add(this.createTargetConnection((CMetadata)qTrans, qTrans.getName()));
            }
            this._targetValueMap.put(target, qObjList);
            return qObjList;
        }
        return new ArrayList();
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return true;
    }

    protected abstract String getQueueObjectTransformRole();

    protected abstract String getQueueObjectType();

    protected abstract boolean isMatchingClassIdentifier(String var1);
}

