/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.ActionContextInterface;
import com.sas.metadata.logical.ContainerChangeEvent;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.favorites.FavoritesContainerLogicalObjectInterface;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.metadata.favorites.FavoritesGroup;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

class RemoveAction
extends AbstractAction
implements ActionContextInterface {
    private FavoritesContainerLogicalObjectInterface _container;
    private List<LogicalObjectInterface> _members;
    private final String ACTION_CONTEXT = "FAVORITES_CONTEXT";

    public RemoveAction(FavoritesContainerLogicalObjectInterface container, List<LogicalObjectInterface> members) {
        this._container = container;
        this._members = members;
        Util.setLabelAndMnemonicOnAction((Action)this, (String)RB.getStringResource("RemoveAction.Label.txt"));
        this.putValue("ShortDescription", RB.getStringResource("RemoveAction.ToolTip.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._container == null || this._members == null) {
            return;
        }
        ChildServerInterface childServer = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            childServer = server.newChild(true);
            String key = this._container.getID() + "/" + this._container.getTypeInterface().getMetadataType();
            MetadataInterface mi = childServer.fetch(key, true);
            if (!(mi instanceof FavoritesContainer)) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewFavoritesFolderAction.NoFolder.fmt.txt", (Object)this._container.getName());
                throw new ServiceException(msg);
            }
            ArrayList<MetadataInterface> children = new ArrayList<MetadataInterface>(this._members.size());
            FavoritesContainer container = (FavoritesContainer)mi;
            for (LogicalObjectInterface item : this._members) {
                key = item.getID() + "/" + item.getTypeInterface().getMetadataType();
                MetadataInterface child = childServer.fetch(key, true);
                if (child == null) continue;
                children.add(child);
                if (child instanceof FavoritesGroup) {
                    container.removeFavoritesGroup((FavoritesGroup)child);
                    continue;
                }
                container.removeFavorite(child);
            }
            container.update();
            ContainerChangeEvent event = null;
            for (MetadataInterface child : children) {
                event = new ContainerChangeEvent(this, ContainerChangeEvent.EventType.MEMBER_REMOVED, (PublicObjectContainerInterface)container, (PublicObjectInterface)child);
                this.firePropertyChange("CONTAINER_CHANGE_EVENT", null, event);
            }
        }
        catch (ServiceException ex) {
            UtilGui.displayExceptionError((Exception)((Object)ex));
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
        finally {
            if (childServer != null) {
                try {
                    childServer.destroy();
                }
                catch (Exception ex) {}
            }
        }
    }

    public String getActionContext() {
        return "FAVORITES_CONTEXT";
    }
}

