/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.favorites.NewFavoritesFolderDialog;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.logical.visuals.Images;
import com.sas.metadata.logical.visuals.NewObjectActionInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class NewFavoritesFolderAction
extends AbstractAction
implements NewObjectActionInterface {
    private Frame _frame;
    private FolderInterface _parentFolder;

    public NewFavoritesFolderAction(Frame frame, FolderInterface logicalObject) {
        this._frame = frame;
        this._parentFolder = logicalObject;
        Util.setLabelAndMnemonicOnAction((Action)this, (String)RB.getStringResource("NewFavoritesFolderAction.Label.txt"));
        this.putValue("SmallIcon", Images.getNewObjectIcon((String)"FavoritesFolder"));
        this.putValue("ShortDescription", RB.getStringResource("NewFavoritesFolderAction.ToolTip.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._parentFolder == null) {
            return;
        }
        ChildServerInterface childServer = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            childServer = server.newChild(true);
            String key = this._parentFolder.getID() + "/" + this._parentFolder.getTypeInterface().getMetadataType();
            com.sas.services.information.metadata.FolderInterface folder = (com.sas.services.information.metadata.FolderInterface)childServer.fetch(key, true);
            if (folder == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewFavoritesFolderAction.NoFolder.fmt.txt", (Object)this._parentFolder.getName());
                throw new ServiceException(msg);
            }
            NewFavoritesFolderDialog dialog = new NewFavoritesFolderDialog(this._frame, folder);
            dialog.show();
        }
        catch (ServiceException ex) {
            UtilGui.displayExceptionError((Exception)((Object)ex));
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
        finally {
            if (childServer != null) {
                try {
                    childServer.destroy();
                }
                catch (Exception ex) {}
            }
        }
    }

    public String getActionLabel() {
        return RB.getStringResource("NewFavoritesFolderAction.Label.txt");
    }
}

