/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.favorites.FavoritesContainerLogicalObjectInterface;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

class MoveAction
extends AbstractAction {
    private DirectionType _direction;
    private FavoritesContainerLogicalObjectInterface _container;
    private List<LogicalObjectInterface> _members;

    public MoveAction(FavoritesContainerLogicalObjectInterface container, List<LogicalObjectInterface> members, DirectionType direction) {
        this._direction = direction;
        this._container = container;
        this._members = members;
        Util.setLabelAndMnemonicOnAction((Action)this, (String)this._direction.getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._container == null) {
            return;
        }
        ChildServerInterface childServer = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            childServer = server.newChild(true);
            String key = this._container.getID() + "/" + this._container.getTypeInterface().getMetadataType();
            MetadataInterface mi = childServer.fetch(key, true);
            if (!(mi instanceof FavoritesContainer)) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewFavoritesFolderAction.NoFolder.fmt.txt", (Object)this._container.getName());
                throw new ServiceException(msg);
            }
            FavoritesContainer container = (FavoritesContainer)mi;
            int size = container.getFavoriteCount();
            if (size <= 1) {
                return;
            }
            for (LogicalObjectInterface item : this._members) {
                int currentPos;
                key = item.getID() + "/" + item.getTypeInterface().getMetadataType();
                MetadataInterface child = childServer.fetch(key, true);
                if (child == null || (currentPos = container.getFavoriteIndex(child)) <= -1) continue;
                switch (this._direction) {
                    case UP: {
                        if (currentPos <= 0) break;
                        container.removeFavorite(child);
                        container.insertFavorite(child, currentPos - 1);
                        break;
                    }
                    case DOWN: {
                        if (currentPos >= size - 1) break;
                        container.removeFavorite(child);
                        container.insertFavorite(child, currentPos + 1);
                    }
                }
            }
            mi.update();
        }
        catch (ServiceException ex) {
            UtilGui.displayExceptionError((Exception)((Object)ex));
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
        finally {
            if (childServer != null) {
                try {
                    childServer.destroy();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static enum DirectionType {
        UP(RB.getStringResource("MoveAction.Up.txt")),
        DOWN(RB.getStringResource("MoveAction.Down.txt"));

        private String _label;

        private DirectionType(String label) {
            this._label = label;
        }

        public String getLabel() {
            return this._label;
        }
    }
}

