/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.favorites.FavoritesFolderImportItem;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class FavoritesImportOptionsPanel
extends JPanel {
    private TriStateCheckBox _ckbReplace = new TriStateCheckBox();
    private boolean _dataChanged;
    private SimpleLogicalObjectInterface[] m_aItems;

    public FavoritesImportOptionsPanel() {
        Util.configureMnemonicForButton((AbstractButton)this._ckbReplace, (String)RB.getStringResource("FavoritesImportOptionsPanel.Replace.txt"));
        this._ckbReplace.setCycleEnabled(false);
        this._ckbReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FavoritesImportOptionsPanel.this._dataChanged = true;
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this._ckbReplace, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateImportOptions(ImportItemInterface[] aItems) {
        this.m_aItems = aItems;
        boolean enabled = false;
        if (aItems != null) {
            for (ImportItemInterface item : aItems) {
                if (2 != item.getImportState()) continue;
                enabled = true;
                break;
            }
        }
        this._ckbReplace.setEnabled(enabled);
        this._ckbReplace.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
    }

    public void saveSettings() {
        if (!this._dataChanged) {
            return;
        }
        if (this.m_aItems != null) {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                ((FavoritesFolderImportItem)this.m_aItems[i]).setReplacingFavorites(this._ckbReplace.isSelected());
            }
        }
        this._dataChanged = false;
    }

    private int determineCheckBoxState(SimpleLogicalObjectInterface[] aItems) {
        if (aItems == null) {
            return 0;
        }
        boolean bAllOn = true;
        boolean bAllOff = true;
        for (int i = 0; i < aItems.length; ++i) {
            boolean bOn = ((FavoritesFolderImportItem)aItems[i]).isReplacingFavorites();
            bAllOn &= bOn;
            bAllOff &= !bOn;
        }
        if (bAllOn) {
            return 2;
        }
        if (bAllOff) {
            return 0;
        }
        return 1;
    }
}

