/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.document;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.document.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.List;

public class DocumentImportListener
extends AbstractImportListener {
    public DocumentImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        for (ImportItemInterface docItem : objects) {
            String type;
            this.fireDisplayMessage(StatusMessageUtil.createUpdatingMessage((TypeInterface)docItem.getTypeInterface(), (String)docItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("DocumentImportListener.MetadataInfo.fmt"), (Object)docItem.getName()));
            boolean bMetadataChanged = false;
            try {
                String id = docItem.getTargetID();
                if (id == null || id.length() == 0) {
                    id = docItem.getID();
                }
                Document docObject = this.getDocumentMetadataObject(operation.getStore(), docItem, id);
                PromotionUtil.updateProductInfo((Root)docObject, (ImportOperationInterface)operation);
                bMetadataChanged = true;
                boolean publicTypeChanged = UtilMetadata.setPublicType((PrimaryType)docObject, (String)"Document");
                if (publicTypeChanged) {
                    bMetadataChanged = true;
                }
                if (!bMetadataChanged) continue;
                bMetadataChanged = false;
                docObject.updateMetadataAll();
            }
            catch (MdException e) {
                type = docItem.getTypeInterface().getDisplayType();
                String name = docItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("DocumentImportListener.errorValidatingMetadata.fmt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            catch (RemoteException e) {
                type = docItem.getTypeInterface().getDisplayType();
                String name = docItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("DocumentImportListener.errorValidatingMetadata.fmt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
        }
        return rc;
    }

    private Document getDocumentMetadataObject(MdObjectStore store, ImportItemInterface importItem, String fqid) throws MdException, RemoteException {
        String type = importItem.getTypeInterface().getMetadataType();
        String template = "<Templates><Document><Objects/><Trees/></Document></Templates>";
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        if (object instanceof Document) {
            return (Document)object;
        }
        throw new MdException("Invalid type returned from metadata for Note: " + object.getCMetadataType());
    }
}

