/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.common;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.application.ApplicationExportItem;
import com.sas.metadata.logical.application.ApplicationType;
import com.sas.metadata.logical.application.ApplicationUtility;
import com.sas.metadata.logical.common.RB;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class SoftwareDependencyTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static DefaultTreeModel EMPTY_MODEL = new DefaultTreeModel(null);
    private JPanel _mainPanel;
    private JTree _treeDep;
    private JScrollPane _depPane;
    private JLabel _depLabel;
    private JTree _treeUses;
    private JScrollPane _usesPane;
    private JLabel _usesLabel;
    private WATextArea _noDepText;
    private JScrollPane _noDepPane;
    private WATextArea _noUsesText;
    private JScrollPane _noUsesPane;
    private CMetadata _comp;
    private TypeInterface _type;

    public SoftwareDependencyTab(TypeInterface type, CMetadata root) {
        this._type = type;
        this._comp = root;
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this._treeDep = new JTree();
        this._treeDep.setModel(new DefaultTreeModel(null));
        this._treeDep.setCellRenderer(new TreeNodeRenderer());
        this._treeDep.setRootVisible(false);
        this._treeUses = new JTree();
        this._treeUses.setModel(new DefaultTreeModel(null));
        this._treeUses.setCellRenderer(new TreeNodeRenderer());
        this._treeUses.setRootVisible(false);
        this._mainPanel = new JPanel();
        this._mainPanel.setVisible(true);
        this._depPane = new JScrollPane(this._treeDep);
        this._depPane.setVisible(true);
        this._depLabel = new JLabel(RB.getStringResource("SoftwareDependencyTab.depLabel.txt"));
        this._usesPane = new JScrollPane(this._treeUses);
        this._usesPane.setVisible(true);
        this._usesLabel = new JLabel(RB.getStringResource("SoftwareDependencyTab.usesLabel.txt"));
        this._noDepText = new WATextArea(RB.getStringResource("SoftwareDependencyTab.NoDep.txt"));
        this._noDepText.setBehavior(1);
        this._noDepPane = new JScrollPane((Component)this._noDepText);
        this._noUsesText = new WATextArea(RB.getStringResource("SoftwareDependencyTab.NoUses.txt"));
        this._noUsesText.setBehavior(1);
        this._noUsesPane = new JScrollPane((Component)this._noUsesText);
        this.setHelpTopic("app_depend_tab");
        this.setHelpProduct("shared");
        super.setName(RB.getStringResource("SoftwareDependencyTab.Label.txt"));
        this.loadComponent();
    }

    public void layoutWidgets() {
        this._mainPanel.setLayout(new GridBagLayout());
        this._depPane.setPreferredSize(new Dimension(200, 280));
        this._usesPane.setPreferredSize(new Dimension(200, 280));
        this._noDepPane.setPreferredSize(new Dimension(200, 280));
        this._noUsesPane.setPreferredSize(new Dimension(200, 280));
        this._mainPanel.add((Component)this._depLabel, new GridBagConstraints(0, 0, -1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 3), 0, 0));
        this._mainPanel.add((Component)this._depPane, new GridBagConstraints(0, 1, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 3), 0, 0));
        this._mainPanel.add((Component)this._noDepPane, new GridBagConstraints(0, 1, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 3), 0, 0));
        this._mainPanel.add((Component)this._usesLabel, new GridBagConstraints(0, 3, -1, 1, 1.0, 0.0, 18, 1, new Insets(20, 0, 0, 3), 0, 0));
        this._mainPanel.add((Component)this._usesPane, new GridBagConstraints(0, 4, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 3), 0, 0));
        this._mainPanel.add((Component)this._noUsesPane, new GridBagConstraints(0, 4, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 3), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(this._mainPanel);
    }

    public void loadComponent() {
        ArrayList dependencies = new ArrayList();
        ArrayList usedBy = new ArrayList();
        try {
            List usedByObjects;
            List dependentObjects = ApplicationUtility.getRelatedObjects((SoftwareComponent)this._comp, 0);
            if (dependentObjects != null && dependentObjects.size() > 0) {
                dependencies.addAll(dependentObjects);
            }
            if ((usedByObjects = ApplicationUtility.getRelatedObjects((SoftwareComponent)this._comp, 1)) != null && usedByObjects.size() > 0) {
                usedBy.addAll(usedByObjects);
            }
        }
        catch (LogicalTypeException e) {
            return;
        }
        this.createDependencyTree(dependencies, 0);
        this.createDependencyTree(usedBy, 1);
    }

    private void addDependentObjectsToTree(List dependentObjects, DefaultMutableTreeNode rootNode, int dependencyType) throws ServiceException, RemoteException {
        for (Object item : dependentObjects) {
            if (!(item instanceof SimpleLogicalObjectInterface)) continue;
            SimpleLogicalObjectInterface logicalObject = (SimpleLogicalObjectInterface)item;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(logicalObject);
            rootNode.add(node);
            if (!"Application".equalsIgnoreCase(logicalObject.getTypeInterface().getPublicType())) continue;
            ApplicationExportItem exItem = new ApplicationExportItem(logicalObject.getName(), logicalObject.getID(), (ApplicationType)this._type);
            try {
                List objects = ApplicationUtility.getRelatedObjects(exItem, dependencyType, this._comp.getObjectStore().getFactory());
                this.addDependentObjectsToTree(objects, node, dependencyType);
            }
            catch (LogicalTypeException e) {
                Workspace.getDefaultLogger().debug((Object)MessageFormat.format(RB.getStringResource("SoftwareDependencyTab.Error.GetRelatedObjects.fmt.txt"), logicalObject.getName()), (Throwable)e);
            }
        }
    }

    private void createDependencyTree(List dependentObjects, int dependencyType) {
        if (dependentObjects.size() > 0) {
            boolean showHandle = true;
            if (dependentObjects.size() == 1) {
                showHandle = false;
            }
            if (dependencyType == 0) {
                this._treeDep.setShowsRootHandles(showHandle);
            } else {
                this._treeUses.setShowsRootHandles(showHandle);
            }
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            try {
                this.addDependentObjectsToTree(dependentObjects, root, dependencyType);
            }
            catch (Exception e) {
                this.setTreeModel(EMPTY_MODEL, dependencyType);
                return;
            }
            if (root.getChildCount() > 0) {
                this.setTreeModel(new DefaultTreeModel(root), dependencyType);
            } else {
                this.setTreeModel(EMPTY_MODEL, dependencyType);
            }
        } else {
            this.setTreeModel(EMPTY_MODEL, dependencyType);
        }
        this.displayTree();
    }

    private void displayTree() {
        this._mainPanel.setVisible(true);
        this.validate();
        this.repaint();
    }

    protected void displayLabel(JScrollPane panel, JScrollPane label) {
        panel.setVisible(false);
        label.setVisible(true);
        this.validate();
        this.repaint();
    }

    private void setTreeModel(DefaultTreeModel model, int dependencyType) {
        if (dependencyType == 0) {
            this._treeDep.setModel(model);
            if (model == EMPTY_MODEL) {
                this.displayLabel(this._depPane, this._noDepPane);
            }
        } else {
            this._treeUses.setModel(model);
            if (model == EMPTY_MODEL) {
                this.displayLabel(this._usesPane, this._noUsesPane);
            }
        }
    }

    class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        TreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            SimpleLogicalObject lo;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (lo = (SimpleLogicalObject)((DefaultMutableTreeNode)value).getUserObject()) != null) {
                TypeInterface type = lo.getTypeInterface();
                if (type != null) {
                    this.setIcon(type.getIcon(1));
                }
                this.setText(lo.getName());
            }
            return this;
        }
    }
}

