/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.common;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ResourceTemplateUtil {
    public static final String SERVERCLASSIDENTIFIER = "ServerClassIdentifier";
    public static final String EXTENSION_ASSOC = "Extensions";
    public static final String PROTOTYPE_PROPERTIES_ASSOC = "PrototypeProperties";
    public static final String PROTOTYPE_LOCALE_EXTENSION = "Locale";
    public static final String CLASS_IDENTIFIER = "ClassIdentifier";
    public static final String ENGINE = "Engine";
    public static final String SERVER_TYPE = "Server";
    public static final String LIBRARY_TYPE = "Library";
    public static final String SCHEMA_TYPE = "Schema";

    public static Map getDisplayNameForClassIdentifiers(MdFactory factory, String reposID, String objectType, List classIdentifierList) {
        HashMap<String, String> ClassIdMap = new HashMap<String, String>(4);
        try {
            MdObjectStore store = factory.createObjectStore();
            for (int i = 0; i < classIdentifierList.size(); ++i) {
                String classID = (String)classIdentifierList.get(i);
                Prototype prototype = null;
                try {
                    prototype = ResourceTemplateUtil.getPrototypeByIdentifier(factory, objectType, classID, reposID, Locale.getDefault(), (MdStore)store, 8192);
                }
                catch (MdException mdException) {
                    // empty catch block
                }
                if (prototype != null) {
                    ClassIdMap.put(classID, PrototypeUtil.getDisplayString((String)prototype.getName(), (Prototype)prototype));
                    continue;
                }
                ClassIdMap.put(classID, "");
            }
            store.dispose();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return ClassIdMap;
    }

    public static Prototype getPrototypeByIdentifier(MdFactory factory, String metadataType, String key, String strReposId, Locale locale, MdStore store, int flags) throws MdException, RemoteException {
        String strAssociation;
        String strAttribute;
        String strMetaType;
        Prototype prototype = null;
        String simpleMetadataType = metadataType;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String strNameAttribute = "Name";
        String strValueAttribute = "Value";
        if (simpleMetadataType == SERVER_TYPE) {
            strMetaType = "ServerComponent";
            strAttribute = CLASS_IDENTIFIER;
            strAssociation = PROTOTYPE_PROPERTIES_ASSOC;
            strNameAttribute = "Property" + strNameAttribute;
            strValueAttribute = "Default" + strValueAttribute;
        } else if (simpleMetadataType == LIBRARY_TYPE) {
            strMetaType = "SASLibrary";
            strAttribute = ENGINE;
            strAssociation = PROTOTYPE_PROPERTIES_ASSOC;
            strNameAttribute = "Property" + strNameAttribute;
            strValueAttribute = "Default" + strValueAttribute;
        } else if (simpleMetadataType == SCHEMA_TYPE) {
            strMetaType = "DatabaseSchema";
            strAttribute = SERVERCLASSIDENTIFIER;
            strAssociation = EXTENSION_ASSOC;
        } else {
            return null;
        }
        String strStringentClause = "[@MetadataType='" + strMetaType + "']";
        String strType = "Prototype";
        String strTemplate = "<TEMPLATES><Prototype Id=\"\" Name=\"\" Desc=\"\" MetadataType=\"\" ><Extensions/></Prototype></TEMPLATES>";
        String strSelect = "<XMLSELECT search=\"*" + strStringentClause + "[" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + key + "']]\"/>";
        if (strAssociation == null) {
            strSelect = "<XMLSELECT search=\"@" + strAttribute + "='" + key + "'\"/>";
        }
        String strOptions = strTemplate + strSelect;
        int allFlags = flags | 0x100 | 8 | 4 | 0x80;
        List prototypeList = factory.getOMIUtil().getMetadataObjectsSubset(store, strReposId, strType, allFlags, strOptions, true);
        if (prototypeList.size() > 0) {
            return (Prototype)prototypeList.get(0);
        }
        return prototype;
    }
}

