/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.common;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.AbstractPrompt;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrivateObjectImportUtility {
    public static void updatePromptPaths(ImportOperationInterface operation, List smartObjects) throws RemoteException, ServiceException {
        Log logger = operation.getLogger();
        logger.debug((Object)("PrivateObjectImportUtility updatePromptPaths(), object count = " + smartObjects.size()));
        Pattern p = Pattern.compile("(URL::(.*?)\\Q)\\E)|(SBIP:(.*?)\\Q)\\E)");
        String xml = null;
        for (MetadataInterface mi : smartObjects) {
            if (mi instanceof OMRPromptDefinitionInterface) {
                xml = ((OMRPromptDefinitionInterface)mi).getPromptInfo();
            } else if (mi instanceof OMRPromptGroupInterface) {
                xml = ((OMRPromptGroupInterface)mi).getGroupInfo();
            }
            if (null == xml) continue;
            StringBuffer buf = new StringBuffer(xml);
            String targetReposName = operation.getRepositoryName();
            int end = 0;
            Matcher matcher = p.matcher(buf);
            while (matcher.find(end)) {
                int start = matcher.start();
                end = matcher.end();
                if (start >= buf.length() || end >= buf.length()) continue;
                String oldUrl = buf.substring(start, end);
                logger.debug((Object)(" old url: " + oldUrl));
                oldUrl = PersistHelper.parseSBIPUrl((String)oldUrl);
                logger.debug((Object)(" parsed, stripped old url: " + oldUrl));
                String newUrl = PersistHelper.parseSBIPUrl((String)PromotionUtil.getNewSBIPUrl((String)oldUrl, (String)targetReposName, (List)operation.getAllPromotionItems()));
                logger.debug((Object)(" parsed, stripped new url: " + newUrl));
                if (!oldUrl.equals(newUrl)) {
                    if (start >= buf.length() || end >= buf.length()) continue;
                    newUrl = "URL::" + newUrl;
                    buf.replace(start, end, newUrl);
                    logger.debug((Object)("replaced by new url: " + newUrl));
                    continue;
                }
                List allConnections = operation.getConnectionManager().getConnections(false);
                newUrl = null;
                Iterator iterator = allConnections.iterator();
                while (iterator.hasNext() && newUrl == null) {
                    String targetID;
                    ConnectionPointInterface cnPoint = (ConnectionPointInterface)iterator.next();
                    if (cnPoint.getSourcePath() == null || !cnPoint.getSourcePath().equals(oldUrl) || (targetID = cnPoint.getTargetID()) == null || targetID.length() <= 0) continue;
                    newUrl = PromotionUtil.getObjectPath((ServerInterface)operation.getServer(), (String)targetID, (String)cnPoint.getMetadataType());
                }
                if (newUrl == null || oldUrl.equals(newUrl) || start >= buf.length() || end >= buf.length()) continue;
                newUrl = "URL::" + newUrl;
                buf.replace(start, end, newUrl);
                logger.debug((Object)("replaced by new url: " + newUrl));
            }
            if (xml.equals(buf.toString())) continue;
            if (mi instanceof OMRPromptDefinitionInterface) {
                ((OMRPromptDefinitionInterface)mi).setPromptInfo(buf.toString());
            } else if (mi instanceof OMRPromptGroupInterface) {
                ((OMRPromptGroupInterface)mi).setGroupInfo(buf.toString());
            }
            mi.update();
        }
    }

    public static List getLogicalObjectsUsedByPrompts(PromotionInterface promotionOperation, Root mdObject) throws RemoteException, MdException, ServiceException, LogicalTypeException {
        ArrayList lLogicalObject = new ArrayList();
        AssociationList prompts = mdObject.getPrompts();
        for (AbstractPrompt mdPrompt : prompts) {
            BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)PromotionUtil.getSmartObject((PromotionInterface)promotionOperation, (CMetadata)mdPrompt);
            List sources = prompt.getValueSources();
            List dependentSources = PrivateObjectImportUtility.getDependentLogicalObjects(sources);
            lLogicalObject.addAll(dependentSources);
        }
        return lLogicalObject;
    }

    private static List getDependentLogicalObjects(List inSmartObjects) throws ServiceException, RemoteException, LogicalTypeException {
        ArrayList<SimpleLogicalObjectInterface> returnList = new ArrayList<SimpleLogicalObjectInterface>();
        for (MetadataInterface mi : inSmartObjects) {
            Root jOMAObject = (Root)mi.getRepositoryEntity();
            SimpleLogicalObjectInterface logicalObject = PrivateObjectImportUtility.getLogicalFromJOMAObject(jOMAObject);
            if (logicalObject == null) continue;
            returnList.add(logicalObject);
        }
        return returnList;
    }

    public static boolean updatePromptsForImportChanges(ImportOperationInterface operation, Root table) throws ServiceException, RemoteException {
        boolean bMetadataChanges = false;
        MetadataInterface tableSmartObj = PromotionUtil.getSmartObject((PromotionInterface)operation, (CMetadata)table);
        List promptSmartObjects = tableSmartObj.getPrompts();
        if (promptSmartObjects != null && promptSmartObjects.size() > 0) {
            PrivateObjectImportUtility.updatePromptPaths(operation, promptSmartObjects);
            bMetadataChanges = true;
        }
        return bMetadataChanges;
    }

    public static SimpleLogicalObjectInterface getLogicalFromJOMAObject(Root jOMAObject) throws RemoteException, LogicalTypeException {
        SimpleLogicalObject logicalObject = null;
        TypeInterface type = Factory.getInstance().locateTypeInterfaceForRoot(jOMAObject);
        if (type != null) {
            logicalObject = new SimpleLogicalObject(jOMAObject.getName(), jOMAObject.getId(), type);
        }
        return logicalObject;
    }

    public static final Class[] getPromptConnectionTypes() {
        try {
            return new Class[]{Class.forName("com.sas.metadata.logical.library.LibraryConnectionType"), Class.forName("com.sas.metadata.logical.table.TableConnectionType"), Class.forName("com.sas.metadata.logical.prompts.PromptConnectionType"), Class.forName("com.sas.metadata.logical.prompts.PromptGroupConnectionType"), Class.forName("com.sas.metadata.logical.cube.CubeConnectionType"), Class.forName("com.sas.metadata.logical.informationmap.InformationMapConnectionType")};
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return new Class[0];
        }
    }

    public static final Class[] appendPromptConnectionTypes(Class[] inputArray) {
        ValidateArg.notNull((Object)inputArray, (String)"inputArray");
        Class[] promptArray = PrivateObjectImportUtility.getPromptConnectionTypes();
        int count = inputArray.length + promptArray.length;
        Class[] retArray = new Class[count];
        int start = 0;
        System.arraycopy(inputArray, 0, retArray, start, inputArray.length);
        start = inputArray.length;
        System.arraycopy(promptArray, 0, retArray, start, promptArray.length);
        return retArray;
    }
}

