/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.channel.RB;
import com.sas.metadata.promotion.Log;
import com.sas.services.util.XMLUtil;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.NamespaceMap;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.WebDAVStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebDAVRestore {
    private static SimpleDateFormat df;
    private static int restored;
    private static String sourceVServer;
    private static String davServer;
    private static boolean supportsACL;
    private static boolean supportsVC;
    private static final String XYTHOS_WFS_VERSION_HDR = "Xythos-WFS-Version";
    private static DAVResource r;
    private static String basePath;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static DocumentBuilder documentBuilder;
    private static String _origBasePath;
    private static Log _log;
    private static final String all = "ALL_PRINCIPALS@PUBLIC";
    private static final String authenticated = "AUTHENTICATED@PUBLIC";
    public static final String DAV_ALL_PRIVILEGES = "{DAV:}all";
    public static final String DAV_READ_PRIVILEGE = "{DAV:}read";
    public static final String DAV_WRITE_PRIVILEGE = "{DAV:}write";
    public static final String DAV_OWNER = "{DAV:}owner";
    public static final String DAV_XYTHOS_WRITE_PRIVILEGE = "{http://www.xythos.com/namespaces/StorageServer/acl/}write";
    public static final String DAV_XYTHOS_DELETE_PRIVILEGE = "{http://www.xythos.com/namespaces/StorageServer/acl/}delete";
    public static final String DAV_XYTHOS_PERMISSIONS_PRIVILEGE = "{http://www.xythos.com/namespaces/StorageServer/acl/}permissions";
    public static final String DAV_XYTHOS_INHERIT_READ_PRIVILEGE = "{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-read";
    public static final String DAV_XYTHOS_INHERIT_WRITE_PRIVILEGE = "{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-write";
    public static final String DAV_XYTHOS_INHERIT_DELETE_PRIVILEGE = "{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-delete";
    public static final String DAV_XYTHOS_INHERIT_PERMISSIONS_PRIVILEGE = "{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-permissions";
    private static boolean RUN_DEAD_CODE;

    public WebDAVRestore() {
        if (RUN_DEAD_CODE) {
            new Ace();
        }
    }

    public static void restoreFromZip(String zipFileName, String url, String user, String password, Log log) throws IOException {
        WebDAVRestore.restoreFromZip(new File(zipFileName), url, user, password, log);
    }

    public static void restoreFromZip(File zipFile, String url, String user, String password, Log log) throws IOException {
        _log = log;
        df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS ", Locale.US);
        df.setTimeZone(TimeZone.getDefault());
        URL _url = new URL(url);
        basePath = _url.getPath();
        url = _url.getProtocol() + "://" + _url.getHost() + ":" + (_url.getPort() == -1 ? 80 : _url.getPort()) + _url.getPath();
        try (ZipFile z = new ZipFile(zipFile);){
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ZipEntry ze = z.getEntry("WFSDump.xml");
            Document document = WebDAVRestore.parseXML(z.getInputStream(ze));
            Element root = document.getDocumentElement();
            sourceVServer = root.getAttribute("server");
            ConnectionInfo c = new ConnectionInfo(url, user, password);
            r = new DAVResource(c);
            WebDAVRestore.getServerInformation();
            _log.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("WDR.StartInfo.fmt.txt"), (Object)davServer, (Object)url));
            NodeList resources = root.getElementsByTagName("resource");
            URL utmp = new URL(sourceVServer);
            _origBasePath = utmp.getPath();
            for (int i = 0; i < resources.getLength(); ++i) {
                Element resource = (Element)resources.item(i);
                WebDAVRestore.doResource(resource, z);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        catch (DAVException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        _log.debug((Object)RB.getStringResource("WDR.Restore.txt"));
    }

    private static void getServerInformation() {
        Properties opts = null;
        try {
            opts = r.doOptions();
        }
        catch (DAVException e) {
            _log.warn((Object)RB.getStringResource("WDR.OptionsErr.txt"), (Throwable)e);
        }
        catch (RemoteException e) {
            _log.warn((Object)RB.getStringResource("WDR.OptionsErr.txt"), (Throwable)e);
        }
        if (opts != null) {
            davServer = (String)opts.get("Server");
            if (opts.containsKey(XYTHOS_WFS_VERSION_HDR)) {
                davServer = (String)opts.get(XYTHOS_WFS_VERSION_HDR);
            }
            String[] caps = r.getDavCapabilities();
            for (int i = 0; i < caps.length; ++i) {
                if ("access-control".equalsIgnoreCase(caps[i])) {
                    supportsACL = true;
                }
                if (!"version-control".equalsIgnoreCase(caps[i])) continue;
                supportsVC = true;
            }
        }
    }

    private static Element getElementByTagName(Element element, String name) {
        NodeList nl = element.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private static void doResource(Element resource, ZipFile z) throws DAVException, IOException, RemoteException {
        boolean err = false;
        String name = resource.getAttribute("name");
        int idx = name.indexOf(_origBasePath);
        if (idx >= 0) {
            name = name.substring(idx + _origBasePath.length(), name.length());
        }
        name = basePath + name;
        Element contentElement = WebDAVRestore.getElementByTagName(resource, "content");
        boolean isDirectory = contentElement == null;
        r.setPath(name);
        if (isDirectory) {
            int sc = 0;
            try {
                r.makeCollection();
                sc = r.getStatusCode();
            }
            catch (DAVException e) {
                sc = e.getStatusCode();
            }
            if (sc != 201 && sc != 405) {
                _log.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("WDR.DirCreate.fmt.txt"), (Object)name, (Object)Integer.toString(sc), (Object)WebDAVStatus.getStatusText((int)sc)));
                err = true;
            }
        } else {
            String contentsFile = contentElement.getFirstChild().getNodeValue();
            InputStream contents = z.getInputStream(new ZipEntry(contentsFile));
            String mimeType = contentElement.getAttribute("mimetype");
            if (mimeType != null) {
                r.setContentType(mimeType);
            }
            r.setContents(contents);
            int sc = r.getStatusCode();
            if (sc != 201 && sc != 204) {
                _log.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("WDR.SetContent.fmt.txt"), (Object)name, (Object)Integer.toString(sc), (Object)WebDAVStatus.getStatusText((int)sc)));
                err = true;
            }
        }
        Element propertiesElement = WebDAVRestore.getElementByTagName(resource, "properties");
        Element permissionsElement = WebDAVRestore.getElementByTagName(resource, "permissions");
        if (propertiesElement != null) {
            WebDAVRestore.doProperties(propertiesElement, r);
        }
        if (permissionsElement != null && supportsACL) {
            WebDAVRestore.doPermissions(permissionsElement, r);
        }
        if (!err) {
            _log.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("WDR.Restored.fmt.txt"), (Object)name));
            ++restored;
        } else {
            _log.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("WDR.RestoredErr.fmt.txt"), (Object)name));
        }
    }

    private static void doPermissions(Element element, DAVResource r) throws RemoteException, DAVException {
        NamespaceMap nsMap = new NamespaceMap();
        String PREFIX = "d:";
        PropertyName[] pNames = new PropertyName[]{new PropertyName("{DAV:}acl"), new PropertyName("{DAV:}principal-collection-set"), new PropertyName("{DAV:}supported-privilege-set")};
        DavPropertyResult davPropertyResult = r.getDavProperties(pNames);
        List davPropertyItems = davPropertyResult.getDavProperties();
        if (davPropertyItems.isEmpty()) {
            return;
        }
        DavPropertyItem davPropertyItem = (DavPropertyItem)davPropertyItems.get(0);
        DavProperty davProperty = davPropertyItem.getDavProperty();
        Object davPropertyValue = davProperty.getValue();
        if (!(davPropertyValue instanceof Element)) {
            return;
        }
        Element ele = davProperty.toXml(documentBuilder.newDocument());
        Document doc = documentBuilder.newDocument();
        doc.appendChild(doc.importNode(ele, true));
        Element aclE = doc.getDocumentElement();
        WebDAVRestore.removeProtectedInheritedAces(aclE);
        String privilege = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element permission = (Element)node;
            String principal = permission.getAttribute("principal");
            if (!permission.hasChildNodes()) {
                return;
            }
            String privileges = permission.getFirstChild().getNodeValue();
            Element principalE = doc.createElementNS("DAV:", "d:principal");
            Element identityE = null;
            if (all.equals(principal)) {
                identityE = doc.createElementNS("DAV:", "d:all");
            } else if (authenticated.equals(principal)) {
                identityE = doc.createElementNS("DAV:", "d:authenticated");
            } else {
                identityE = doc.createElementNS("DAV:", "d:href");
                identityE.appendChild(doc.createTextNode(principal));
            }
            principalE.appendChild(identityE);
            Element privilegeE = null;
            Element privE = null;
            Element grantdenyE = doc.createElementNS("DAV:", "d:grant");
            StringTokenizer st = new StringTokenizer(privileges);
            while (st.hasMoreTokens()) {
                int ptr1;
                String _privilege = st.nextToken();
                if ("READ".equals(_privilege)) {
                    privilege = DAV_READ_PRIVILEGE;
                } else if ("WRITE".equals(_privilege)) {
                    privilege = DAV_XYTHOS_WRITE_PRIVILEGE;
                } else if ("DELETE".equals(_privilege)) {
                    privilege = DAV_XYTHOS_DELETE_PRIVILEGE;
                } else if ("PERMISSIONS".equals(_privilege)) {
                    privilege = DAV_XYTHOS_PERMISSIONS_PRIVILEGE;
                } else if ("IREAD".equals(_privilege)) {
                    privilege = DAV_XYTHOS_INHERIT_READ_PRIVILEGE;
                } else if ("IWRITE".equals(_privilege)) {
                    privilege = DAV_XYTHOS_INHERIT_WRITE_PRIVILEGE;
                } else if ("IDELETE".equals(_privilege)) {
                    privilege = DAV_XYTHOS_INHERIT_DELETE_PRIVILEGE;
                } else if ("IPERMISSIONS".equals(_privilege)) {
                    privilege = DAV_XYTHOS_INHERIT_PERMISSIONS_PRIVILEGE;
                }
                int ptr2 = privilege.indexOf(125);
                if (ptr2 > 0 && (ptr1 = privilege.indexOf(123)) < ptr2) {
                    String ns = privilege.substring(ptr1 + 1, ptr2);
                    String nsprefix = nsMap.getPrefixforURI(ns);
                    String priv = privilege.substring(ptr2 + 1);
                    privE = doc.createElementNS(ns, nsprefix + ':' + priv);
                }
                if (privE == null) continue;
                privilegeE = doc.createElementNS("DAV:", "d:privilege");
                privilegeE.appendChild(privE);
                grantdenyE.appendChild(privilegeE);
            }
            Element aceE = doc.createElementNS("DAV:", "d:ace");
            aceE.appendChild(principalE);
            if (grantdenyE != null) {
                aceE.appendChild(grantdenyE);
            }
            aclE.appendChild(aceE);
        }
        for (Map.Entry pfmap : nsMap.entrySet()) {
            aclE.setAttribute("xmlns:" + pfmap.getValue(), (String)pfmap.getKey());
        }
        if (aclE.hasChildNodes()) {
            String s = XMLUtil.node2String((Node)doc);
            r.setACL(s);
        }
    }

    private static void removeProtectedInheritedAces(Element aclE) {
        int aceNo = 0;
        Node n = null;
        Element ace = null;
        NodeList nl = null;
        NodeList acelist = aclE.getChildNodes();
        for (int i = 0; i < acelist.getLength(); ++i) {
            boolean isinherited;
            n = acelist.item(i);
            if (!(n instanceof Element) || !"ace".equals((ace = (Element)n).getLocalName())) continue;
            ++aceNo;
            nl = ace.getElementsByTagNameNS("DAV:", "grant");
            nl = ace.getElementsByTagNameNS("DAV:", "protected");
            boolean isprotected = nl.getLength() > 0;
            nl = ace.getElementsByTagNameNS("DAV:", "inherited");
            boolean bl = isinherited = nl.getLength() > 0;
            if (!isprotected && !isinherited) continue;
            aclE.removeChild(ace);
        }
    }

    private static void doProperties(Element element, DAVResource r) throws DAVException, RemoteException {
        NodeList nodes = element.getChildNodes();
        ArrayList<PropertyName> propNames = new ArrayList<PropertyName>();
        ArrayList<String> propValues = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element property = (Element)node;
            String prop = property.getFirstChild().getNodeValue();
            int p3 = prop.indexOf("=");
            String nsname = prop.substring(0, p3);
            String value = property.getFirstChild() != property.getLastChild() ? property.getLastChild().getNodeValue() : prop.substring(p3 + 1);
            propNames.add(new PropertyName(nsname));
            propValues.add(value);
        }
        r.setProperties(propNames.toArray(new PropertyName[0]), propValues.toArray(new String[0]));
        int sc = r.getStatusCode();
        if (sc != 207) {
            _log.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("WDR.SetProperties.fmt.txt"), (Object)Integer.toString(sc), (Object)WebDAVStatus.getStatusText((int)sc)));
        }
    }

    private static Document parseXML(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(is);
        return document;
    }

    static {
        restored = 0;
        supportsACL = false;
        supportsVC = false;
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        _origBasePath = null;
        _log = null;
        RUN_DEAD_CODE = false;
    }

    private class Ace {
        private boolean readable = false;
        private boolean writeable = false;
        private boolean deleteable = false;
        private boolean permissionable = false;
        private boolean inheritReadable = false;
        private boolean inheritWriteable = false;
        private boolean inheritDeleteable = false;
        private boolean inheritPermissionable = false;

        private Ace() {
        }

        public boolean getReadable() {
            return this.readable;
        }

        public void setReadable(boolean readable) {
            this.readable = readable;
        }

        public boolean getWriteable() {
            return this.writeable;
        }

        public void setWriteable(boolean writeable) {
            this.writeable = writeable;
        }

        public boolean getDeleteable() {
            return this.deleteable;
        }

        public boolean getPermissionable() {
            return this.permissionable;
        }

        public void setPermissionable(boolean permissionable) {
            this.permissionable = permissionable;
        }

        public boolean getInheritReadable() {
            return this.inheritReadable;
        }

        public void setInheritReadable(boolean inheritReadable) {
            this.inheritReadable = inheritReadable;
        }

        public boolean getInheritWriteable() {
            return this.inheritWriteable;
        }

        public void setInheritWriteable(boolean inheritWriteable) {
            this.inheritWriteable = inheritWriteable;
        }

        public boolean getInheritDeleteable() {
            return this.inheritDeleteable;
        }

        public boolean getInheritPermissionable() {
            return this.inheritPermissionable;
        }

        public void setInheritPermissionable(boolean inheritPermissionable) {
            this.inheritPermissionable = inheritPermissionable;
        }
    }
}

