/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.metadata.logical.channel.ResourceFilter;
import com.sas.metadata.logical.channel.ResourceFinder;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class WebDAVDump {
    private static SimpleDateFormat df;
    private static DecimalFormat fnfmt;
    private static BufferedWriter out;
    private static int fileNum;
    private static String dirName;
    private static int dumped;
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static DAVResource davResource;
    private static int _numPkgs;

    public static int getPackages() {
        return _numPkgs;
    }

    public static void resetPackages() {
        _numPkgs = 0;
    }

    public static void dumpPackageContentToZip(File zipFile, String url, String user, String password) throws IOException, DAVException {
        File xmlFile = null;
        ZipOutputStream zos = null;
        fnfmt = new DecimalFormat("X0000000");
        df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS ", Locale.US);
        df.setTimeZone(TimeZone.getDefault());
        davResource = new DAVResource(url, user, password);
        ResourceFilter packageFilter = new ResourceFilter(){

            @Override
            public boolean accept(Map pMap) {
                boolean acceptIt = false;
                String type = (String)pMap.get("{http://www.sas.com/rnd/itech/WebDAV}type");
                if (type != null) {
                    if (type.equals("package")) {
                        _numPkgs++;
                        acceptIt = true;
                    } else if (type.equals("binarypackage") || type.equals("htmlset") || type.equals("binfile") || type.equals("html") || type.equals("referen") || type.equals("txtfile") || type.equals("viewer") || type.equals("catalog") || type.equals("dataset") || type.equals("fdb") || type.equals("mddb") || type.equals("nested") || type.equals("view")) {
                        acceptIt = true;
                    }
                }
                return acceptIt;
            }

            @Override
            public List getPropertyList() {
                ArrayList results = new ArrayList();
                return results;
            }
        };
        FileInputStream fis = null;
        try {
            int len;
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            URL theURL = new URL(url);
            url = theURL.getProtocol() + "://" + theURL.getHost() + ":" + (theURL.getPort() == -1 ? 80 : theURL.getPort()) + theURL.getPath();
            xmlFile = File.createTempFile("Pub", ".xml");
            xmlFile.deleteOnExit();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8"));
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.newLine();
            out.write("<resources server=\"" + url + "\">");
            out.newLine();
            ArrayList<Map<String, Map<String, String>>> results = new ArrayList<Map<String, Map<String, String>>>();
            ResourceFinder.getResources(davResource, packageFilter, results, false);
            davResource.setPath(theURL.getPath());
            WebDAVDump.dump(davResource, results, zos);
            out.write("</resources>");
            out.newLine();
            out.close();
            ZipEntry ze = new ZipEntry("WFSDump.xml");
            zos.putNextEntry(ze);
            fis = new FileInputStream(xmlFile);
            byte[] buf = new byte[4096];
            while ((len = fis.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
        }
        catch (DAVException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (xmlFile != null) {
                try {
                    xmlFile.delete();
                }
                catch (Exception exception) {}
            }
            if (zos != null) {
                try {
                    zos.flush();
                }
                catch (IOException iOException) {}
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void dump(DAVResource davResource, List resources, ZipOutputStream zos) throws DAVException, IOException {
        for (Map item : resources) {
            Object[] keys = item.keySet().toArray();
            String path = (String)keys[0];
            davResource.setPath(path);
            Map propMap = (Map)item.get(path);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            out.write("<resource name=\"" + WebDAVDump.XMLESCAPE(path) + "\">");
            out.newLine();
            if (!WebDAVDump.isCollection(propMap)) {
                String tempName = fnfmt.format(fileNum);
                if (zos == null) {
                    File file = new File(dirName + File.separator + tempName);
                    davResource.setPath(path);
                    davResource.getContents(file);
                } else {
                    int len;
                    InputStream is = davResource.getContentsInputStream();
                    ZipEntry ze = new ZipEntry(tempName);
                    zos.putNextEntry(ze);
                    byte[] buf = new byte[4096];
                    while ((len = is.read(buf)) > 0) {
                        zos.write(buf, 0, len);
                    }
                }
                String contentType = (String)propMap.get("{DAV:}getcontenttype");
                if (contentType != null) {
                    out.write("<content mimetype=\"" + contentType + "\">" + tempName + "</content>");
                } else {
                    out.write("<content>" + tempName + "</content>");
                }
                out.newLine();
                ++fileNum;
            }
            Iterator props = propMap.entrySet().iterator();
            int propNum = 0;
            boolean foundCustomProperty = false;
            while (props.hasNext()) {
                Map.Entry me2 = props.next();
                String propName = (String)me2.getKey();
                String propValue = (String)me2.getValue();
                if (!WebDAVDump.isCustomProperty(propName)) continue;
                if (propNum == 0) {
                    foundCustomProperty = true;
                    out.write("<properties>");
                    out.newLine();
                }
                out.write("<property>");
                out.write(propName + "=" + WebDAVDump.XMLESCAPE(propValue));
                out.write("</property>");
                out.newLine();
                ++propNum;
            }
            if (foundCustomProperty) {
                out.write("</properties>");
                out.newLine();
            }
            out.write("</resource>");
            out.newLine();
            ++dumped;
        }
    }

    private static boolean isCollection(Map propMap) {
        return "COLLECTION".equals(propMap.get("{DAV:}resourcetype"));
    }

    private static String XMLESCAPE(String text) {
        if (text == null) {
            return "";
        }
        if (text.startsWith(CDATA_START) && text.endsWith(CDATA_END)) {
            return text;
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        return text;
    }

    private static boolean isCustomProperty(String propName) {
        return !propName.startsWith("{DAV:}");
    }

    static {
        out = null;
        fileNum = 0;
        dirName = null;
        dumped = 0;
        _numPkgs = 0;
    }
}

