/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.channel.ChannelExportItem;
import com.sas.metadata.logical.channel.ChannelImportItem;
import com.sas.metadata.logical.channel.RB;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class ChannelPromotionOptionsPanel
extends JPanel {
    private TriStateCheckBox _ckbContent;
    private boolean _isExport;
    private boolean _dataChanged;
    private SimpleLogicalObjectInterface[] m_aItems;

    public ChannelPromotionOptionsPanel(int iPromotionType) {
        this._isExport = iPromotionType != 1;
        this._ckbContent = new TriStateCheckBox(RB.getStringResource("CPOP.ckbContent.txt"));
        this._ckbContent.setMnemonic(Util.getDisplayedMnemonic((String)RB.getStringResource("CPOP.ckbContent.txt")));
        this._ckbContent.setToolTipText(RB.getStringResource("CPOP.ckbContent.ToolTip.txt"));
        this._ckbContent.setCycleEnabled(false);
        this._ckbContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelPromotionOptionsPanel.this._dataChanged = true;
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this._ckbContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateExportOptions(ExportItemInterface[] aItems) {
        this.m_aItems = aItems;
        this._ckbContent.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
    }

    public void populateImportOptions(ImportItemInterface[] aItems, PromotionPropertiesFile propertiesFile) {
        this.m_aItems = aItems;
        boolean bNoContent = false;
        for (int i = 0; i < aItems.length; ++i) {
            String exclude = propertiesFile.getProperty(aItems[i].getID() + "_ExcludeContent");
            if (exclude == null || !"true".equals(exclude)) continue;
            ((ChannelImportItem)aItems[i]).setIncludeContent(false);
            bNoContent = true;
            break;
        }
        if (bNoContent) {
            this._ckbContent.setSelectedValue(0);
            this._ckbContent.setEnabled(false);
            return;
        }
        this._ckbContent.setEnabled(true);
        this._ckbContent.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
    }

    public void saveSettings() {
        if (!this._dataChanged) {
            return;
        }
        for (int i = 0; i < this.m_aItems.length; ++i) {
            if (this._isExport) {
                ((ChannelExportItem)this.m_aItems[i]).setIncludeContent(this._ckbContent.isSelected());
                continue;
            }
            ((ChannelImportItem)this.m_aItems[i]).setIncludeContent(this._ckbContent.isSelected());
        }
        this._dataChanged = false;
    }

    private int determineCheckBoxState(SimpleLogicalObjectInterface[] aItems) {
        boolean bAllOn = true;
        boolean bAllOff = true;
        for (int i = 0; i < this.m_aItems.length; ++i) {
            boolean bOn = true;
            bOn = this._isExport ? ((ChannelExportItem)this.m_aItems[i]).getIncludeContent() : ((ChannelImportItem)this.m_aItems[i]).getIncludeContent();
            bAllOn &= bOn;
            bAllOff &= !bOn;
        }
        if (bAllOn) {
            return 2;
        }
        if (bAllOff) {
            return 0;
        }
        return 1;
    }
}

