/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.channel.ChannelExportItem;
import com.sas.metadata.logical.channel.ChannelImportListener;
import com.sas.metadata.logical.channel.ChannelPromotionOptionsPanel;
import com.sas.metadata.logical.channel.ChannelUtil;
import com.sas.metadata.logical.channel.RB;
import com.sas.metadata.logical.channel.WebDAVDump;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.LogonView;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

class ChannelExportListener
extends AbstractExportListener
implements PromotionOptionsInterface {
    private ChannelPromotionOptionsPanel _optionsPanel;
    private Map davCreds = new HashMap();

    public ChannelExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return ChannelImportListener.CONNECTION_TYPES;
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException {
        int retVal = 0;
        if (operation.getPromotionType() == 2) {
            return 0;
        }
        this.davCreds.clear();
        try {
            PromotionPropertiesFile propertiesFile = operation.getPropertiesFile();
            for (ExportItemInterface exportItem : objects) {
                if (!((ChannelExportItem)exportItem).getIncludeContent()) {
                    propertiesFile.addProperty(exportItem.getID() + "_ExcludeContent", "true");
                    continue;
                }
                ChannelInterface channel = (ChannelInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)exportItem.getID(), (String)exportItem.getTypeInterface().getMetadataType());
                int deliveryTransport = channel.getDeliveryTransport();
                int val = 0;
                if (deliveryTransport == 2) {
                    val = this.exportArchives(operation, channel);
                } else if (deliveryTransport == 3) {
                    val = this.exportFromDAV(operation, channel);
                }
                if (retVal != 0) continue;
                retVal = val;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        return retVal;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new ChannelExportItem(name, id, type);
    }

    private int exportArchives(ExportOperationInterface operation, ChannelInterface channel) {
        LogicalServerInterface logicalServer;
        Log exportLogger;
        ContentHandlerInterface contentHandler;
        int retVal;
        block6: {
            retVal = 0;
            String channelName = null;
            contentHandler = operation.getContentHandler();
            exportLogger = operation.getLogger();
            ContentDestination cd = null;
            logicalServer = null;
            try {
                channelName = channel.getName();
                if (!channel.packageList().iterator().hasNext()) {
                    return retVal;
                }
                cd = channel.getArchivePath();
                if (cd.getServer() != null) break block6;
                List servers = cd.getDirectory().getServers();
                for (ServerInterface server : servers) {
                    for (String type : server.getServiceTypes()) {
                        if (!type.equals("Logical IOM Server")) continue;
                        logicalServer = (LogicalServerInterface)server;
                        break;
                    }
                    if (logicalServer == null) continue;
                    break;
                }
            }
            catch (ServiceException e) {
                exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
                return 4;
            }
            catch (RemoteException e) {
                exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
                return 4;
            }
        }
        retVal = logicalServer != null ? this.exportArchivesWithAppServer(operation, channel, logicalServer, exportLogger) : this.exportArchivesUsingSmartObjects(contentHandler, channel, exportLogger);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exportFromDAV(ExportOperationInterface operation, ChannelInterface channel) {
        int retVal = 0;
        String user = null;
        String password = null;
        String channelName = null;
        String channelID = null;
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        Log exportLogger = operation.getLogger();
        ContentDestination cd = null;
        try {
            channelID = channel.getReposId();
            channelName = channel.getName();
            cd = channel.getContentDestination();
            if (cd == null) {
                return retVal;
            }
        }
        catch (ServiceException e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 4;
        }
        catch (RemoteException e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 4;
        }
        String serverName = "";
        try {
            ServerInterface server = cd.getServer();
            serverName = server.getName();
            UserContextInterface userContext = operation.getUserContext();
            String authType = ((HttpServerInterface)server).getAuthenticationType();
            if (authType != null) {
                UserIdentityInterface identity;
                if (authType.equalsIgnoreCase("metadata")) {
                    if (userContext != null) {
                        identity = userContext.getAuthServer().generatePassword(null);
                        if (identity != null) {
                            user = (String)identity.getPrincipal();
                            password = (String)identity.getCredential();
                        } else {
                            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.MetaAuthNoIdent.fmt.txt"), (Object)cd.getServer().getName()));
                        }
                    } else {
                        exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.MetaAuthNoUser.fmt.txt"), (Object)cd.getServer().getName()));
                    }
                } else if (!authType.equalsIgnoreCase("none")) {
                    identity = ChannelUtil.getCreds(userContext, cd.getServer());
                    if (identity != null) {
                        user = (String)identity.getPrincipal();
                        password = (String)identity.getCredential();
                    } else {
                        String[] creds = null;
                        List sl = server.getDomains();
                        String domain = null;
                        if (sl.size() > 0) {
                            domain = (String)sl.get(0);
                            creds = (String[])this.davCreds.get(domain);
                        }
                        if (creds == null) {
                            if (operation.isBatchProcess()) {
                                exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)serverName));
                            } else {
                                String loginTitle = UtilMisc.getMessage((String)RB.getStringResource("CEL.PromptForServer.fmt.txt"), (Object)cd.getServer().getName());
                                WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), loginTitle, true);
                                LogonView panel = new LogonView();
                                dialog.setMainPanel((WAPanel)panel);
                                dialog.show();
                                if (dialog.getReturnValue() == 1) {
                                    user = panel.getUserName();
                                    password = panel.getPassword();
                                    creds = new String[]{user, password};
                                    this.davCreds.put(domain, creds);
                                } else {
                                    exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)serverName));
                                }
                            }
                        } else {
                            user = creds[0];
                            password = creds[1];
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)serverName));
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("ChannelExport", ".zip");
            tempFile.deleteOnExit();
            URL u = PackageUtil.getServerURL((ContentDestination)cd);
            WebDAVDump.resetPackages();
            WebDAVDump.dumpPackageContentToZip(tempFile, u.toExternalForm(), user, password);
            contentHandler.addBinaryContent(channelID, tempFile.getName(), (InputStream)new FileInputStream(tempFile));
            exportLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.ContentItemCount.fmt.txt"), (Object)Integer.toString(WebDAVDump.getPackages()), (Object)channelName));
        }
        catch (Exception e) {
            retVal = 4;
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            int n = 4;
            return n;
        }
        finally {
            Boolean status;
            if (tempFile != null && tempFile.exists() && !(status = Boolean.valueOf(tempFile.delete())).booleanValue()) {
                exportLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.tempfile.exist.fmt"), (Object)tempFile.getName(), (Object)tempFile.getAbsolutePath()));
            }
        }
        return retVal;
    }

    private int exportArchivesUsingSmartObjects(ContentHandlerInterface contentHandler, ChannelInterface channel, Log exportLogger) {
        int retVal = 0;
        int numItems = 0;
        String channelID = null;
        String channelName = null;
        Iterator pkgItor = null;
        try {
            channelName = channel.getName();
            channelID = channel.getReposId();
            pkgItor = channel.packageList().iterator();
        }
        catch (ServiceException e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 4;
        }
        catch (RemoteException e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 4;
        }
        String pkgName = null;
        while (pkgItor.hasNext()) {
            PackageInterface pkg = null;
            try {
                pkg = (PackageInterface)pkgItor.next();
                pkgName = pkg.getName();
                ResultPackageInterface rpkg = (ResultPackageInterface)pkg.newServiceObject();
                contentHandler.addBinaryContent(channelID, pkg.getName(), rpkg.getInputStream());
                ++numItems;
            }
            catch (Exception e) {
                retVal = 4;
                exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddPkgContentErr.fmt.txt"), (Object)pkgName, (Object)channelName), (Throwable)e);
            }
        }
        exportLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.ContentItemCount.fmt.txt"), (Object)Integer.toString(numItems), (Object)channelName));
        return retVal;
    }

    private int exportArchivesWithAppServer(ExportOperationInterface operation, ChannelInterface channel, LogicalServerInterface logicalServer, Log exportLogger) {
        Iterator pkgItor;
        String channelID;
        int retVal = 0;
        ContentDestination cd = null;
        List usedBy = null;
        String channelName = null;
        WsAppServer wsAppServer = null;
        try {
            cd = channel.getArchivePath();
            usedBy = logicalServer.getServed();
            channelName = channel.getName();
            channelID = channel.getReposId();
            pkgItor = channel.packageList().iterator();
            if (usedBy.size() == 0) {
                exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentNoServerErr.fmt.txt"), (Object)channelName));
                return 4;
            }
            ServerContextInterface serverContext = (ServerContextInterface)usedBy.get(0);
            wsAppServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)((ServerContext)serverContext.getRepositoryEntity()));
        }
        catch (ServiceException e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 4;
        }
        catch (RemoteException e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 4;
        }
        catch (WsAppServerFailException e) {
            exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 4;
        }
        int numItems = 0;
        if (usedBy.size() > 0) {
            String outputPath = cd.getPath();
            if (wsAppServer != null) {
                ContentHandlerInterface contentHandler = operation.getContentHandler();
                IFileService fileService = wsAppServer.getWorkspace().FileService();
                StringHolder stringHolder = new StringHolder();
                String requestedName = "";
                String accessMethod = "";
                String externalFile = null;
                String hostOptions = "";
                while (pkgItor.hasNext()) {
                    IFileref fileref = null;
                    String pkgName = null;
                    PackageInterface pkg = null;
                    IBinaryStream bs = null;
                    InputStream is = null;
                    try {
                        pkg = (PackageInterface)pkgItor.next();
                        pkgName = pkg.getName();
                        externalFile = outputPath != null ? fileService.FullName(pkgName + ".spk", outputPath) : pkgName + ".spk";
                        fileref = fileService.AssignFileref(requestedName, accessMethod, externalFile, hostOptions, stringHolder);
                        StreamOpenMode mode = StreamOpenMode.StreamOpenModeForReading;
                        bs = fileref.OpenBinaryStream(mode);
                        is = contentHandler.getInputStream(bs);
                        contentHandler.addBinaryContent(channelID, pkg.getName(), is);
                        ++numItems;
                        fileService.DeassignFileref(stringHolder.value);
                        fileref = null;
                    }
                    catch (Exception e) {
                        retVal = 4;
                        exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.AddPkgContentErr.fmt.txt"), (Object)pkgName, (Object)channelName), (Throwable)e);
                    }
                }
            }
        }
        exportLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.ContentItemCount.fmt.txt"), (Object)Integer.toString(numItems), (Object)channelName));
        if (wsAppServer != null) {
            wsAppServer.dispose();
        }
        return retVal;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface exportHandler) {
        if (this._optionsPanel == null) {
            this._optionsPanel = new ChannelPromotionOptionsPanel(exportHandler.getPromotionType());
        }
        this._optionsPanel.populateExportOptions(items);
        return this._optionsPanel;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface importHandler) {
        return null;
    }

    public void saveSettings() {
        this._optionsPanel.saveSettings();
    }

    public int analyzeConnections(ExportOperationInterface operation, List exportItems) throws MdException, RemoteException {
        int retVal = 0;
        for (ExportItemInterface exportItem : exportItems) {
            ConnectionManagerInterface connMgr = operation.getConnectionManager();
            block3: for (ConnectionPointInterface cp : new ArrayList(exportItem.getConnectionPoints())) {
                if (!cp.getMetadataType().equals("Directory")) continue;
                String classId = PromotionUtil.getValue((String)cp.getSourceSearchString(), (String)"DeployedComponents/*[@ClassIdentifier");
                String serverName = PromotionUtil.getValue((String)cp.getSourceSearchString(), (String)"DeployedComponents/*[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06' and @Name");
                try {
                    DirectoryInterface dir = (DirectoryInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)cp.getSourceID(), (String)cp.getMetadataType());
                    for (ServerInterface server : dir.getServers()) {
                        if (!server.getClassIdentifier().equals(classId) || !server.getName().equals(serverName)) continue;
                        ChannelInterface channel = (ChannelInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)exportItem.getID(), (String)exportItem.getTypeInterface().getMetadataType());
                        ConnectionPointInterface newCp = connMgr.createConnection("ServerComponent", server.getReposId(), server.getName());
                        newCp.addAssociatedObject((PromotionItemInterface)exportItem);
                        StringBuffer b = new StringBuffer();
                        b.append("*[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06' and @Name='");
                        b.append(server.getName());
                        b.append("']");
                        newCp.addSourceSearch(b.toString());
                        if (channel.getDeliveryTransport() != 3) continue block3;
                        cp.addUserDefinedProperty("DAV_REQUIRED", "1");
                    }
                }
                catch (Exception ex) {
                    retVal = 8;
                    Log exportLogger = operation.getLogger();
                    exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("CEL.UpdateConnErr.fmt.txt"), (Object)exportItem.getName(), (Object)ex.getMessage()));
                }
            }
        }
        return retVal;
    }
}

