/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeFactory;
import com.sas.entities.AttributeTypeFactoryInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.EntityDate;
import com.sas.entities.EntityRB;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

@SASScope
public class AttributeTypeUtility {
    public static String COLOR_NAME = "Color";
    public static String DATE_NAME = "Date";
    public static String FILE_NAME = "File Name";
    protected static Map typeInfo;
    protected static Map classInfo;
    public static int NO_SQL_TYPE_DEFINED;
    protected static final String COLOR_IDENTIFIER_0X = "0X";
    protected static final String COLOR_IDENTIFIER_CX = "CX";
    public static String JAVA_LANG_STRING;
    protected static String JAVA_LANG_INTEGER;
    protected static String JAVA_LANG_FLOAT;
    protected static String JAVA_LANG_LONG;
    protected static String JAVA_LANG_DOUBLE;
    protected static String JAVA_LANG_CHARACTER;
    protected static String JAVA_LANG_SHORT;
    protected static String JAVA_LANG_BOOLEAN;
    protected static String JAVA_LANG_BYTE;
    private static String EMPTY_STRING;
    public static String JAVA_AWT_COLOR;
    private static String JAVA_SQL_TIME;
    private static String JAVA_SQL_TIMESTAMP;
    private static String JAVA_SQL_DATE;
    private static String JAVA_UTIL_DATE;
    protected static final char PARM_SEPARATOR = '\u001f';
    private static List missingValuesStrings;
    private static Set wrapperTypes;

    protected static void initJavaTypeToSQLTypeInfo() {
    }

    protected static void initSQLToJavaClassInfo() {
    }

    public static int getSQLDataType(String javaType) {
        AttributeTypeUtility.initJavaTypeToSQLTypeInfo();
        if (typeInfo.containsKey(javaType)) {
            return (Integer)typeInfo.get(javaType);
        }
        return NO_SQL_TYPE_DEFINED;
    }

    public static Class getJavaClass(int sqlDataType) {
        AttributeTypeUtility.initSQLToJavaClassInfo();
        Integer sqlID = new Integer(sqlDataType);
        if (classInfo.containsKey(sqlID)) {
            return (Class)classInfo.get(sqlID);
        }
        return null;
    }

    public static boolean isArrayPropertyType(String propName) {
        int closingPosition = propName.lastIndexOf("]");
        if (closingPosition == -1) {
            return false;
        }
        int openingPosition = propName.lastIndexOf("[");
        return openingPosition != -1;
    }

    public static String getArrayComponentType(String arrayName) {
        int openPosition = arrayName.indexOf("[");
        if (openPosition == -1) {
            return null;
        }
        return arrayName.substring(0, openPosition);
    }

    public static boolean isNonComplexType(String javaDataType) {
        return javaDataType.equals(JAVA_LANG_STRING) || javaDataType.equals("int") || javaDataType.equals("boolean") || javaDataType.equals("double") || javaDataType.equals("long") || javaDataType.equals("float") || javaDataType.equals("char") || javaDataType.equals("short") || javaDataType.equals("byte") || javaDataType.equals("String");
    }

    public static Class getJavaClassToConstruct(int sqlType, String typeName) {
        if (sqlType == 4) {
            return Integer.class;
        }
        if (sqlType == 6) {
            return Float.class;
        }
        if (sqlType == 8) {
            return Double.class;
        }
        if (sqlType == -5) {
            return Long.class;
        }
        if (sqlType == 5) {
            return Short.class;
        }
        if (sqlType == -6) {
            return Byte.class;
        }
        if (sqlType == 16) {
            return Boolean.class;
        }
        if (sqlType == -1) {
            return String.class;
        }
        if (sqlType == 91) {
            return java.util.Date.class;
        }
        if (sqlType == 12) {
            if (typeName != null) {
                if (typeName.equals(COLOR_NAME)) {
                    return Color.class;
                }
                if (typeName.equals(FILE_NAME)) {
                    return String.class;
                }
                return String.class;
            }
            return String.class;
        }
        return null;
    }

    public static Object createDefaultValue(int sqlType) {
        if (sqlType == 4) {
            return new Integer(0);
        }
        if (sqlType == 6) {
            return new Float(0.0f);
        }
        if (sqlType == -5) {
            return new Long(0L);
        }
        if (sqlType == 8) {
            return new Double(0.0);
        }
        if (sqlType == 5) {
            return new Short("0");
        }
        if (sqlType == 16) {
            return new Boolean("false");
        }
        if (sqlType == -6) {
            return new Byte("0");
        }
        if (sqlType == 1) {
            return new Character('0');
        }
        return null;
    }

    public static boolean isWrapperType(int sqlType) {
        if (sqlType == 4) {
            return true;
        }
        if (sqlType == 6) {
            return true;
        }
        if (sqlType == -5) {
            return true;
        }
        if (sqlType == 8) {
            return true;
        }
        if (sqlType == 5) {
            return true;
        }
        if (sqlType == 16) {
            return true;
        }
        if (sqlType == -6) {
            return true;
        }
        return sqlType == 1;
    }

    public static boolean isWrapperType(String className) {
        return wrapperTypes.contains(className);
    }

    public static boolean isNullValidDefaultForAttributeType(int sqlType) {
        if (sqlType == 4) {
            return false;
        }
        if (sqlType == 6) {
            return false;
        }
        if (sqlType == -5) {
            return false;
        }
        if (sqlType == 8) {
            return false;
        }
        if (sqlType == 5) {
            return false;
        }
        if (sqlType == 16) {
            return false;
        }
        if (sqlType == 1) {
            return false;
        }
        return sqlType != -6;
    }

    public static String getPrimitiveTypeFromWrapper(String wrapperType) {
        String primitiveType = null;
        if (wrapperType.equals(JAVA_LANG_STRING)) {
            primitiveType = JAVA_LANG_STRING;
        } else if (wrapperType.equals(JAVA_LANG_INTEGER)) {
            primitiveType = "int";
        } else if (wrapperType.equals(JAVA_LANG_BOOLEAN)) {
            primitiveType = "boolean";
        } else if (wrapperType.equals(JAVA_LANG_DOUBLE)) {
            primitiveType = "double";
        } else if (wrapperType.equals(JAVA_LANG_FLOAT)) {
            primitiveType = "float";
        } else if (wrapperType.equals(JAVA_LANG_LONG)) {
            primitiveType = "long";
        } else if (wrapperType.equals(JAVA_LANG_CHARACTER)) {
            primitiveType = "char";
        } else if (wrapperType.equals(JAVA_LANG_SHORT)) {
            primitiveType = "short";
        } else if (wrapperType.equals(JAVA_LANG_BYTE)) {
            primitiveType = "byte";
        }
        return primitiveType;
    }

    public static boolean isNullValidForAttributeType(int sqlType) {
        if (sqlType == 12) {
            return true;
        }
        if (sqlType == -1) {
            return true;
        }
        if (sqlType == 1111) {
            return true;
        }
        if (sqlType == 2000) {
            return true;
        }
        if (sqlType == 2003) {
            return true;
        }
        return sqlType == 0;
    }

    public static boolean wrapperTypeHasStringArgConstructor(int sqlType) {
        if (sqlType == 1) {
            return false;
        }
        if (sqlType == 4) {
            return true;
        }
        if (sqlType == 8) {
            return true;
        }
        if (sqlType == 6) {
            return true;
        }
        if (sqlType == 16) {
            return true;
        }
        if (sqlType == -1) {
            return true;
        }
        if (sqlType == 5) {
            return true;
        }
        if (sqlType == -5) {
            return true;
        }
        if (sqlType == -6) {
            return true;
        }
        return sqlType == 12;
    }

    public static AttributeTypeInterface createAttributeTypeFromClassName(AttributeTypeFactoryInterface atfi, String objectClassName) {
        int sqlType = NO_SQL_TYPE_DEFINED;
        String objectType = null;
        if (AttributeTypeUtility.isNonComplexType(objectClassName)) {
            sqlType = AttributeTypeUtility.getSQLDataType(objectClassName);
        } else if (AttributeTypeUtility.isWrapperType(objectClassName)) {
            String primitiveType = AttributeTypeUtility.getPrimitiveTypeFromWrapper(objectClassName);
            sqlType = AttributeTypeUtility.getSQLDataType(primitiveType);
        } else {
            if (objectClassName.equals(JAVA_SQL_DATE) || objectClassName.equals(JAVA_UTIL_DATE)) {
                return AttributeTypeFactory.DATE_ATTRIBUTE_TYPE;
            }
            if (objectClassName.equals(JAVA_SQL_TIME)) {
                return AttributeTypeFactory.TIME_ATTRIBUTE_TYPE;
            }
            if (objectClassName.equals(JAVA_SQL_TIMESTAMP)) {
                return AttributeTypeFactory.TIMESTAMP_ATTRIBUTE_TYPE;
            }
            if (objectClassName.equals(AttributeType.JAVA_LANG_OBJECT) || objectClassName.equals(AttributeType.OBJECT_CONSTANT)) {
                sqlType = 2000;
            } else {
                sqlType = 2000;
                objectType = objectClassName;
            }
        }
        return atfi.createAttributeType(null, sqlType, objectType);
    }

    public static Object transformAttributeValue(Object attributeValue, AttributeDescriptorInterface adi) {
        if (attributeValue instanceof List) {
            int listSize = ((List)attributeValue).size();
            if (listSize > 0) {
                for (int i = 0; i < listSize; ++i) {
                    Object value = ((List)attributeValue).get(i);
                    ((List)attributeValue).set(i, AttributeTypeUtility.transformValue(value, adi));
                }
                return attributeValue;
            }
            return attributeValue;
        }
        return AttributeTypeUtility.transformValue(attributeValue, adi);
    }

    protected static Object transformValue(Object attributeValue, AttributeDescriptorInterface adi) {
        AttributeTypeInterface ati = adi.getType();
        String attributeName = adi.getName();
        if (ati == null) {
            return attributeValue;
        }
        if (attributeValue instanceof String) {
            int sqlType = ati.getSQLType();
            if (sqlType == 2000 || sqlType == 1111) {
                String componentType = ati.getObjectType();
                if (componentType == null) {
                    throw new IllegalArgumentException(EntityRB.getStringResource("nullClassName.ex.txt"));
                }
                try {
                    Class<?> componentClass = Class.forName(componentType);
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{attributeValue.toString()};
                    Constructor<?> stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                    Object o = stringArgsConstructor.newInstance(stringArgs);
                    return o;
                }
                catch (Exception e) {
                    throw new IllegalStateException(MessageFormat.format(EntityRB.getStringResource("classCreationError.ex.txt"), componentType));
                }
            }
            if (sqlType == 91) {
                return AttributeTypeUtility.convertValueToDate(attributeValue);
            }
            if (sqlType == 92) {
                if (attributeValue instanceof Time || attributeValue instanceof java.util.Date) {
                    return attributeValue;
                }
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), attributeValue, attributeName));
            }
            if (sqlType == 93) {
                if (attributeValue instanceof Timestamp || attributeValue instanceof java.util.Date) {
                    return attributeValue;
                }
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), attributeValue, attributeName));
            }
            if (AttributeTypeUtility.wrapperTypeHasStringArgConstructor(sqlType)) {
                Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(sqlType, ati.getName());
                if (componentClass != null) {
                    if (AttributeTypeUtility.isColorStringClass(ati) && attributeValue != null) {
                        return attributeValue;
                    }
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{attributeValue.toString()};
                    try {
                        Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                        Object o = stringArgsConstructor.newInstance(stringArgs);
                        return o;
                    }
                    catch (Exception e) {
                        if (stringArgs[0] != null && ((String)stringArgs[0]).equals(EMPTY_STRING)) {
                            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), stringArgs));
                        }
                        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                    }
                }
                throw new IllegalArgumentException(EntityRB.getStringResource("nullClassName.ex.txt"));
            }
            throw new IllegalArgumentException(EntityRB.getStringResource("noStringConstructor.ex.txt"));
        }
        return attributeValue;
    }

    public static String transformValueToSASFormat(Object defaultValue, AttributeTypeInterface ati) {
        if (defaultValue == null) {
            return (String)defaultValue;
        }
        if (defaultValue instanceof List) {
            int listSize = ((List)defaultValue).size();
            if (listSize > 0) {
                StringBuffer valueString = new StringBuffer();
                for (int i = 0; i < listSize; ++i) {
                    Object value = ((List)defaultValue).get(i);
                    if (i > 0) {
                        valueString.append('\u001f');
                    }
                    valueString.append(AttributeTypeUtility.transformToSASFormat(value, ati));
                }
                return valueString.toString();
            }
            return defaultValue.toString();
        }
        return AttributeTypeUtility.transformToSASFormat(defaultValue, ati);
    }

    protected static String transformToSASFormat(Object defaultValue, AttributeTypeInterface ati) {
        if (ati == null) {
            if (defaultValue == null) {
                return null;
            }
            return defaultValue.toString();
        }
        if (ati.getSQLType() == 91) {
            SimpleDateFormat format1 = new SimpleDateFormat("ddMMMyyyy", Locale.US);
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            format1.setTimeZone(timeZone);
            java.util.Date date = null;
            if (defaultValue instanceof String) {
                date = (java.util.Date)AttributeTypeUtility.convertValueToDate(defaultValue);
            } else {
                DateFormat formatter = null;
                if (defaultValue instanceof Date) {
                    formatter = DateFormat.getDateInstance(2, Locale.getDefault());
                    formatter.setTimeZone(timeZone);
                } else {
                    formatter = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
                    formatter.setTimeZone(timeZone);
                }
                String dateString = formatter.format((java.util.Date)defaultValue);
                date = (java.util.Date)AttributeTypeUtility.convertValueToDate(dateString);
            }
            return format1.format(date);
        }
        if (AttributeTypeUtility.isColorStringClass(ati)) {
            if (defaultValue instanceof String) {
                String colorValue = COLOR_IDENTIFIER_CX + ((String)defaultValue).substring(2);
                return colorValue;
            }
            if (defaultValue instanceof Color) {
                int colorValue = ((Color)defaultValue).getRGB();
                String colorString = Integer.toHexString(colorValue);
                int stringLength = colorString.length();
                return COLOR_IDENTIFIER_CX + colorString.substring(stringLength - 6, stringLength);
            }
            if (defaultValue == null) {
                return null;
            }
            return defaultValue.toString();
        }
        if (defaultValue == null) {
            return null;
        }
        if (defaultValue.getClass().getName().equals("com.sas.MissingValues") && defaultValue.toString().equals("Dot")) {
            return ".";
        }
        return defaultValue.toString();
    }

    protected static Object convertValueToColor(Object defaultValue) {
        if (defaultValue instanceof List) {
            int listSize = ((List)defaultValue).size();
            if (listSize > 0) {
                for (int i = 0; i < listSize; ++i) {
                    Object value = ((List)defaultValue).get(i);
                    ((List)defaultValue).set(i, AttributeTypeUtility.convertToColor(value));
                }
                return defaultValue;
            }
            return defaultValue;
        }
        return AttributeTypeUtility.convertToColor(defaultValue);
    }

    protected static Object convertToColor(Object defaultValue) {
        if (defaultValue == null) {
            return defaultValue;
        }
        if (defaultValue instanceof String) {
            String tempName = (String)defaultValue;
            if (tempName.length() >= 2) {
                String identifier = tempName.substring(0, 2).toUpperCase();
                if (identifier.equals(COLOR_IDENTIFIER_0X) || identifier.equals(COLOR_IDENTIFIER_CX)) {
                    tempName = defaultValue.toString().substring(2, defaultValue.toString().length());
                    int tempNameLength = tempName.length();
                    if (tempNameLength <= 8) {
                        if (tempNameLength > 6) {
                            tempName = tempName.substring(tempNameLength - 6, tempNameLength);
                        }
                        try {
                            Integer o = Integer.valueOf(tempName, 16);
                            defaultValue = new Color(o);
                            return defaultValue;
                        }
                        catch (NumberFormatException ne) {
                            return defaultValue;
                        }
                    }
                    return defaultValue;
                }
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("colorValueNotValid.ex.txt"), defaultValue));
            }
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("colorValueNotValid.ex.txt"), defaultValue));
        }
        return defaultValue;
    }

    public static Object convertValueToDate(Object defaultValue) {
        if (defaultValue instanceof List) {
            int listSize = ((List)defaultValue).size();
            if (listSize > 0) {
                for (int i = 0; i < listSize; ++i) {
                    Object value = ((List)defaultValue).get(i);
                    ((List)defaultValue).set(i, AttributeTypeUtility.convertToDate(value));
                }
                return defaultValue;
            }
            return defaultValue;
        }
        return AttributeTypeUtility.convertToDate(defaultValue);
    }

    public static Object convertToDate(Object defaultValue) {
        if (defaultValue instanceof java.util.Date) {
            if (defaultValue instanceof EntityDate) {
                return defaultValue;
            }
            long dateValue = ((java.util.Date)defaultValue).getTime();
            EntityDate entityDate = new EntityDate(dateValue);
            return entityDate;
        }
        SimpleDateFormat format1 = new SimpleDateFormat("ddMMMyyyy", Locale.US);
        format1.setTimeZone(TimeZone.getTimeZone("GMT"));
        String value = (String)defaultValue;
        java.util.Date date = null;
        EntityDate entityDate = null;
        DateFormat dateFormatter = null;
        try {
            dateFormatter = DateFormat.getDateInstance(2, Locale.getDefault());
            dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            date = dateFormatter.parse(value);
            entityDate = new EntityDate(date.getTime());
            return entityDate;
        }
        catch (ParseException spe) {
            try {
                dateFormatter = DateFormat.getDateInstance(3, Locale.getDefault());
                dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                date = dateFormatter.parse(value);
                entityDate = new EntityDate(date.getTime());
                return entityDate;
            }
            catch (ParseException mpe) {
                try {
                    dateFormatter = DateFormat.getDateInstance(1, Locale.getDefault());
                    dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                    date = dateFormatter.parse(value);
                    entityDate = new EntityDate(date.getTime());
                    return entityDate;
                }
                catch (ParseException lpe) {
                    try {
                        date = format1.parse(value);
                        entityDate = new EntityDate(date.getTime());
                        return entityDate;
                    }
                    catch (ParseException zpe) {
                        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("dateValueNotValid.ex.txt"), value));
                    }
                }
            }
        }
    }

    public static Object createEntityDate(java.util.Date date) {
        SimpleDateFormat format1 = new SimpleDateFormat("ddMMMyyyy", Locale.US);
        format1.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format1.format(date);
    }

    protected static boolean validateValue(Object defaultValue, AttributeDescriptorInterface adi, boolean throwException, String attributeName) {
        boolean goodDefaultValue = false;
        AttributeTypeInterface ati = adi.getType();
        return AttributeTypeUtility.validateValue(defaultValue, ati, throwException, adi.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean validateValue(Object defaultValue, AttributeTypeInterface at, boolean throwException, String attributeName) {
        boolean goodDefaultValue = false;
        if (at == null) return true;
        if (at.getSQLType() == 0) {
            return true;
        }
        int sqlType = at.getSQLType();
        if (defaultValue == null) {
            if (AttributeTypeUtility.isNullValidForAttributeType(sqlType)) return true;
            if (!throwException) return goodDefaultValue;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), defaultValue, attributeName));
        }
        Class<?> defaultValueClass = defaultValue.getClass();
        if (sqlType == 2003) {
            if (!defaultValueClass.isArray()) {
                if (!throwException) return goodDefaultValue;
                throw new IllegalArgumentException(EntityRB.getStringResource("notArrayAttributeType.ex.txt"));
            }
            String componentType = at.getObjectType();
            if (defaultValueClass.getComponentType().getName().equals(componentType)) {
                return true;
            }
            if (!throwException) return goodDefaultValue;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("incorrectArrayType.ex.txt"), componentType));
        }
        if (sqlType == 91) {
            if (defaultValue instanceof java.util.Date) {
                return true;
            }
            if (defaultValue instanceof String) {
                return AttributeTypeUtility.isValidDate((String)defaultValue, attributeName, throwException);
            }
            if (!throwException) return false;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), defaultValue, attributeName));
        }
        if (sqlType == 92) {
            if (defaultValue instanceof Time) return true;
            if (defaultValue instanceof java.util.Date) {
                return true;
            }
            if (!throwException) return false;
            if (defaultValue == null || !defaultValue.toString().equals(EMPTY_STRING)) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), defaultValue, attributeName));
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
        }
        if (sqlType == 93) {
            if (defaultValue instanceof Timestamp) return true;
            if (defaultValue instanceof java.util.Date) {
                return true;
            }
            if (!throwException) return false;
            if (defaultValue == null || !defaultValue.toString().equals(EMPTY_STRING)) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), defaultValue, attributeName));
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
        }
        if (sqlType == 2000 || sqlType == 1111) {
            String componentType = at.getObjectType();
            Class componentClass = null;
            if (componentType == null) {
                return goodDefaultValue;
            }
            try {
                componentClass = Class.forName(componentType);
                if (componentClass.isAssignableFrom(defaultValueClass)) {
                    return true;
                }
                if (defaultValueClass.getName().equals(JAVA_LANG_STRING)) {
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{defaultValue.toString()};
                    try {
                        Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                        Object o = stringArgsConstructor.newInstance(stringArgs);
                        return true;
                    }
                    catch (Exception e) {
                        if (!throwException) return goodDefaultValue;
                        if (stringArgs[0] == null || !((String)stringArgs[0]).equals(EMPTY_STRING)) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), stringArgs));
                    }
                }
                if (!throwException) return goodDefaultValue;
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), componentClass.getName()));
            }
            catch (ClassNotFoundException stringArgsClass) {}
            return goodDefaultValue;
        } else {
            Class c = AttributeTypeUtility.getJavaClass(sqlType);
            if (c == null) {
                if (!throwException) return goodDefaultValue;
                throw new IllegalArgumentException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
            }
            String typeClassName = c.getName();
            String className = defaultValueClass.getName();
            String primitiveClassName = AttributeTypeUtility.getPrimitiveTypeFromWrapper(className);
            if (primitiveClassName == null || !primitiveClassName.equals(typeClassName)) {
                if (className.equals(JAVA_LANG_STRING)) {
                    if (typeClassName.equals(JAVA_AWT_COLOR)) {
                        return AttributeTypeUtility.isValidColor(defaultValue, attributeName, throwException);
                    }
                    if (AttributeTypeUtility.wrapperTypeHasStringArgConstructor(sqlType)) {
                        Class[] stringArgsClass = new Class[]{String.class};
                        Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(sqlType, null);
                        Object[] stringArgs = new String[]{defaultValue.toString()};
                        try {
                            Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                            Object o = stringArgsConstructor.newInstance(stringArgs);
                            return true;
                        }
                        catch (Exception e) {
                            if ((sqlType == 6 || sqlType == 8) && className.equals("com.sas.MissingValues")) {
                                return true;
                            }
                            if (!throwException) return goodDefaultValue;
                            if (stringArgs[0] == null || !((String)stringArgs[0]).equals(EMPTY_STRING)) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
                        }
                    }
                    if (!throwException) return goodDefaultValue;
                    throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), typeClassName));
                }
                if (className.equals(JAVA_AWT_COLOR)) {
                    if (!AttributeTypeUtility.isColorStringClass(at)) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), defaultValue, attributeName));
                    return true;
                }
                if ((sqlType == 6 || sqlType == 8) && className.equals("com.sas.MissingValues")) {
                    return true;
                }
                if (!throwException) return goodDefaultValue;
                if (defaultValue == null || !defaultValue.equals(EMPTY_STRING)) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), defaultValue, attributeName));
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), defaultValue));
            }
            if (!AttributeTypeUtility.isColorStringClass(at)) return true;
            return AttributeTypeUtility.isValidColor(defaultValue, attributeName, throwException);
        }
    }

    public static boolean validateDefaultValue(Object defaultValue, AttributeTypeInterface at, boolean throwException, String attributeName) {
        if (defaultValue == null) {
            return AttributeTypeUtility.validateValue(null, at, throwException, attributeName);
        }
        if (defaultValue instanceof List) {
            if (at != null && at.getSQLType() == 16) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("illegalListForBoolean.ex.txt"), attributeName));
            }
            int listSize = ((List)defaultValue).size();
            if (listSize > 0) {
                for (int i = 0; i < listSize; ++i) {
                    Object value = ((List)defaultValue).get(i);
                    boolean goodValue = AttributeTypeUtility.validateValue(value, at, throwException, attributeName);
                    if (goodValue) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return AttributeTypeUtility.validateValue(defaultValue, at, throwException, attributeName);
    }

    public static boolean validateAttributeValue(Object defaultValue, AttributeDescriptorInterface adi, boolean throwException) {
        String attributeName = adi.getName();
        if (defaultValue == null) {
            return AttributeTypeUtility.validateValue(null, adi, throwException, attributeName);
        }
        AttributeTypeInterface ati = adi.getType();
        if (defaultValue instanceof List) {
            if (ati != null && ati.getSQLType() == 16) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("illegalListForBoolean.ex.txt"), attributeName));
            }
            int listSize = ((List)defaultValue).size();
            if (listSize > 0) {
                for (int i = 0; i < listSize; ++i) {
                    Object value = ((List)defaultValue).get(i);
                    boolean goodValue = AttributeTypeUtility.validateValue(value, adi, throwException, attributeName);
                    if (goodValue) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return AttributeTypeUtility.validateValue(defaultValue, adi, throwException, attributeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validateDefaultValue(Object defaultValue, AttributeTypeInterface at, boolean throwException) {
        boolean goodDefaultValue = false;
        if (at == null) return true;
        if (at.getSQLType() == 0) {
            return true;
        }
        int sqlType = at.getSQLType();
        if (defaultValue == null) {
            if (AttributeTypeUtility.isNullValidForAttributeType(sqlType)) return true;
            if (!throwException) return goodDefaultValue;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("nullNotValid.ex.txt"), at.getType()));
        }
        Class<?> defaultValueClass = defaultValue.getClass();
        if (sqlType == 2003) {
            if (!defaultValueClass.isArray()) {
                if (!throwException) return goodDefaultValue;
                throw new IllegalArgumentException(EntityRB.getStringResource("notArrayAttributeType.ex.txt"));
            }
            String componentType = at.getObjectType();
            if (defaultValueClass.getComponentType().getName().equals(componentType)) {
                return true;
            }
            if (!throwException) return goodDefaultValue;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("incorrectArrayType.ex.txt"), componentType));
        }
        if (sqlType == 91) {
            if (defaultValue instanceof java.util.Date) {
                return true;
            }
            if (!(defaultValue instanceof String)) return goodDefaultValue;
            boolean goodDateValue = AttributeTypeUtility.validateDateValue((String)defaultValue);
            if (goodDateValue) {
                return true;
            }
            if (!throwException) return false;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("dateValueNotValid.ex.txt"), defaultValue));
        }
        if (sqlType == 2000 || sqlType == 1111) {
            String componentType = at.getObjectType();
            Class componentClass = null;
            if (componentType == null) {
                return goodDefaultValue;
            }
            try {
                componentClass = Class.forName(componentType);
                if (componentClass.isAssignableFrom(defaultValueClass)) {
                    return true;
                }
                if (defaultValueClass.getName().equals(JAVA_LANG_STRING)) {
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{defaultValue.toString()};
                    try {
                        Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                        Object o = stringArgsConstructor.newInstance(stringArgs);
                        return true;
                    }
                    catch (Exception e) {
                        if (!throwException) return goodDefaultValue;
                        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("attributeValueNotValid.ex.txt"), stringArgs));
                    }
                }
                if (!throwException) return goodDefaultValue;
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), componentClass.getName()));
            }
            catch (ClassNotFoundException stringArgsClass) {}
            return goodDefaultValue;
        } else {
            Class c = AttributeTypeUtility.getJavaClass(sqlType);
            if (c == null) {
                if (!throwException) return goodDefaultValue;
                throw new IllegalArgumentException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
            }
            String typeClassName = c.getName();
            String className = defaultValueClass.getName();
            String primitiveClassName = AttributeTypeUtility.getPrimitiveTypeFromWrapper(className);
            if (primitiveClassName == null || !primitiveClassName.equals(typeClassName)) {
                if (className.equals(JAVA_LANG_STRING)) {
                    if (typeClassName.equals(JAVA_AWT_COLOR)) {
                        boolean goodColorValue = AttributeTypeUtility.validateColorValue((String)defaultValue);
                        if (goodColorValue) {
                            return true;
                        }
                        if (!throwException) return false;
                        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("colorValueNotValid.ex.txt"), defaultValue));
                    }
                    if (AttributeTypeUtility.wrapperTypeHasStringArgConstructor(sqlType)) {
                        Class[] stringArgsClass = new Class[]{String.class};
                        Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(sqlType, null);
                        Object[] stringArgs = new String[]{defaultValue.toString()};
                        try {
                            Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                            Object o = stringArgsConstructor.newInstance(stringArgs);
                            return true;
                        }
                        catch (Exception e) {
                            if ((sqlType == 6 || sqlType == 8) && className.equals("com.sas.MissingValues")) {
                                return true;
                            }
                            if (!throwException) return goodDefaultValue;
                            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("attributeValueNotValid.ex.txt"), stringArgs));
                        }
                    }
                    if (!throwException) return goodDefaultValue;
                    throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), typeClassName));
                }
                if ((sqlType == 6 || sqlType == 8) && className.equals("com.sas.MissingValues")) {
                    return true;
                }
                if (!throwException) return goodDefaultValue;
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("attributeValueNotValid.ex.txt"), defaultValue));
            }
            if (at.getName() == null) return true;
            if (!at.getName().equals(COLOR_NAME)) return true;
            boolean goodColorValue = AttributeTypeUtility.validateColorValue((String)defaultValue);
            if (goodColorValue) {
                return true;
            }
            if (!throwException) return true;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("colorValueNotValid.ex.txt"), defaultValue));
        }
    }

    public static boolean validateColorValue(String value) {
        if (value == null) {
            return false;
        }
        String tempName = value;
        if (tempName.length() < 2) {
            return false;
        }
        String identifier = value.substring(0, 2).toUpperCase();
        if (identifier.equals(COLOR_IDENTIFIER_0X) || identifier.equals(COLOR_IDENTIFIER_CX)) {
            tempName = value.substring(2, value.length());
            int tempNameLength = tempName.length();
            if (tempNameLength > 8) {
                return false;
            }
            if (tempNameLength > 6) {
                tempName = tempName.substring(tempNameLength - 6, tempNameLength);
            }
            try {
                Integer o = Integer.valueOf(tempName, 16);
                Color j = new Color(o);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateDateValue(String value) {
        boolean retValue = false;
        SimpleDateFormat format1 = new SimpleDateFormat("ddMMMyyyy", Locale.US);
        java.util.Date date = null;
        DateFormat dateFormatter = null;
        try {
            dateFormatter = DateFormat.getDateInstance(2, Locale.getDefault());
            dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            date = dateFormatter.parse(value);
            retValue = true;
            return retValue;
        }
        catch (ParseException spe) {
            try {
                dateFormatter = DateFormat.getDateInstance(3, Locale.getDefault());
                dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                date = dateFormatter.parse(value);
                retValue = true;
            }
            catch (ParseException mpe) {
                try {
                    dateFormatter = DateFormat.getDateInstance(1, Locale.getDefault());
                    dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                    date = dateFormatter.parse(value);
                    retValue = true;
                }
                catch (ParseException lpe) {
                    try {
                        date = format1.parse(value);
                        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                        int length = value.length();
                        if (length < 4) {
                            retValue = false;
                        }
                        String yearField = value.substring(length - 4);
                        try {
                            int someInt = Integer.parseInt(yearField);
                            char c = value.charAt(1);
                            if (Character.isDigit(c) && value.length() == 9) {
                                retValue = true;
                            }
                            if (Character.isLetter(c) && value.length() == 8) {
                                retValue = true;
                            }
                            retValue = false;
                        }
                        catch (NumberFormatException nfe) {
                            retValue = false;
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            return retValue;
        }
    }

    public static boolean isColorStringClass(AttributeTypeInterface ati) {
        if (ati == null) {
            return false;
        }
        return ati.getSQLType() == 12 && ati.getName() != null && ati.getName().equals(COLOR_NAME);
    }

    public static boolean isColor(AttributeDescriptorInterface adi) {
        AttributeTypeInterface ati = adi.getType();
        if (ati == null) {
            return false;
        }
        if (AttributeTypeUtility.isColorStringClass(ati)) {
            return true;
        }
        return ati.getSQLType() == 2000 && ati.getObjectType() != null && ati.getObjectType().equals(JAVA_AWT_COLOR);
    }

    public static boolean isValidColor(Object colorObject, String attributeName, boolean throwException) {
        boolean goodAttributeType = false;
        if (colorObject == null) {
            if (throwException) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), null, attributeName));
            }
        } else if (colorObject.equals(EMPTY_STRING)) {
            if (throwException) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
            }
        } else if (colorObject instanceof Color) {
            goodAttributeType = true;
        } else {
            goodAttributeType = AttributeTypeUtility.validateColorValue(colorObject.toString());
            if (!goodAttributeType && throwException) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), colorObject.toString(), attributeName));
            }
        }
        return goodAttributeType;
    }

    public static boolean isValidDate(String dateString, String attributeName, boolean throwException) {
        boolean goodAttributeType = false;
        if (dateString == null) {
            if (throwException) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), null, attributeName));
            }
        } else if (dateString.equals(EMPTY_STRING)) {
            if (throwException) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
            }
        } else {
            goodAttributeType = AttributeTypeUtility.validateDateValue(dateString);
            if (!goodAttributeType && throwException) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), dateString, attributeName));
            }
        }
        return goodAttributeType;
    }

    public static Object transformDefaultValue(Object defaultValue, AttributeTypeInterface at) {
        if (at == null) {
            return defaultValue;
        }
        if (defaultValue instanceof String) {
            int sqlType = at.getSQLType();
            if (sqlType == 2000 || sqlType == 1111) {
                String componentType = at.getObjectType();
                if (componentType == null) {
                    throw new IllegalArgumentException(EntityRB.getStringResource("nullClassName.ex.txt"));
                }
                try {
                    Class<?> componentClass = Class.forName(componentType);
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{defaultValue.toString()};
                    Constructor<?> stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                    Object o = stringArgsConstructor.newInstance(stringArgs);
                    return o;
                }
                catch (Exception e) {
                    throw new IllegalStateException(MessageFormat.format(EntityRB.getStringResource("classCreationError.ex.txt"), componentType));
                }
            }
            if (sqlType == 91) {
                return AttributeTypeUtility.convertValueToDate(defaultValue);
            }
            if (AttributeTypeUtility.wrapperTypeHasStringArgConstructor(sqlType)) {
                Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(sqlType, at.getName());
                if (componentClass != null) {
                    if (at.getName() != null && at.getName().equals(COLOR_NAME) && defaultValue != null) {
                        return defaultValue;
                    }
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{defaultValue.toString()};
                    try {
                        Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                        Object o = stringArgsConstructor.newInstance(stringArgs);
                        return o;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("attributeValueNotValid.ex.txt"), stringArgs));
                    }
                }
                throw new IllegalArgumentException(EntityRB.getStringResource("nullClassName.ex.txt"));
            }
            throw new IllegalArgumentException(EntityRB.getStringResource("noStringConstructor.ex.txt"));
        }
        return defaultValue;
    }

    public static Object transformDefaultValue(Object defaultValue, AttributeTypeInterface ati, String attributeName) {
        if (ati == null) {
            return defaultValue;
        }
        if (defaultValue instanceof String) {
            int sqlType = ati.getSQLType();
            if (sqlType == 2000 || sqlType == 1111) {
                String componentType = ati.getObjectType();
                if (componentType == null) {
                    throw new IllegalArgumentException(EntityRB.getStringResource("nullClassName.ex.txt"));
                }
                try {
                    Class<?> componentClass = Class.forName(componentType);
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{defaultValue.toString()};
                    Constructor<?> stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                    Object o = stringArgsConstructor.newInstance(stringArgs);
                    return o;
                }
                catch (Exception e) {
                    throw new IllegalStateException(MessageFormat.format(EntityRB.getStringResource("classCreationError.ex.txt"), componentType));
                }
            }
            if (sqlType == 91) {
                return AttributeTypeUtility.convertValueToDate(defaultValue);
            }
            if (AttributeTypeUtility.wrapperTypeHasStringArgConstructor(sqlType)) {
                Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(sqlType, ati.getName());
                if (componentClass != null) {
                    if (AttributeTypeUtility.isColorStringClass(ati) && defaultValue != null) {
                        return defaultValue;
                    }
                    Class[] stringArgsClass = new Class[]{String.class};
                    Object[] stringArgs = new String[]{defaultValue.toString()};
                    try {
                        Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                        Object o = stringArgsConstructor.newInstance(stringArgs);
                        return o;
                    }
                    catch (Exception e) {
                        if (stringArgs[0] != null && ((String)stringArgs[0]).equals(EMPTY_STRING)) {
                            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), stringArgs));
                        }
                        throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                    }
                }
                throw new IllegalArgumentException(EntityRB.getStringResource("nullClassName.ex.txt"));
            }
            throw new IllegalArgumentException(EntityRB.getStringResource("noStringConstructor.ex.txt"));
        }
        return defaultValue;
    }

    public static boolean isValidMissingValueString(Object value) {
        if (value == null) {
            return false;
        }
        return missingValuesStrings.contains(value.toString());
    }

    static {
        NO_SQL_TYPE_DEFINED = Integer.MAX_VALUE;
        JAVA_LANG_STRING = "java.lang.String";
        JAVA_LANG_INTEGER = "java.lang.Integer";
        JAVA_LANG_FLOAT = "java.lang.Float";
        JAVA_LANG_LONG = "java.lang.Long";
        JAVA_LANG_DOUBLE = "java.lang.Double";
        JAVA_LANG_CHARACTER = "java.lang.Character";
        JAVA_LANG_SHORT = "java.lang.Short";
        JAVA_LANG_BOOLEAN = "java.lang.Boolean";
        JAVA_LANG_BYTE = "java.lang.Byte";
        EMPTY_STRING = "";
        JAVA_AWT_COLOR = "java.awt.Color";
        JAVA_SQL_TIME = "java.sql.Time";
        JAVA_SQL_TIMESTAMP = "java.sql.Timestamp";
        JAVA_SQL_DATE = "java.sql.DATE";
        JAVA_UTIL_DATE = "java.sql.DATE";
        wrapperTypes = new HashSet(6, 1.0f);
        wrapperTypes.add(JAVA_LANG_INTEGER);
        wrapperTypes.add(JAVA_LANG_BOOLEAN);
        wrapperTypes.add(JAVA_LANG_DOUBLE);
        wrapperTypes.add(JAVA_LANG_FLOAT);
        wrapperTypes.add(JAVA_LANG_LONG);
        wrapperTypes.add(JAVA_LANG_CHARACTER);
        wrapperTypes.add(JAVA_LANG_SHORT);
        wrapperTypes.add(JAVA_LANG_BYTE);
        typeInfo = new HashMap(24);
        typeInfo.put("String", new Integer(12));
        typeInfo.put(JAVA_LANG_STRING, new Integer(12));
        typeInfo.put("long", new Integer(-5));
        typeInfo.put("boolean", new Integer(16));
        typeInfo.put("char", new Integer(1));
        typeInfo.put("double", new Integer(8));
        typeInfo.put("float", new Integer(6));
        typeInfo.put("int", new Integer(4));
        typeInfo.put("Object", new Integer(2000));
        typeInfo.put("short", new Integer(5));
        typeInfo.put("byte", new Integer(-6));
        classInfo = new HashMap(60);
        classInfo.put(new Integer(2003), Array.class);
        classInfo.put(new Integer(-5), Long.TYPE);
        classInfo.put(new Integer(-2), byte[].class);
        classInfo.put(new Integer(16), Boolean.TYPE);
        classInfo.put(new Integer(2004), Blob.class);
        classInfo.put(new Integer(1), String.class);
        classInfo.put(new Integer(2005), Clob.class);
        classInfo.put(new Integer(91), Date.class);
        classInfo.put(new Integer(3), BigDecimal.class);
        classInfo.put(new Integer(2001), null);
        classInfo.put(new Integer(8), Double.TYPE);
        classInfo.put(new Integer(6), Float.TYPE);
        classInfo.put(new Integer(4), Integer.TYPE);
        classInfo.put(new Integer(2000), Object.class);
        classInfo.put(new Integer(-4), byte[].class);
        classInfo.put(new Integer(-1), String.class);
        classInfo.put(new Integer(0), null);
        classInfo.put(new Integer(2), BigDecimal.class);
        classInfo.put(new Integer(1111), null);
        classInfo.put(new Integer(7), Float.TYPE);
        classInfo.put(new Integer(2006), Ref.class);
        classInfo.put(new Integer(5), Short.TYPE);
        classInfo.put(new Integer(2002), Struct.class);
        classInfo.put(new Integer(92), Time.class);
        classInfo.put(new Integer(93), Timestamp.class);
        classInfo.put(new Integer(-6), Byte.class);
        classInfo.put(new Integer(-3), byte[].class);
        classInfo.put(new Integer(12), String.class);
        missingValuesStrings = new ArrayList(29);
        missingValuesStrings.add(".");
        missingValuesStrings.add("._");
        missingValuesStrings.add("_BLANK_");
        missingValuesStrings.add(".A");
        missingValuesStrings.add(".B");
        missingValuesStrings.add(".C");
        missingValuesStrings.add(".D");
        missingValuesStrings.add(".E");
        missingValuesStrings.add(".F");
        missingValuesStrings.add(".G");
        missingValuesStrings.add(".H");
        missingValuesStrings.add(".I");
        missingValuesStrings.add(".J");
        missingValuesStrings.add(".K");
        missingValuesStrings.add(".L");
        missingValuesStrings.add(".M");
        missingValuesStrings.add(".N");
        missingValuesStrings.add(".O");
        missingValuesStrings.add(".P");
        missingValuesStrings.add(".Q");
        missingValuesStrings.add(".R");
        missingValuesStrings.add(".S");
        missingValuesStrings.add(".T");
        missingValuesStrings.add(".U");
        missingValuesStrings.add(".V");
        missingValuesStrings.add(".W");
        missingValuesStrings.add(".X");
        missingValuesStrings.add(".Y");
        missingValuesStrings.add(".Z");
    }
}

